/* File EX_LDFNT.C: An example of the loadhanfont function */

#include <conio.h>

#include "ascii.h"
#include "hanlib.h"

#include "disptext.inc"

#define N_HANFONT 6

void main(void)
{
    int c, fontnum = -1;

    /* Initialize the library with no font registered */

    inithanlib(FIXRESMODE, HANDETECT, NULL, NULL);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA, CGA or EGA!", 1);

    /* Color mapping */

    hsetallcolormap();

    /* Load fonts to the memory */

    _maxhanfont = N_HANFONT;
    loadhanfont(0, "han10md1.fnt", HINFO10X4X4);
    loadhanfont(1, "han8gd1.fnt",  HINFO8X4X4);
    loadhanfont(2, "han412gs.fnt", HINFO4X1X2);
    loadhanfont(3, "han212md.fnt", HINFO2X1X2);
    loadhanfont(4, "han212gd.fnt", HINFO2X1X2);
    loadhanfont(5, "han113gd.fnt", HINFO1X1X3);
    loadengfont(0, "engmd1.fnt");
    changehanfont(0);

    /* Print usage */

    hputsxy(1, 1, "ESC a");

    /* Main loop */

    do {
        /* Change the Hangul font */

        changehanfont(fontnum = ++fontnum % N_HANFONT);

        /* Display text */

        display_text(fontnum);

        /* When space bar pressed, pause displaying */

        if ((c = getkey()) == ' ') while (!keypressed());

    } while (c != ESC);
}
