/* File EX_GNUM.C: An example of the hgetnumdata function */

#include <string.h>

#include "hanin.h"
#include "hanlib.h"

#define MAXLEN 20

void main(void)
{
    byte buffer[MAXLEN + 1], *picture;
    int result;

    /* Initialize the library, Fix-Res Mode, Autodetecting */

    inithanlib(FIXRESMODE, HANDETECT, DEFHANFONT, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA, CGA or EGA!", 1);

    hsetallcolormap();  /* Color mapping */

    /* Clear the entire screen */

    hsetbkcolor(HDARKGRAY);
    hclrscr();

    /* Print message */

    hgotoxy(1, 1);
    hsetcolor(HYELLOW);
    hsetbkcolor(HRED);
    hclrscrxy(1, 1, 80, 1);
    registerhanfont(HAN8GD1);
    hprintf("á aa b w q hgetnumdata \n\n");

    hsetcolor(HWHITE);
    hsetbkcolor(HBROWN);
    hclrscrxy(1, 3, 80, 8);
    registerhanfont(DEFHANFONT);
    hprintf(" qe ww á(: 1,234)i bi  e q\n"
            "(1)  i wi a sa.\n"
            "(2) aAa ១i ťbaA Жsa.\n");
    hprintf("(3)  ái i  sa.\n"
            "(4) A w b i Ȃ awsa.\n"
            "(5)  ai 0a e w Ȃ awsa.\n\n");

    /* Set a picture form */

    picture = "#9,999,999.999";

    /* Set a default number to a buffer                      */
    /* Note: strlen(buffer) must be greater                  */
    /*       than strlen(picture) - (number of commas) = 12! */

    strcpy(buffer, "1234.5      ");

    /* Set options of the hgetnumdata, alterable by user */

    _filltailblankzero = true;
    _numdataleftjustify = false;
    _cuttail = false;

    /* Get numeric data */

    hsetbkcolor(HLIGHTGRAY);
    hprintf("A (picture form) : %s\n", picture);
    hprintf("ww ái baAa  : ");

    hsetbkcolor(HBLACK);
    hsetreverse(true);
    result = hgetnumdata(buffer, picture);
    hsetreverse(false);

    /* Print result */

    hsetbkcolor(HLIGHTGRAY);
    if (result < NOERROR) hprintf("\n áA Aa sa.\n");
    else {
        hprintf("\nA wE w      : ");
        hsetbkcolor(HBLACK);
        hprintf("%s\n", buffer);
    }

    /* Wait for a key with a cursor blinking */

    hsetbkcolor(HRED);
    hprintf("\na iAa aAa...");
    _hangulmode = false;
    hgetch();
}
