/* File EX_GETLN.C: An example of the hgetln function */

#include <dos.h>
#include <string.h>

#include "ascii.h"
#include "extkey.h"
#include "hanin.h"
#include "hanlib.h"
#include "hanwout.h"

#define MAXLEN 40

window_t inputwin, usagewin, statuswin;

void define_windows(void)
{
    /* Input window */

    hsetwindow(&inputwin, 1, 1, 80, 6, HLIGHTGRAY, HBLUE, DEFWIN);

    /* Usage window */

    hsetwindow(&usagewin, 1, 8, 80, 23, HWHITE, HDARKGRAY, DEFWIN);
    wregisterhanfont(&usagewin, HAN8GD1);

    /* Status window */

    hsetwindow(&statuswin, 1, 25, 80, 25, HWHITE, HBLACK, &usagewin);
    wsetreverse(&statuswin, true);
}

void config_screen(void)
{
    int i;

    /* Print a ruler and mark an input field */

    hsetcurwindow(&inputwin);

    hclrscr();
    hgotoxy(31, 1);
    for (i = 1; i <= MAXLEN; i++) hputch('0' + i % 10);
    hsetreverse(true);
    hsetcolor(HWHITE);
    hprintfxy(31, 2, "%*s", MAXLEN, "");
    hsetreverse(false);

    /* Print usage */

    hsetcurwindow(&usagewin);

    hclrscr();

    hsetreverse(true);
    hputsxy( 1,  1, " aw e iA ");
    hsetreverse(false);
    hputsxy( 1,  2, "<Enter>       : b a");
    hputsxy( 1,  3, "<Shift-Space> : ei/w ");
    hputsxy( 1,  4, "<Ins>         : s/ ");
    hputsxy( 1,  5, "<Left>        :  e e ");
    hputsxy( 1,  6, "<Right>       :  e e ");
    hputsxy( 1,  7, "<Ctrl-Left>   :  e e ");
    hputsxy( 1,  8, "<Ctrl-Right>  :  e e ");
    hputsxy( 1,  9, "<Home>        : З 喁 ");
    hputsxy( 1, 10, "<End>         : З ҁ ");
    hputsxy(40,  2, "<ESC>       : b ᭡");
    hputsxy(40,  3, "<Backspace> : | ia bA/ei a ");
    hputsxy(40,  4, "<Del>       :  á e ia bA");
    hputsxy(40,  5, "<Ctrl-Y>    : A З bA");
    hputsxy(40,  6, "<Ctrl-T>    : e e bA");
    hputsxy(40,  7, "<Ctrl-G>    :  ҁ bA");

    hsetreverse(true);
    hputsxy(1, 12, " awa  iA b  ");
    hsetreverse(false);
    hputsxy(1, 13, " wȁ Ȃ:                  ) <Alt-1> Ԯ <Alt-7>");
    hputsxy(1, 14, "鯢/A鯢 ae :         ) <F8>");
    hputsxy(1, 15, "a b, Ήa w/q:   ) <F9>, <F10>");
    hputsxy(1, 16, "b iA b b a aw: ) <Alt-X>");

    hsetcurwindow(&inputwin);
}

void hookhangulmodetoggle(bool hangulmode)
{
    wputsxy(&statuswin, 1, 1, hangulmode ? " ei Գ" : " w Գ");
}

void hookinsertmodetoggle(bool insertmode)
{
    wputsxy(&statuswin, 9, 1, insertmode ? " s Գ" : "  Գ");
}

void hookmistyping(void)
{
    sound(1000);
    delay(100);
    nosound();
}

void hookhgetln(int *keycodep)
{
    htempcurwindow(&statuswin);

    /* Initialize the status line before any key input */

    if (keycodep == NULL) {
        hputsxy(17, 1, " E¬         Գ");
        hputsxy(43, 1, " 鯢 Գ");
        hputsxy(53, 1, " a w Գ");
        hputsxy(66, 1, " Ήa w ");
        hlastcurwindow();
    }

    /* Process user-defined keys */

    switch (*keycodep) {
    case ALT_1:
        hsetbufcursor(BOLDCURSOR, UNDERCURSOR, HYELLOW);
        hputsxy(17, 1, " e     ");
        break;
    case ALT_2:
        hsetbufcursor(OUTLINECURSOR, UNDERCURSOR, HYELLOW);
        hputsxy(17, 1, " E¬   ");
        break;
    case ALT_3:
        hsetbufcursor(THREEDCURSOR, UNDERCURSOR, HYELLOW);
        hputsxy(17, 1, " 3a    ");
        break;
    case ALT_4:
        hsetbufcursor(FRAMECURSOR, FRAMECURSOR, HYELLOW);
        hputsxy(17, 1, " A     ");
        break;
    case ALT_5:
        hsetbufcursor(SHADOWCURSOR, SHADOWCURSOR, HYELLOW);
        hputsxy(17, 1, " qw     ");
        break;
    case ALT_6:
        hsetbufcursor(UNDERCURSOR, UNDERCURSOR, HYELLOW);
        hputsxy(17, 1, "      ");
        break;
    case ALT_7:
        hsetbufcursor(REVERSECURSOR, REVERSECURSOR, HYELLOW);
        hputsxy(17, 1, " bw     ");
        break;
    case F8:
        if (ishan2board()) {
            hsethan390board(issplitmode());
            hputsxy(43, 1, " A鯢 Գ");
        } else {
            hsethan2board(issplitmode());
            hputsxy(43, 1, " 鯢 Գ");
        }
        break;
    case F9:
        _allowmistyping = !_allowmistyping;
        if (_allowmistyping) hputsxy(53, 1, " a w Գ");
        else hputsxy(53, 1, " a q Գ");
        break;
    case F10:
        if (issplitmode()) {
            hputsxy(66, 1, " Ήa q ");
            ishan2board() ? hsethan2board(false) : hsethan390board(false);
        } else {
            hputsxy(66, 1, " Ήa w ");
            ishan2board() ? hsethan2board(true) : hsethan390board(true);
        }
        break;
    case ALT_X:
        *keycodep = CR;  /* If *keycodep = CR or ESC, quit input */
        break;
    }

    hlastcurwindow();
}

void main(void)
{
    byte buffer[MAXLEN + 1] = "";
    int i;

    /* Initialize the library, Fix-Res Mode, Autodetecting */

    inithanlib(FIXRESMODE, HANDETECT, DEFHANFONT, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA, CGA or EGA!", 1);

    /* Register Hangul Graphics Characters */

    registerhgrfont(HGR1);

    /* Color mapping */

    for (i = 0; i <= MAXCOLORS; i++)
        hsetcolormap(i, (hgetmaxcolor() == MAXCOLORS) ? i : i / 15);

    /* Initialize the delay function */

    delay(0);

    /* Define windows and configure the screen */

    define_windows();
    config_screen();

    /* Set the shape and color of the cursor */

    hsetbufcursor(FRAMECURSOR, FRAMECURSOR, HYELLOW);

    /* Set hook vectors */

    _hookhangulmodetoggle = hookhangulmodetoggle;
    _hookinsertmodetoggle = hookinsertmodetoggle;
    _hookmistyping = hookmistyping;
    _hookhgetln = hookhgetln;

    /* Set a default string to the buffer */

    strcpy(buffer, "ei b ...");

    /* Set options for the hgetln function, alterable by user */

    _allowfirstdelline = true;
    _restoreline = true;

    /* Get a line from keyboard */

    _key.delafter = CTRL_G;
    hgotoxy(1, 2);
    hsetcolor(HLIGHTGRAY);
    hprintf("aa %daa baAa: ", MAXLEN);
    hsetcolor(HWHITE);
    hsetreverse(true);
    hgetln(buffer, MAXLEN);
    hsetreverse(false);

    /* Output results of the input */

    hgotoxy(1, 4);
    hprintf("bE w: \"%s\"\n", buffer);
    hprintf("ab bE iA ša: %#04x\n", _lastkey);

    /* Wait for a key with a cursor blinking */

    hsetbkcolor(HRED);
    hprintf("a iAa aAa...");
    _hangulmode = false;
    hgetch();
}
