/* File EX_ENLRG.C: An example of enlarged character output */

#include "hanlib.h"

void main(void)
{
    char msg[] = "eaa";
    int px, py, shift, cnt;

    inithanlib(FIXRESMODE, HANDETECT, HAN8GD1, ENGMD1);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA or CGA!", 1);

    /* Set enlarged size */

    hsetoutputmode(OVERWRITE_ENLARGE);
    hsetenlarge(1, 1);

    /* Output the message */

    for (shift = 0, py = 0; py + _CW->linespace - 1 <= hgetmaxpy();
         shift++, py += _CW->linespace) {
        hsetenlarge(shift + 1, shift + 1);
        for (px = 0, cnt = 0;
             px + shift + _CW->charspace * 2 - 1 < hgetmaxpx();
             px += _CW->charspace * 2, cnt += 2) {
            hsetcolor(15 - cnt / 2 % 2);
            hsetbkcolor(cnt / 2 % 15);
            hprintfpxy(px + shift, py, "%2.2s",
                       &msg[cnt % (sizeof(msg) - 1)]);
        }
    }

    /* Return to the normal size */

    hsetoutputmode(OVERWRITE);
    hsetbkcolor(HRED);
    hprintfxy(1, hgetmaxy(), "a iAa aAa...");

    pause();
}
