/* File EX_CMOD.C: An example of the changehan function */

#include "hanbgi.h"
#include "hanlib.h"

void config_screen(void)
{
    char s[3] = "\0\0\0";
    char msg[] = "eaa";
    int x, y;

    /* Background */

    for (y = 1; y <= hgetmaxy(); y++)
        for (x = 1; x <= hgetmaxx(); x += 2) {
            s[0] = msg[(x - 1) % 8];
            s[1] = msg[(x - 1) % 8 + 1];
            if ((x / 2 + y) % 2 == 0) {
                hsetreverse(true);
                hsetbkcolor(HWHITE);
                hsetcolor(_colormap[(x / 2 + y) % 16]);
            } else {
                hsetcolor(HWHITE);
                hsetbkcolor(_colormap[(x / 2 + y) % 16]);
            }
            hputsxy(x, y, s);
            hsetreverse(false);
        }

    /* Center box */

    hwindow(hgetmaxx() / 2 - 18, hgetmaxy() / 2 - 9,
            hgetmaxx() / 2 + 18, hgetmaxy() / 2 + 11);

    hsetcolor(HWHITE);
    hsetbkcolor(HRED);
    if (_isstdmode) hclrscr();
    else {
        setfillstyle(SLASH_FILL, RED);
        bar(_CW->left, _CW->top, _CW->right, _CW->bottom);
    }

    hsetoutputmode(OVERLAP);

    hputs("\n");
    hputs("  a   aϢ a Ȃ\r\n\n");
    hputs("    1    a (STDMODE)\r\n");
    hputs("    2    a (BGIMODE)\r\n");
    hputs("    3    a (FIXRESMODE)\r\n");
    hputs("    4    EGA 640x350x16(STDMODE)\r\n");
    hputs("    5    VGA 640x400x16(FIXRESMODE)\r\n");
    hputs("    6    VGA 640x480x16(STDMODE)\r\n");
    hputs("    7    SVGA 800x600x16(STDMODE)\r\n");
    hputs("    8    SVGA 800x600x16(BGIMODE)\r\n");

    hprintf("\n e aϢ a:\r\n");
    switch (_hanmode) {
    case HANHGC:
        hputs("   HGC 640x400x2");
        break;
    case HANEGA:
        hputs("   EGA 640x350x16");
        break;
    case HANVGA:
        hputs("   VGA 640x480x16");
        break;
    case HANVGA640X400:
        hputs("   VGA 640x400x16");
        break;
    case HANSVGA800LO:
        hputs("   SVGA 800x600x16");
        break;
    }
    if (_isstdmode) hputs("  BGI aw a\r\n");
    else hputs("  BGI aw aw\r\n");

    hprintf("\n A e a:\r\n");
    hprintf("   Baa x a (1 - %d)\r\n", hgetmaxax());
    hprintf("   Baa y a (1 - %d)\r\n", hgetmaxay());
    hprintf("   aϢ x a (0 - %d)\r\n", hgetmaxapx());
    hprintf("   aϢ y a (0 - %d)\r\n", hgetmaxapy());

    hsetoutputmode(OVERWRITE);
}

void change_mode(int user_mode)
{
    switch (user_mode) {
    case 1:
        changehan(STDMODE, HANDETECT, _CW);
        break;
    case 2:
        LINK_HGC_BGIdriver();
        LINK_EGA_BGIdriver();
        changehan(BGIMODE, HANDETECT, _CW);
        break;
    case 3:
        changehan(FIXRESMODE, HANDETECT, _CW);
        break;
    case 4:
        changehan(STDMODE, HANEGA, _CW);
        break;
    case 5:
        changehan(FIXRESMODE, HANVGA640X400, _CW);
        break;
    case 6:
        changehan(STDMODE, HANVGA, _CW);
        break;
    case 7:
        LINK_SVGA_all();
        changehan(HIRESSTDMODE, HANSVGA800LO, _CW);
        break;
    case 8:
        LINK_EGA_SVGABGIdriver();
        LINK_SVGA_all();
        changehan(HIRESBGIMODE, HANSVGA800LO, _CW);
        break;
    }

    if (hgraphresult() < NOERROR)
        puterr("Unsupported graphics mode selected!", 1);
}

void main(void)
{
    int i;
    int user_mode = '0';

    /* Initialize the library */

    inithanlib(STDMODE, HANDETECT, DEFHANFONT, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA or CGA!", 1);

    /* Color mapping */

    for (i = 0; i <= MAXCOLORS; i++)
        hsetcolormap(i, (hgetmaxcolor() == MAXCOLORS) ? i : i / 15);

    /* Main loop */

    for (; ; ) {
        config_screen();

        user_mode = getxch() - '0';
        if (user_mode < 1 || user_mode > 8) break;

        change_mode(user_mode);
    }
}
