/* File EX_CLRSC.C: An example of the hclrscr... functions */

#include "hanlib.h"

void main(void)
{
    int i;
    int x0, y0;

    inithanlib(FIXRESMODE, HANDETECT, DEFHANFONT, DEFENGFONT);
    if (hgraphresult() < NOERROR)
        puterr("This program does not run in MDA or CGA!", 1);

    for (i = 0; i <= MAXCOLORS; i++)
        hsetcolormap(i, (hgetmaxcolor() == MAXCOLORS) ? i : i % 2);

    hsetbkcolor(HDARKGRAY);
    hclrscr();

    x0 = 640 / 2, y0 = 400 / 2;
    for (i = MAXCOLORS; i >= 0; i--) {
        hsetbkcolor(_colormap[i]);
        hclrscrpxy(x0 - i * 14, y0 - i * 12, x0 + i * 14, y0 + i * 12);
    }

    pause();
}
