/* File DISPTEXT.INC: A Text Display Subroutine */

char *fontname[6] = {
    "    10 wA     HAN10MD1  ",
    "  8 A    HAN8GD1   ",
    " 4 A e  HAN412GS1 ",
    "  2 i w   HAN212MD1 ",
    "  2 i    HAN212GD1 ",
    "  1 A    HAN113GD1 ",
};

static byte *spec[] = {
    " e a a    a  ",
    "",
    " aw a: ᥡ C 2.0, a C++ ",
    "  A I: Small, Medium, Compact, Large I  ",
    "   a: HGC(Ia), EGA, VGA, SuperVGA, a  ",
    "  Ёw: 640x350, 640x400, 640x480, 800x600, 1024x768 ",
    "  w: e, 16, 256, 32768 ",
    "  ei ša: ww sw ša, TG ša(NKP ei), KSSM ša ",
    " w/⸁ awe ⷥ ei/w aw: E 14/13 ",
};


void display_text(int fontnum)
{
    int i;

    hsettextjustify(CENTER_TEXT);

    hsetreverse(true);
    hsetbkcolor(HWHITE), hsetcolor(HRED);
    hputsxy(hgetmaxx() / 2, 3, fontname[fontnum]);
    hsetreverse(false);

    hsetcolor(HWHITE), hsetbkcolor(_colormap[1 + fontnum]);
    for(i = 0; i < sizeof(spec) / sizeof(*spec); i++)
        hputsxy(hgetmaxx() / 2, 5 + i, spec[i]);

    hsetcolor(HLIGHTCYAN), hsetbkcolor(HBLACK);
    hsetunder(true);
    hputsxy(hgetmaxx() / 2, hgetmaxy() - 2,
            " aAaai ae q a. ");
    hsetunder(false);
}
