/*****************************************************
 *                                                   *
 *      Index table for combination code             *
 *      and character set for fixed code             *
 *                                                   *
 *      Sambo, Samsung, GoldStar, Old KS, DKBII      *
 *      and KSC5601, 7 Bit Fixed                     *
 *                                                   *
 *      Assembly programmed by Kim, J.W.             *
 *      C converted by Shin, S.D.                    *
 *      Source arranged & modified by Lim, Y.K.      *
 *                                                   *
 *****************************************************/

#include <string.h>
#include <stdlib.h>

#include "typedefs.h"

#pragma warn -ucp

typedef struct {
    unsigned c: 5;
    unsigned b: 5;
    unsigned a: 5;
    unsigned i: 1;
} hangul;

/* sw ša wѡ eŵA awAe ei q  */

char M1[5][32] = {
    {0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,0},
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,0,0},
    {0,1,2,0,3,0,0,4,5,6,0,0,0,0,0,0,0,7,8,9,0,10,11,12,13,14,15,16,17,18,19,0},
    {0,0,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,0,0,0},
    {0,1,2,3,4,5,6,7,8,9,10,11,0,0,0,0,0,0,0,0,0,0,0,12,13,14,15,16,17,18,19,0},
};

char M2[5][32] = {
    {0,0,0,1,2,3,4,5,0,0,6,7,8,9,10,11,0,0,12,13,14,15,16,17,0,0,18,19,20,21,0,0},
    {0,0,0,1,2,3,4,5,0,0,6,7,8,9,10,11,0,0,12,13,14,15,16,17,0,0,18,19,20,21,0,0},
    {0,0,1,2,3,4,5,6,0,0,7,8,9,10,11,12,0,0,13,14,15,16,17,18,0,0,19,20,21,0,0,0},
    {0,0,1,2,0,3,4,5,0,6,7,8,0,9,10,11,0,12,13,14,0,15,16,17,0,18,19,20,0,21,0,0},
    {0,0,0,1,2,3,4,5,0,0,6,7,8,9,10,11,0,0,12,13,14,15,16,17,0,0,18,19,20,21,0,0},
};

char M3[5][32] = {
    {0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,0,17,18,19,20,21,22,23,24,25,26,27,0,0},
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,0,0,0,0},
    {0,1,2,3,4,5,6,7,0,8,9,10,11,12,13,14,15,16,17,0,18,19,20,21,22,0,23,24,25,26,27,0},
    {0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,0,0,0},
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,00,0,0},
};

char MM1[5][20] = {
    {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20},
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19},
    {0,1,2,4,7,8,9,17,18,19,21,22,23,24,25,26,27,28,29,30},
    {9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28},
    {0,1,2,3,4,5,6,7,8,9,10,11,23,24,25,26,27,28,29,30},
};

char MM2[5][22]= {
    {2,3,4,5,6,7,10,11,12,13,14,15,18,19,20,21,22,23,26,27,28,29},
    {2,3,4,5,6,7,10,11,12,13,14,15,18,19,20,21,22,23,26,27,28,29},
    {31,2,3,4,5,6,7,10,11,12,13,14,15,18,19,20,21,22,23,26,27,28},
    {1,2,3,5,6,7,9,10,11,13,14,15,17,18,19,21,22,23,25,26,27,29},
    {2,3,4,5,6,7,10,11,12,13,14,15,18,19,20,21,22,23,26,27,28,29},
};

char MM3[5][28] = {
    {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,19,20,21,22,23,24,25,26,27,28,29},
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27},
    {0,1,2,3,4,5,6,7,9,10,11,12,13,14,15,16,17,18,20,21,22,23,24,26,27,28,29,30},
    {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28},
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27},
};

/* KSC5601 7a Ŭw šai e šaa */

byte *fixedcode[2] = {
    "abehijkqstuvwxy{|}"
    "ɈAEIQSUVWabcehiqsuvw"
    "{ŉɉˉщӉՉ׉A"
    "BEIQSUWaeisuՊ"
    "AEIabehijqsuwabce"
    "ikqsuvw{ABEQU"
    "Waeiuv{ɍ֍׍AEIQSWa"
    "ŎɎюӎ֎Aabegikpqs"
    "uw{abcehijkqsuvwxy{}"
    "ABEIQSUVWabeiq"
    "svwzőɑ֒AEIQSUabeisuw"
    "ABIQSWabeijkqsuwx|"
    "abcehijklpqsuvwxy}"
    "ABEIQSUVWaeivw"
    "ŕɕAEIQSUa"
    "זAEIQWabehikqsuw"
    "abeiqsuvw}ABEI"
    "QSUVWavəAEabeh"
    "iqsuabeiqsuvwx|}"
    "ABEIQSUWabeiqsuvw"
    "ŝםAEIQSUWaeisuw"
    "ABEIQSUWabeiqsuwx{|"
    "abeghijkqsuwx{}"
    "ABEIQSUVWabeiuvwy"
    "š֡עAEISUWaeisu"
    "AEIQUaeiquabcdehij"
    "klqsuw{ABE"
    "HIQSUVWabeisuvw{ť֥ABE"
    "IQSaeAEIQUWab"
    "eiqsuabeikqsuvw}"
    "AWabqsuvwAaw"
    "AWaeiqsabdehijkqsuvw{"
    "ŬɬѬ׬"
    "ABEIQSUVWabeiqsuvw"
    "ŭɭ׭AEIQSUabeiqsuw"
    "®ŮɮѮ׮ABIQUWabeijqsuw"
    "abdeiqsvw}"
    "AEIW±űֱAEIQSa"
    "Wabeikpqsabefgijkpqsu"
    "vw{|ŴɴӴ"
    "ABEIQSUWabceiklqstuvw{|}"
    "µŵɵѵӵյֵ׵A"
    "BEIQSUWabeiqsuw"
    "ŶɶѶӶ׶ABEIQSUWYabeioqsuwxyz{"
    "|}abeghikqsuvwx"
    "ŸɸABEIQSU"
    "Waeiqsvw¹ɹӹչ׹AEIQS"
    "UWabewAEIQabeiq"
    "suwabegilqsuvw"
    "AWav½ɽֽAEI"
    "QSwAaquwabegiqs"
    "uvwxABEIQSU"
    "WaevAEIQSUWaq"
    "¡¶AEIQWabeiqsuwáâåèéêñóõ÷"
    "abeiqsuwāĂąĉđēĕĖėġĢķABEIQ"
    "SUWaeiqsuvwŁšŢťũűųŵŷAIaƁƂƅƉ"
    "ƑƓƕƗơƥƩƷAEIQabeiqswǡǢǥǩǱǳ"
    "ǵǷabeijqsuvwȁȂȅȉȑȓȕȖȗȡȷAB"
    "EIQSUWaevɁɅɡɢɥɩɱɳɵɷɼAEUWaʁʂʅʉʑʓʕ"
    "ʗʡʶAEIQWabehikqsuˁ˅ˉˑ˓ˡˢ˥˩˱"
    "˳˵˷abceikqsuvw{̡̢̖̗́̂̅̉̑̓̕"
    "ABEIQSUWaeiqsvẃ͉͓͕ͥͩ͢͡ͱͳ͵ͷAEaeis"
    "u΁΂΅ΈΉ΋ΑΓΕΗΡηAEIQUWaeiqsuϡϢϥϩϱ"
    "ϳϵϷabeinqsuwЁЂЅЉБГЕЖЗСзABE"
    "IQSUWabeiqsuvwсхщѓѡѢѥѩѮѱѳѵѷѻ"
    "ABEISUWaeisuҁ҂҅҉Ҏґҕҗҡҥҩұҷ"
    "ABEIQUWabeghijqsuw{ӁӅӉӑӓӗӡӢӥ"
    "өӱӳӵӷ",
    "_U_V_W_X_Y_Y_Y_Z_[_\\_]_^___`_`_a_b_b_c_d_e_f_g_h_h_h_i_i_i_i_j_j_j_j_j"
    "_j_k_l_m_n_o_o_p_q_r_r_s_s_t_t_t_u_v_w_w_w_x_y_y_z_{_|_}_}_~`!`#`#`$`%"
    "`&`'`'`'`'`'`(`)`*`+`,`-`-`-`.`/`0`1`1`2`3`4`5`5`5`5`5`6`7`8`8`8`8`9`:"
    "`:`;`;`;`;`;`<`=`=`=`=`=`>`?`@`A`B`C`D`D`E`F`G`H`H`H`H`I`J`J`J`K`K`L`L"
    "`L`L`L`L`M`N`O`P`Q`R`S`S`T`U`V`W`X`Y`Y`Z`Z`[`[`\\`\\`]`]`^`^`^`_```a`b`c"
    "`d`d`e`f`f`f`g`h`i`i`i`j`j`j`j`j`j`j`j`j`k`l`m`m`m`n`o`o`o`p`q`q`q`q`q"
    "`q`r`r`r`s`s`s`s`t`u`v`v`w`x`y`y`z`{`|`}`~`~`~`~a@a@aAaBaBaBaBaBaBaCaD"
    "aEaFaGaHaIaIaIaIaIaJaJaJaJaKaKaKaKaKaKaKaLaLaLaLaLaLaMaMaNaOaPaPaPaQaQ"
    "aRaRaSaTaTaUaVaWaWaWaWaXaYaZa[a[a\\a]a]a^a_b@bAbBbCbDbEbFbGbGbHbIbJbKbL"
    "bMbNbObObObObObPbQbRbSbTbUbUbVbWbWbWbWbXbYbZb[b\\b]b]b]b^b^b^b_c@cAcAcB"
    "cBcCcDcEcEcEcFcGcHcIcIcJcKcLcMcNcOcOcOcOcPcQcQcQcQcQcQcRcRcRcRcRcRcScT"
    "cTcUcUcVcVcVcVcVcWcWcWcXcXcXcXcXcYcYcYcZcZcZc[c\\c]c^c_c_d@d@d@dAdBdCdD"
    "dDdDdEdFdGdHdHdIdJdJdKdKdLdMdNdOdPdQdRdSdSdTdUdVdWdWdXdXdYdZd[d\\d]d^d_"
    "d_e@e@eAeAeBeCeCeDeDeEeEeEeFeGeHeIeJeKeLeLeMeNeNeNeOeOePePePePePePePeP"
    "eQeReSeTeUeUeUeVeWeWeXeXeXeXeXeXeYeZe[e\\e]e^e_e_e_f@fAfBfCfDfEfEfFfGfH"
    "fHfHfIfIfIfIfJfJfKfKfKfKfKfLfMfNfOfPfPfQfRfSfTfTfUfVfWfXfYfZf[f\\f\\f]f^"
    "f_g@gAgBgCgCgCgCgDgDgEgEgFgFgGgGgGgGgHgIgJgKgLgLgMgMgMgMgNgNgOgPgPgPgQ"
    "gQgQgQgQgQgQgQgRgSgSgSgTgTgTgTgUgUgVgWgWgWgXgXgYgYgZg[g[g\\g\\g\\g]g^g_h@"
    "hAhBhBhChDhDhDhDhDhEhFhFhFhFhFhFhGhHhIhJhKhLhMhNhOhOhOhPhQhRhShThUhVhW"
    "hXhYhZh[h[h[h\\h]h^h_i@iAiBiCiDiEiFiGiHiIiJiKiKiLiLiMiNiOiPiQiRiSiTiUiV"
    "iViViViWiXiYiZi[i\\i]i^i^i^i^i^i_i_i_i_i_i_i_j@j@j@j@j@jAjBjCjDjEjFjGjH"
    "jHjIjIjIjIjIjIjIjIjIjIjJjKjLjMjNjNjNjOjPjQjRjSjTjUjVjWjWjWjXjYjZj[j\\j]"
    "j^j_k@kAkBkCkDkEkFkGkGkHkIkJkKkLkMkNkOkPkQkRkSkTkTkTkUkVkVkVkVkVkWkXkY"
    "kZkZk[k[k\\k]k]k]k^k_l@lAlBlBlClClClDlDlElFlFlFlGlHlHlIlJlKlLlMlMlNlOlP"
    "lQlQlQlQlQlQlQlQlQlQlQlRlRlRlRlRlSlTlUlVlWlXlXlXlYlYlZl[l[l\\l]l^l_l_m@"
    "m@m@m@m@mAmAmAmBmBmCmCmDmEmEmFmGmHmImJmJmKmLmLmLmMmNmOmPmQmRmRmSmTmUmV"
    "mVmWmXmYmZm[m\\m]m^m_n@nAnAnBnBnCnDnDnDnDnDnEnFnGnGnHnHnInJnKnLnMnNnNnO"
    "nOnPnPnPnPnPnQnRnSnTnUnVnWnWnXnYnYnYnZn[n[n\\n]n^n_o@oAoBoBoCoCoCoDoDoD"
    "oEoEoEoEoEoFoGoHoHoIoJoJoKoKoLoMoNoNoNoNoNoNoOoOoOoOoOoPoPoPoPoPoPoQoQ"
    "oRoSoSoSoSoToUoVoWoWoXoXoYoZo[o\\o]o^o_p@p@p@p@p@p@pApApBpCpDpEpFpFpGpG"
    "pGpGpGpHpIpIpJpKpLpLpLpLpMpNpNpOpOpOpOpOpOpOpPpPpPpPpPpQpRpRpRpRpSpTpU"
    "pVpWpWpWpWpWpXpYpZp[p[p\\p\\p\\p\\p\\p\\p\\p\\p]p^p^p_p_q@q@qAqBqCqDqEqFqGqHqI"
    "qJqKqLqLqLqLqMqNqNqNqOqOqOqPqQqQqQqQqQqQqRqSqTqTqUqUqVqVqVqWqXqYqZq[q["
    "q\\q]q^q_r@rArBrBrBrCrCrDrDrDrDrDrErErErErErErFrGrGrHrIrIrJrJrKrLrMrMrM"
    "rMrMrMrNrNrNrNrNrNrOrOrOrOrOrOrPrPrQrQrQrQrQrQrRrSrTrUrVrWrWrXrYrYrYrZ"
    "r[r[r\\r\\r\\r]r]r]r^r^r_s@s@sAsAsAsBsBsBsCsDsDsEsFsGsHsIsJsKsLsMsNsOsPsQ"
    "sRsSsTsUsVsWsXsYsZsZs[s\\s\\s\\s\\s]s^s_s_s_s_s_s_s_s_s_t@tAtBtCtCtCtCtDtE"
    "tFtFtFtFtGtGtGtHtItItItItItJtJtJtJtJtJtJtJtJtJtJtJtKtLtLtLtLtLtLtLtLtL"
    "tLtLtLtMtNtOtPtPtPtQtRtStStStStTtUtVtWtWtXtYtZt[t\\t]t^t_u@u@u@uAuBuCuD"
    "uEuFuFuGuHuIuJuKuLuLuLuLuMuNuOuPuQuRuSuSuSuTuUuVuWuWuWuWuXuYuZu[u\\u]u^"
    "u^u_v@vAvBvCvDvDvEvFvGvHvIvJvKvKvLvMvNvOvPvQvRvRvRvSvTvTvUvVvWvWvXvYvZ"
    "vZvZvZvZv[v[v\\v]v^v_w@wAwAwBwCwDwEwFwFwGwHwIwJwJwJwJwKwLwMwMwMwMwMwMwN"
    "wNwOwOwOwOwOwOwPwQwRwRwRwRwRwSwTwUwVwWwWwWwXwYwZw[w\\w]w^w_w_w_x@x@xAxA"
    "xBxCxCxCxCxDxDxExFxFxFxGxHxIxJxKxLxLxLxLxMxMxNxOxPxQxQxRxSxSxTxTxTxTxT"
    "xTxTxUxUxUxUxUxVxWxXxYxZxZx[x\\x]x^x_y@yAyByCyDyEyFyFyGyGyHyIyJyJyKyLyM"
    "yMyMyNyNyNyOyOyPyQyQyQyQyQyQyQyQyQyQyRySyTyUyVyWyXyYyZy[y\\y]y^y_y_y_z@"
    "z@zAzBzBzBzBzCzCzCzDzEzFzGzGzHzIzIzJzJzKzLzMzMzMzMzMzMzMzMzMzNzNzNzNzN"
    "zNzNzOzOzPzPzQzRzSzTzTzTzUzVzWzXzYzYzYzZzZzZzZzZzZzZz[z[z[z[z\\z]z^z_{!"
    "{#{#{${%{&{'{'{({){*{+{,{-{.{/{0{1{2{3{3{4{5{5{5{5{5{6{7{7{7{7{7{7{7{8"
    "{9{9{9{9{:{;{<{={={={={={>{>{>{>{>{?{@{@{@{@{@{@{@{A{A{A{A{A{A{A{A{A{A"
    "{A{A{A{B{C{C{D{D{D{D{D{D{D{D{D{E{F{F{F{G{H{I{J{J{J{J{K{L{M{N{O{P{Q{R{S"
    "{T{U{V{W{X{Y{Z{Z{[{[{[{[{\\{]{]{]{]{]{]{^{_{`{a{b{c{d{d{e{f{g{g{h{h{h{h"
    "{h{i{i{j{j{j{j{k{l{m{n{n{n{o{p{p{p{q{q{r{r{r{r{r{r{r{r{r{s{t{u{v{w{x{x"
    "{y{z{z{{{{{|{|{|{|{|{|{|{}{}{}{}{}{~|!|!|!|#|#|#|$|%|&|'|'|(|(|)|*|+|,"
    "|-|.|/|0|1|1|1|2|3|3|4|5|6|7|7|7|7|7|7|7|8|9|:|:|;|<|=|>|?|?|@|@|A|B|B"
    "|B|C|C|D|E|F|F|F|F|G|G|G|H|I|J|K|L|L|M|N|N|N|N|N|N|N|O|O|O|O|P|P|Q|Q|R"
    "|R|R|R|S|S|S|S|S|S|S|T|T|U|U|U|U|U|U|V|V|V|V|W|W|X|Y|Z|Z|Z|[|\\|]|^|_|_"
    "|`|a|b|c|d|e|e|f|g|h|h|i|j|k|l|m|n|n|n|n|o|o|o|p|q|r|s|s|t|u|u|u|v|w|x"
    "|y|z|{|{|{|{|{|{|{|{|{|||}|~}!}#}$}$}%}%}%}%}%}&}&}&}&}&}'}(}(})})})})"
    "}*}*}*}*}+}+}+}+}+}+}+},},},},},}-}.}/}/}0}0}1}1}2}3}3}3}3}3}4}5}6}7}8"
    "}9}9}:};}<}=}>}?}?}@}A}B}C}D}E}F}G}H}H}H}H}H}H}I}I}I}J}K}L}M}N}N}N}O}O"
    "}P}P}Q}R}R}R}R}R}S}T}U}U}U}U}V}W}W}W}W}X}Y}Z}[}\\}\\}\\}]}]}]}]}]}^}^}^}^"
    "}^}_}`}a}a}b}b}c}c}d}e}e}e}e}e}e}e}e}f}f}f}f}f}f}g}h}i}j}j}j}k}l}m}n}o"
    "}p}q}r}s}t}u}v}v}w}x}y}z}{}|}}}}}~}~~!~#~$~$~%~&~&~'~(~(~)~)~*~+~,~-~."
    "~/~/~/~/~/~0~1~2~3~4~5~5~6~7~8~8~8~8~9~:~;~<~<~=~>~?~@~@~A~B~C~D~E~F~F"
    "~F~F~F~F~G~H~H~H~H~H~I~J~J~J~J~J~K~L~M~N~N~O~P~P~P~Q~R~R~R~S~S~S~S~S~T"
    "~T~T~U~V~V~V~V~W~W~W~W~W~W~X~Y~Z~[~[~[~\\~]~^~_~_~`~a~b~c~c~c~c~c~d~d~e"
    "~f~g~g~h~~"
};

/*
 * b ei šaA ae aϢ ša Ai
 *
 *  Գ  Կ     Դ    Ժ  Ի Լ    Թ  
 *  0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19 20 21
 */
byte GR[7][45] = {
    {212,196,212,179,212,218,212,191,212,217,212,192,212,195,212,194,212,180,
     212,193,212,197,212,205,212,186,212,201,212,187,212,188,212,200,212,204,
     212,203,212,185,212,202,212,206},
    {246,196,246,179,246,218,246,191,246,217,246,192,246,195,246,194,246,180,
     246,193,246,197,246,205,246,186,246,201,246,187,246,188,246,200,246,204,
     246,203,246,185,246,202,246,206},
    { 29, 29, 28, 32, 21, 29, 25, 32, 23, 32, 22, 29,  1, 29, 31, 29,  2, 32,
      30, 29,  5, 29, 29, 29, 28, 32, 21, 29, 25, 32, 23, 32, 22, 29,  1, 29,
      31, 29,  2, 32, 30, 29,  5, 29},
    {244,196,244,179,244,218,244,191,244,217,244,192,244,195,244,194,244,180,
     244,193,244,197,244,205,244,186,244,201,244,187,244,188,244,200,244,204,
     244,203,244,185,244,202,244,206},
    {196,196,179, 32,218,196,191, 32,217, 32,192,196,195,196,194,196,180, 32,
     193,196,197,196,205,205,186, 32,201,205,187, 32,188, 32,200,205,204,205,
     203,205,185, 32,202,205,206,205},
    {196,196,179, 32,218,196,191, 32,217, 32,192,196,195,196,194,196,180, 32,
     193,196,197,196,205,205,186, 32,201,205,187, 32,188, 32,200,205,204,205,
     203,205,185, 32,202,205,206,205},
    {166,161,166,162,166,163,166,164,166,165,166,166,166,167,166,168,166,169,
     166,170,166,171,166,172,166,173,166,174,166,175,166,176,166,177,166,178,
     166,179,166,180,166,181,166,182},
};

/* Comparing routine for binary search */
int compare(const byte *p1, const byte *p2)
{
    if (*p1 != *p2) return (*p1 - *p2);
    else return (*(p1 + 1) - *(p2 + 1));
}

/*
 *  q sw ša(0) 7a Ŭw ša(1) a e
 *
 *  ) hgconv(0, 1, hg): q sw šai 7a Ŭw ša
 */
int hgconv(int s, int d, byte *hg)
{
    byte *p,*p1;
    int loc;

    p = bsearch(hg, fixedcode[s], 2350, 2, (int (*)())compare);
    if (p == NULL) return ERROR;

    if (s != 0) {         /* case of 7bit */
        do p1 = p, p -= 2;
        while (*(p1 + 1) == *(p + 1));
        p = p1;
    }

    loc = (int)(p - fixedcode[s]);
    *hg = fixedcode[d][loc];
    *(hg + 1) = fixedcode[d][loc + 1];

    return NOERROR;
}

/*
 *  sw šae wѡ e
 *
 *  1: q sw    2: q sw
 *  3: q sw    4: Old KS sw
 *  5: DKBII sw
 *
 *  ) comb2comb(1, 3, hg): q sw šai q sw ša
 */
int comb2comb(int s, int d, byte *hg)
{
    hangul ch;
    byte *p;

    s--, d--;
    p = (byte *)&ch;
    *(p + 1) = hg[0], *p = hg[1];
    ch.a = MM1[d][M1[s][ch.a]];
    ch.b = MM2[d][M2[s][ch.b]];
    ch.c = MM3[d][M3[s][ch.c]];
    hg[0] = *(p + 1), hg[1] = *p;

    return NOERROR;
}

/*
 *  q sw ša(0)a 7a Ŭw ša(1)i KSC5601 Ŭw ša e
 *
 *  ) tocomplete(0, hg): q sw šai KSC5601 Ŭw ša
 *      tocomplete(1, hg): 7a Ŭw šai KSC5601 Ŭw ša
 */
int tocomplete(int s, byte *hg)
{
    bool iskss, ishanja;
    byte *p,*p1;
    int loc, c2, ksspos, hanjapos;

    if (hg[0] >= 0xd9 && hg[0] <= 0xde) {
        iskss = true;
        c2 = hg[1];
        if ((c2 -= 0x31) < 0) iskss = false;
        else if (c2 <= 0x4d) ;
        else if ((c2 -= 0x12) < 0) iskss = false;
        else if (c2 <= 0xbb) ;
        else iskss = false;
        if (!iskss) return ERROR;
        ksspos = (hg[0] - 0xd9) * 94 * 2 + c2;

        hg[0] = 0xa1 + ksspos / 94;
        hg[1] = 0xa1 + ksspos % 94;

        return NOERROR;
    } else if (hg[0] >= 0xe0 && hg[0] <= 0xf9) {
        ishanja = true;
        c2 = hg[1];
        if ((c2 -= 0x31) < 0) ishanja = false;
        else if (c2 <= 0x4d) ;
        else if ((c2 -= 0x12) < 0) ishanja = false;
        else if (c2 <= 0xbb) ;
        else ishanja = false;
        if (!ishanja) return ERROR;
        hanjapos = (hg[0] - 0xe0) * 94 * 2 + c2;

        hg[0] = 0xb0 + hanjapos / 94;
        hg[1] = 0xa1 + hanjapos % 94;

        return NOERROR;
    }

    p = bsearch(hg, fixedcode[s], 2350, 2, (int (*)())compare);
    if (p == NULL) return ERROR;

    if (s != 0) {
        do p1 = p, p -= 2;
        while (*(p1 + 1) == *(p + 1));
        p = p1;
    }

    loc = (int)(p - fixedcode[s]) / 2;
    *hg = (loc / 94) + 0xb0;
    *(hg + 1)= (loc % 94) + 0xa1;

    return NOERROR;
}

/*
 *  KSC5601 Ŭw šai q sw ša(0)a 7a Ŭw ša(1) e
 *
 *  ) tocombi(0, hg): KSC5601 Ŭw šai q sw ša
 */
int tocombi(int d, byte *hg)
{
    bool iskss, ishanja;
    byte *p;
    int loc, c2, ksspos, hanjapos;

    if (hg[0] >= 0xa1 && hg[0] <= 0xac) {
        iskss = true;
        c2 = hg[1];
        if ((c2 -= 0xa1) < 0) iskss = false;
        else if (c2 >= 0x5e) iskss = false;

        if (!iskss) return ERROR;
        ksspos = (hg[0] - 0xa1) * 94 + c2;

        hg[0] = 0xd9 + ksspos / 94 / 2;
        hg[1] = 0x31 + ksspos % (94 * 2);
        if (hg[1] > 0x7e) hg[1] += 0x12;

        return NOERROR;
    } else if (hg[0] >= 0xe0 && hg[0] <= 0xf9) {
        ishanja = true;
        c2 = hg[1];
        if ((c2 -= 0xa1) < 0) ishanja = false;
        else if (c2 >= 0x5e) ishanja = false;

        if (!ishanja) return ERROR;
        hanjapos = (hg[0] - 0xa1) * 94 + c2;

        hg[0] = 0xe0 + hanjapos / 94 / 2;
        hg[1] = 0x31 + hanjapos % (94 * 2);
        if (hg[1] > 0x7e) hg[1] += 0x12;

        return NOERROR;
    }

    loc = (*hg - 176) * 94;
    loc += (*(hg + 1) - 161);
    p = fixedcode[d] + loc * 2;
    *hg = *p;
    *(hg + 1) = *(p + 1);

    return NOERROR;
}

/*
 *  7a ei šae  wѡ e

 *  '1': q sw    '2': q sw
 *  '3': q sw    '4': Old KS sw
 *  '5': DKBII sw   '7': 7a Ŭw
 *  'F': KSC5601 Ŭw
 *
 *  ) htrans('F', '1', hg): KSC5601 Ŭw šai q sw ša
 *      htrans('1', 'F', hg): q sw šai KSC5601 Ŭw ša
 */
int htrans(byte s, byte d, byte *hg)
{
    int si, di, xcode;

    if (s == d) return NOERROR;
    si = s - '0', di = d - '0';
    if (si < 6 && di < 6) return comb2comb(si, di, hg);

    switch (si) {
    case 2:
    case 3:
        comb2comb(si, 1, hg);
    case 1:
        if(d == '7') return hgconv(0, 1, hg);
        return tocomplete(0, hg);
    case 7:
        if(d == 'F') return tocomplete(1, hg);
        if (hgconv(1, 0, hg) != 0) return ERROR;
        if (di > 1) comb2comb(1, di, hg);
        break;
    case 22:
        if (d == '7') return tocombi(1, hg);
        xcode = tocombi(0, hg);
        if (di > 1) comb2comb(1, di, hg);
        return xcode;
    }

    return NOERROR;
}
