#
# Code for splitting menus
#
# Needs the th_gensym procedure.

# Determines the configuration of menuentry index in menu
proc th_menuentry_configuration {menu index} {
  set result ""
  foreach config [$menu entryconfigure $index] {
    if {[lindex $config 4] != ""} {
      lappend result [lindex $config 0] [lindex $config 4]
  }}
  return $result
}

# Determines if menuentry index in menu is a command, radiobutton, etc.
# Kind of a hack since there is no Tk command to do this; we examine the
# configure stuff to see what options are legit.
proc th_menuentry_class {menu index} {

# Separators are unique that they have no config options.
  if {[llength [$menu entryconfigure $index]] == 0} {return separator}

# Only cascade entries have a -menu option
  if {![catch "$menu entryconfigure $index -menu"]} {return cascade}

# Only radiobutton entries have a -value option
  if {![catch "$menu entryconfigure $index -value"]} {return radiobutton}

# For checkbuttons, it's -onvalue and -offvalue
  if {![catch "$menu entryconfigure $index -onvalue"]} {return checkbutton}

# Can't be anything else...must be command
  return command
}

# Copies a range of menuentries from source menu to dest menu
proc th_copymenuentries {source dest {start 0} {end last}} {
  set last [$source index $end]
# Now last is an index number
  for {set index $start} {$index <= $last} {incr index} {
    eval $dest add [th_menuentry_class $source $index] \
                   [th_menuentry_configuration $source $index]
}}

# If start and end in menu are going to be copied into a submenu, what should
# their cascade entry's label be?
proc th_cascade_label {menu start end} {
  if {[catch {$menu entryconfigure $start -label}]} {set start_num $start
  } else {
    set start_label [lindex [$menu entryconfigure $start -label] 4]
    if {[string match "ITEMS: * - *" $start_label]} {
      set start_num [lindex $start_label 1]
    } else {set start_num $start}}
  if {[catch {$menu entryconfigure $end -label}]} {set end_num $end
  } else {
    set end_label [lindex [$menu entryconfigure $end -label] 4]
    if {[string match "ITEMS: * - *" $end_label]} {
      set end_num [lindex $end_label 3]
    } else {set end_num $end}}

  return "ITEMS: $start_num - $end_num"
}

# Splits menu into a bunch of cascade menus, with maximum length size.
# Algo:
#  -Find the last n menuentries, break them into a submenu, and add a cascade
#   in their place.
#  -Do this with the next to last n menuentries, and up to the beginning until
#   there are less than n entries remaining.
#  -If the menu has less than n entries total, we're done.
#  -Otherwise, repeat.
proc th_split_menu {menu n} {
  while {[$menu index last] > [expr $n - 1]} {
    set cmds ""
    set end_submenu [$menu index last]
    while {$end_submenu > [expr $n - 2]} {
      set new_menu [winfo parent $menu].[th_gensym]
      menu $new_menu   
      set start_submenu [expr $end_submenu - $n + 1]
      th_copymenuentries $menu $new_menu $start_submenu $end_submenu
      set cmds "$menu add cascade -menu $new_menu \
        -label \"[th_cascade_label $menu $start_submenu $end_submenu]\" ; $cmds"
      $menu delete $start_submenu $end_submenu
      set end_submenu [expr $start_submenu - 1]
  }
  eval $cmds
}}

