static char rcsid[] = "$Id: wwwdemo.c,v 1.2 1994/08/04 23:49:41 sls Exp $";

/*
 * This software is copyright (C) 1994 by the Lawrence Berkeley Laboratory.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "tcl.h"
#include "../narray.h"
#if STDC_HEADERS || HAVE_STRING_H
#  include <string.h>
#  if !STDC_HEADERS && HAVE_MEMORY_H
#    include <memory.h>
#  endif
#else
#  include <strings.h>
#endif
#include <sys/time.h>
#include <sys/resource.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
 
#ifdef HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif

extern int main();
int *tclDummyMainPtr = (int *) main;

static char* commands_to_destroy[] = {
    "auto_execok",
    "auto_load",
    "auto_mkindex",
    "auto_reset",
    "cd",
    "close",
    "eof",
    "exec",
    "file",
    "flush",
    "gets",
    "glob",
    "open",
    "pid",
    "puts",
    "pwd",
    "read",
    "seek",
    "send",
    "source",
    "tell",
    "unknown",
    0
};

static int SimpleSourceCmd(ClientData data, Tcl_Interp* interp,
			   int argc, char** argv)
{
    static int count;
    if (count != 0) {
	Tcl_AppendResult(interp, "source invoked more than once", 0);
	return TCL_ERROR;
    }
    if (argc != 2) {
	Tcl_AppendResult(interp, "wrong # args, should be \"", argv[0],
			 " file\"", 0);
	return TCL_ERROR;
    }
    count++;
    if (Tcl_EvalFile(interp, argv[1]) != TCL_OK)
	return TCL_ERROR;
    return TCL_OK;
}

static int PutsStdoutCmd(ClientData data, Tcl_Interp* interp,
			 int argc, char** argv)
{
    char* format;
    char* string;
    if (argc < 2 || argc > 3) {
	Tcl_AppendResult(interp, "wrong # args, should be \"", argv[0],
			 " ?-nonewline? string\"", 0);
	return TCL_ERROR;
    }
    if (argc == 3) {
	if (!strncmp(argv[1], "-nonewline", strlen(argv[1]))) {
	    string = argv[2];
	    format = "%s";
	} else {
	    Tcl_AppendResult(interp, "unknown option \"", argv[1],
			     "\", should be -nonewline", 0);
	    return TCL_ERROR;
	}
    } else {
	string = argv[1];
	format = "%s\n";
    }
    printf(format, string);
    return TCL_OK;
}

static int SimpleReadStdinCmd(ClientData data, Tcl_Interp* interp,
			      int argc, char** argv)
{
    char* buf;
    int len, n;
    if (argc != 2) {
	Tcl_AppendResult(interp, "wrong # args, should be \"", argv[0],
			 " n-bytes\"", 0);
	return TCL_ERROR;
    }
    if (Tcl_GetInt(interp, argv[1], &len) != TCL_OK)
	return TCL_ERROR;
    buf = (char*) ckalloc(len+1);
    n = fread(buf, 1, len, stdin);
    if (n == -1) {
	Tcl_AppendResult(interp, "read failed: ", Tcl_PosixError(interp), 0);
	ckfree(buf);
	return TCL_ERROR;
    }
    buf[n] = '\0';
    Tcl_SetResult(interp, buf, TCL_DYNAMIC);
    return TCL_OK;
}

static int SetRLimitCmd(ClientData data, Tcl_Interp* interp,
			int argc, char** argv)
{
    struct rlimit rlim;
    int resource, len, val;
    if (argc != 3) {
	Tcl_AppendResult(interp, "wrong # args, should be \"", argv[0],
			 " resource value\"", 0);
	return TCL_ERROR;
    }
    len = strlen(argv[1]);
    if (!strncmp(argv[1], "cputime", len))
	resource = RLIMIT_CPU;
    else if (!strncmp(argv[1], "filesize", len))
	resource = RLIMIT_FSIZE;
    else if (!strncmp(argv[1], "datasize", len))
	resource = RLIMIT_DATA;
    else if (!strncmp(argv[1], "stacksize", len))
	resource = RLIMIT_STACK;
    else if (!strncmp(argv[1], "coredumpsizeize", len))
	resource = RLIMIT_CORE;
    else {
	Tcl_AppendResult(interp, "unknown resource \"", argv[1],
   "\", must be one of: cputime, filesize, datasize, stacksize, coredumpsize",
			 0);
	return TCL_ERROR;
    }
    if (Tcl_GetInt(interp, argv[2], &val) != TCL_OK)
	return TCL_ERROR;
    if (getrlimit(resource, &rlim) == -1) {
	Tcl_AppendResult(interp, "getrlimit failed: ",
			 Tcl_PosixError(interp), 0);
	return TCL_ERROR;
    }
    rlim.rlim_cur = val;
    if (setrlimit(resource, &rlim) == -1) {
	Tcl_AppendResult(interp, "setrlimit failed: ",
			 Tcl_PosixError(interp), 0);
	return TCL_ERROR;
    }
    return TCL_OK;
}

int Tcl_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{
    int i;
    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (NArray_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    for (i = 0; commands_to_destroy[i]; i++) {
	Tcl_DeleteCommand(interp, commands_to_destroy[i]);
    }
    Tcl_CreateCommand(interp, "source", SimpleSourceCmd, 0, 0);
    Tcl_CreateCommand(interp, "puts", PutsStdoutCmd, 0, 0);
    Tcl_CreateCommand(interp, "read_stdin", SimpleReadStdinCmd, 0, 0);
    Tcl_CreateCommand(interp, "setrlimit", SetRLimitCmd, 0, 0);
    tcl_RcFileName = 0;
    return TCL_OK;
}
