################################################################
####	       Picasso customization file                   ####
################################################################

######## READ THIS -- READ THIS -- READ THIS ########

# This file contains tcl variable assignments, i.e. lines of the
# following pattern:
#     set <varname> <value>
# This pattern can be splitted across several lines provided newlines
# are escaped
# All you should modify is the <value> part. <value> is a list of
#   space-separated elements, enclosed in braces.
# You can change the number of elements of lists. For further
#   details, see the tcl manual.

# To override the value of a variable:

    ####   DON'T FORGET THIS   ####
# - uncomment the lines concerning this variable by removing leading '#'
#     characters

# - modify the value as you like.

# You will have to restart Picasso to have your
# changes take effect

####   MORE CUSTOMIZATION   ####

# This file is a tcl source file, read by picasso using the "source"
# command (see Tcl documentation). You are free to include in this
# file as much tcl code as you want.
# This file is sourced at the very
#   start of the application, before widget creation.

# The procedure "SetupEndHook" is called once setup has been
#   performed, just before starting event loop processing

################################
####    Global variables    ####
################################
# The following variables are used to configure picasso. They can't be
#   modified interactively.

########  Size of the drawing area  ########
# These variables specify the dimensions of the drawing area
# Dimension are floating-point numbers followed by an optional letter
#   (no white space allowed) specifying the unit, e.g.:
# 123  ==  123 pixels
# 10.5i ==  1.5 inch
# Known units are pixels (no letter) millimeters (letter m),
#   centimeters (letter c), inches (letter i), and printer points
#   (letter p).

set drawAreaWidth   21.0c
set drawAreaHeight  29.7c

########  Temporary file directory  ########

set TmpDir {/tmp}

########  List of directories to search for bitmap files  ########

set bitmapPath {/usr/include/X11R5/X11/bitmaps}

########  Line widths  ########
# Available line widths in pixels

set theLineWidth {1 2 3 4}

########  Dash styles  ########
#  Available dash styles
#  Each style is an even length list of numbers between 0 and 256  
#  even numbered elements define points to draw,
#  odd numbered elements define points to skip  

set theDashes { {} {4 4} {8 8} {16 16} {8 4} {16 8} {24 4 4 4} {32 6 6 6} }

########  Stipple bitmaps  ########
#  for each <name> in the list below,  
#  each dir in bitmapPath defined above is searched 
#  for a bitmap file <name> or <name>.xbm  

set theStipples {stipple0 stipple1 stipple2 stipple3 stipple4 \
  stipple5 stipple6 stipple7 scales }

########  Font styles  ########
#  List elements must match X font name components (see xlsfonts)
#  First letter of slant is used in building the X font name, e.g.  
#  roman -> *-r-*  

set theFNames { times helvetica symbol }
set theFSizes { 10 12 14-140 18 24 34 }
set theFWeights { medium bold }
set theFSlants  { roman italic }

########  Foreground and background colors  ########
#  Must be names of colors as defined in /usr/lib/X11/rgb.txt

set theForegroundColors \
  {black grey10 grey20 grey30 grey40 grey50 grey60 grey70 grey80 \
    grey90 white red green blue}

set theBackgroundColors \
  {black grey10 grey20 grey30 grey40 grey50 grey60 grey70 grey80 \
    grey90 white red green blue}

########  Latex initial environments  ########
# Each element of latexEnvs is an initial text to display when
#   creating a latex item. ">|<" only indicates the initial cursor
#   position and is not displayed.
# You can switch between initial texts by clicking again in the item
#   before adding any text.
# Don't forget that latex source is encapsulated in a minipage
#   environment before compiling, so some environments can't be
#   used ("\[ ... \]" for example).

set LatexEnvs {
  {$ \displaystyle >|< $}
  {>|<}
  {$ >|< $}
  {$ \displaystyle \begin{array}{cc}
    >|<
    \end{array} $}
}  

########################################
####    Initial parameter values    ####
########################################
# The following variables set initial values for parameters that can be
#   modified interactively

########  Default Latex anchor  ########
#  Specifies which reference point to use when placing latex items
#  Must be one of nw, n, ne, w, center, e, sw, s, se 

set LatexAnchor center

########  Latex document style  ########
# specifies the argument of the latex "\documenstyle" command
# don't remove the outmost surrounding braces which
# are not part of the argument.

set LatexDocStyle { [epsf]{article} }

########  Latex ratio  ########
# Specifies the ratio between the value you plan to give
#   to your picture in the generated latex (using \epsf<x|y>size=...)
#   and the natural drawing size.
# Setting the right value allows picasso to display the real size of
#   latex objects bouding boxes. The position of latex objects however
#   will remain correct in every case (see latex help for more details).

set LatexDrawingRatio 1

################################
####    Key Bindings        ####
################################

# Each binding line is composed of three elements:
# - an event specification (see Tk manual)
# - a Tcl command to execute
# - A mnemonics to display in menus
#
# Procedures that can be used here include:
#    LoadDrawing
#    SaveDrawing
#    SaveDrawingAs
#    WriteLatex
#    WritePostscript
#    Quit
#    Undo
#    Delete
#    Duplicate
#    Configure
#    Align
#    AlignToGrid
#    SelectAll
#    Group
#    Ungroup
#    Raise
#    Lower
#    Rotate <angle>
#    FlipHorizontal
#    FlipVertical
#    AxialSymetry
#    LatexCompile
#    LatexUncompile


set theBindings {
  #  General bindings  #
  <Control-q>      	{ Quit } 		{^q}
  <Control-s>      	{ SaveDrawing } 	{^s}
  <Control-w>      	{ SaveDrawingAs } 	{^w}
  <Control-f>      	{ LoadDrawing }		{^f}
  <Control-i>      	{ IncludeDrawing }	{^i}
  #  Edit bindings  #
  <Control-r>      	{ Raise }		{^r}
  <Control-l>      	{ Lower }		{^l}
  <Control-Key-2>  	{ Duplicate }		{^2}
  <Control-a>      	{ SelectAll }		{^a}
  <Control-d>      	{ Delete }		{^d}
  <Control-g>      	{ Group }		{^g}
  <Control-u>      	{ Ungroup }		{^u}
  ####  UNDO DISABLED  ####  
#  <Control-minus>  	{ Undo }		{^-}
  <Control-p>      	{ Configure }		{^p}
  <Control-equal>  	{ Align }		{^=}
  <Control-period>  	{ AlignToGrid }		{^.}
  <Control-w>      	{ Shadow }           	{^w}
  <Control-bracketleft>	{ Rotate 90 }		{^[}
  <Control-bracketright> { Rotate -90 }		{^]}
  <Control-bar> 	{ FlipVertical }	{^|}
  <Control-underscore>  { FlipHorizontal }	{^_}
  <Control-slash>	{ AxialSymetry }	{^/}
  #  Move  #
  <KeyPress-Up>    	{ Move  0 -1 }       	{}
  <KeyPress-Down>  	{ Move  0  1 }       	{}
  <KeyPress-Right> 	{ Move  1  0 }     	{}
  <KeyPress-Left>  	{ Move -1  0 }		{}
  #  Mode switching  #
  <s>              	{ ChangeMode SelectMode }	{s}
  <j>              	{ ChangeMode ScaleMode }	{j}
  <x>              	{ ChangeMode StretchMode }	{x}
  <t>              	{ ChangeMode TextMode }		{t}
  <l>              	{ ChangeMode LineMode }		{l}
  <r>              	{ ChangeMode RectangleMode }	{r}
  <o>              	{ ChangeMode OvalMode }		{o}
  <c>              	{ ChangeMode CurveMode }	{c}
  <a>              	{ ChangeMode ArcMode }		{a}
}

##################################
########  Mouse bindings  ########
##################################

# The procedure defineMouse expects 6 arguments:
#   - the mode in which the binding should apply
#       ("Any" means all modes)
#   - the state in which the binding should apply
#       (see mode dependent definition of state below)
#   - A list of modifiers
#       (Any, Shift, Meta, Control, ...)
#   - The type of the event
#       (ButtonPress, ButtonRelease, Motion)
#   - The detail field of the event
#       (i.e. the button number)
#   - The action to take
#
# Be careful while modifying mouse bindings, it's quite easy to break
#   things down here...

####  Bindings common to all modes  ####

defineMouse Any 0 \
  {} 		ButtonPress 	2 \
  { imoveStart $x $y }

defineMouse Any 0 \
  {Button2} 	Motion 		"" \
  { imoveMotion $x $y }

defineMouse Any 0 \
  {} 		ButtonRelease 	2 \
  { imoveEnd }

defineMouse Any 0 \
  {Shift}	ButtonPress	1 \
  { iselectAugment }

defineMouse Any 0 \
  {}		ButtonPress 	3 \
  { help [cv] }

####  Select mode  ####

defineMouse SelectMode 0 \
  {} 		ButtonPress 	2 \
  { imoveSelectionStart $x $y }

defineMouse SelectMode 0 \
  {} 		ButtonPress 	1 \
  { iselect $x $y }

defineMouse SelectMode 0 \
  {Button1} 	Motion 		"" \
  { iselectRegion $x $y }
  
defineMouse SelectMode 0 \
  {} 		ButtonRelease 	1 \
  { iselectRegionEnd }

####  Symetry mode  ####

defineMouse SymetryMode 0 \
  {}		ButtonPress	1 \
  { symaxeStart $x $y }

defineMouse SymetryMode 0 \
  {Button1} 	Motion 		"" \
  { symaxeMotion $x $y }

defineMouse SymetryMode 0 \
  {} 		ButtonRelease 	1 \
  { symaxeEnd $x $y }

####  Stretch mode  ####

defineMouse StretchMode 0 \
  {}		ButtonPress	1 \
  { iresizeStart $x $y }

defineMouse StretchMode 0 \
  {Button1} 	Motion 		"" \
  { iresizeMotion $x $y }

defineMouse StretchMode 0 \
  {} 		ButtonRelease 	1 \
  { iresizeEnd }

####  Scale mode  ####

defineMouse ScaleMode 0 \
  {}		ButtonPress	1 \
  { iscaleStart $x $y}

defineMouse ScaleMode 0 \
  {Button1} 	Motion 		"" \
  { iscaleMotion $x $y }

defineMouse ScaleMode 0 \
  {} 		ButtonRelease 	1 \
  { iscaleEnd $x $y }

####  Reshape mode  ####

##  State 0 <==> no handles drawn ##
##  State 1 <==> handles drawn for an object, but no handle is being dragged  ##
##  State 2 <==> a handle is being dragged  ##

defineMouse ReshapeMode {0 1} \
  {}		ButtonPress	1 \
  { ishapeTake $x $y }

defineMouse ReshapeMode 2 \
  {}		ButtonPress	1 \
  { ishapeAdd $x $y }

defineMouse ReshapeMode 2 \
  {}		ButtonPress	2 \
  { ishapeEnd }

defineMouse ReshapeMode 2 \
  {}		ButtonPress	3 \
  { ishapeDelete }

defineMouse ReshapeMode 2 \
  {Any} 	Motion 		"" \
  { ishapeMotion $x $y }

defineMouse ReshapeMode 2 \
  {}	 	Motion 		"" \
  { ishapeMotion $x $y }

####  Rotate mode  ####

defineMouse RotateMode 0 \
  {}		ButtonPress	1 \
  { irotateStart $x $y }

defineMouse RotateMode 0 \
  {Button1} 	Motion 		"" \
  { irotateMotion $x $y }

defineMouse RotateMode 0 \
  {}		ButtonRelease	1 \
  { irotateEnd $x $y }

##  Filled and outlined rectangle creation mode  ##

defineMouse {FrectangleMode RectangleMode} 0 \
  {}		ButtonPress	1 \
  { eval "crectangleStart [grid $x $y]" }

defineMouse {FrectangleMode RectangleMode} 0 \
  {Button1} 	Motion 		"" \
  { eval "crectangleMotion [grid $x $y]" }

defineMouse {FrectangleMode RectangleMode} 0 \
  {}		ButtonRelease	1 \
  { csimpleEnd }

####  Oval and circle creation mode  ####

defineMouse OvalMode 0 \
  {}		ButtonPress	1 \
  { eval "covalStart [grid $x $y]" }

defineMouse OvalMode 0 \
  {Button1} 	Motion 		"" \
  { eval "csimpleMotion [grid $x $y]" }

defineMouse OvalMode 0 \
  {}		ButtonRelease	1 \
  { csimpleEnd }

defineMouse OvalMode 0 \
  {Shift}	ButtonPress	1 \
  { eval "ccircleStart [grid $x $y]" }

defineMouse OvalMode 0 \
  {Shift Button1} Motion 	"" \
  { eval "ccircleMotion [grid $x $y]" }

defineMouse OvalMode 0 \
  {Shift}	ButtonRelease	1 \
  { csimpleEnd }


####  Arc and Pie slice creation mode  ####
# State 0 <==> no arc is being created
# State 1 <==> arc center has been set
# State 2 <==> first extremity has been set

defineMouse {PieMode ArcMode} {0 1 2} \
  {}		ButtonPress	1 \
  { eval "carcStart [grid $x $y]" }

defineMouse {PieMode ArcMode} {1 2} \
  {} 		Motion 		"" \
  { eval "carcMotion [grid $x $y]" }

defineMouse {PieMode ArcMode} {1 2} \
  {Any}		Motion 		"" \
  { eval "carcMotion [grid $x $y]" }

####  Polyline and spline creation mode  ####
# State 0 <==> no line is being created
# State 1 <==> a line is being created

defineMouse {CurveMode LineMode} {0 1} \
  {}		ButtonPress	1 \
  { eval "cpolylineStart [grid $x $y]" }

defineMouse {CurveMode LineMode} 1 \
  {} 		Motion 		"" \
  { eval "cpolylineMotion [grid $x $y]" }

defineMouse {CurveMode LineMode} 1 \
  {Any}		Motion 		"" \
  { eval "cpolylineMotion [grid $x $y]" }

defineMouse {CurveMode LineMode} 1 \
  {}		ButtonPress	2 \
  { cpolylineEnd }

defineMouse {CurveMode LineMode} 1 \
  {}		ButtonPress	3 \
  { eval "cpolylineDelete [grid $x $y]" }

####  Polygon and closed curve creation mode  ####
# State 0 <==> no polygon is being created
# State 1 <==> a polygon is being created

defineMouse {CloseLineMode CloseCurveMode} {0 1} \
  {}		ButtonPress	1 \
  { eval "cpolygonStart [grid $x $y]" $CurrentMode }

defineMouse {CloseLineMode CloseCurveMode} 1 \
  {}		ButtonPress	2 \
  { cpolygonEnd }

defineMouse {CloseLineMode CloseCurveMode} 1 \
  {}		ButtonPress	3 \
  { eval "cpolygonDelete [grid $x $y]" $CurrentMode }

defineMouse {CloseLineMode CloseCurveMode} 1 \
  {} 		Motion 		"" \
  { eval "cpolygonMotion [grid $x $y]" }

defineMouse {CloseLineMode CloseCurveMode} 1 \
  {Any}		Motion 		"" \
  { eval "cpolygonMotion [grid $x $y]" }

####  Text object creation mode  ####

defineMouse TextMode 0 \
  {}		ButtonPress	1 \
  { ctextStart [[cv] canvasx $x] [[cv] canvasy $y] }

defineMouse TextMode 0 \
  {} 		ButtonPress 	2 \
  { ctextEnd; imoveStart $x $y }

####  Latex object creation mode  ####

defineMouse LatexMode 0 \
  {}		ButtonPress	1 \
  { clatexStart [[cv] canvasx $x] [[cv] canvasy $y] }

defineMouse LatexMode 0 \
  {} 		ButtonPress 	2 \
  { imoveStart $x $y }

defineMouse LatexMode 1 \
  {} 		ButtonPress 	2 \
  { clatexEnd }

#######################################
####    Hook called after setup    ####
#######################################

proc SetupEndHook {} {

}
