static char rcsid[]="$Id: fastimgeom.c,v 1.3 94/02/06 14:33:13 mangin Exp $";

/**  This files contains low quality fast routines
 **  (pixel picking-up or duplication)
 **  for image rotation and rescaling.
 **
 **  There are still bounds checking everywhere,
 **    but they are quite dangerous to remove...
 **/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <tclExtend.h>
#include <math.h>

#define ZEROF 0.000001
#define FNULL(A) (((A) > -ZEROF) && ((A) < ZEROF))
#define FEQUAL(A,B) FNULL((A)-(B))

static void Map _ANSI_ARGS_((float *src, unsigned char *dst, int dstw, int dsth, int dstlinew,
			    float a, float b, int *pixels, int numpixels));

static void Zoom _ANSI_ARGS_((float *src, int srcw, int srch,
			     unsigned char *dst, int dstw, int dsth, int dstlinew,
			     float xfact, float yfact, float a, float b,
			     int *pixels, int numpixels));

static void Rotate _ANSI_ARGS_((float *src, int srcw, int srch,
			       unsigned char *dst, int dstw, int dsth, int dstlinew,
			       float angle, float csn, float sn,
			       Region xregion, float a, float b,
			       int *pixels, int numpixels));

static void RotatePos90 _ANSI_ARGS_((float *src, int srcw, int srch,
				    unsigned char *dst, int dstlinew,
				    float a, float b, int *pixels, int numpixels));

static void RotateNeg90 _ANSI_ARGS_((float *src, int srcw, int srch,
				    unsigned char *dst, int dstlinew,
				    float a, float b, int *pixels, int numpixels));

static void Rotate180 _ANSI_ARGS_((float *src, int srcw, int srch,
				  unsigned char *dst, int dstlinew,
				  float a, float b, int *pixels, int numpixels));

static void RotateAny _ANSI_ARGS_((float *src, int srcw, int srch,
				  unsigned char *dst, int dstlinew,
				  float csn, float sn, Region xregion,
				  float a, float b, int *pixels, int numpixels));

static void ZRotate _ANSI_ARGS_((float *src, int srcw, int srch,
				unsigned char *dst, int dstw, int dsth, int dstlinew,
				float xfact, float yfact, float angle, float csn, float sn,
				Region xregion, float a, float b, int *pixels, int numpixels));

static void ZRotatePos90 _ANSI_ARGS_((float *src, int srcw, int srch,
				     unsigned char *dst, int dstw, int dsth, int dstlinew,
				     float xfact, float yfact, float a, float b,
				     int *pixels, int numpixels));

static void ZRotateNeg90 _ANSI_ARGS_((float *src, int srcw, int srch,
				     unsigned char *dst, int dstw, int dsth, int dstlinew,
				     float xfact, float yfact, float a, float b,
				     int *pixels, int numpixels));

static void ZRotate180 _ANSI_ARGS_((float *src, int srcw, int srch,
				   unsigned char *dst, int dstw, int dsth, int dstlinew,
				   float xfact, float yfact, float a, float b,
				   int *pixels, int numpixels));

static void ZRotateAny _ANSI_ARGS_((float *src, int srcw, int srch,
				   unsigned char *dst, int dstw, int dsth, int dstlinew,
				   float xfact, float yfact, float csn, float sn,
				   float a, float b, int *pixels, int numpixels));
     
/***************************************************************
 ****	    The externally callable routine                 ****
 ***************************************************************/

void ZoomTurn (src, srcw, srch,
	       dst, dstw, dsth, dstlinew,
	       zflag, xfact, yfact,
	       rflag, angle, csn, sn, xregion,
	       a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     int srcw, srch;			/* source data dims		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstw, dsth, dstlinew;		/* destination buffer dims	*/
     int zflag;				/* whether to rescale or not	*/
     float xfact, yfact;		/* rescale ratios		*/
     int rflag;				/* whether to rotate or not	*/
     float angle, csn, sn;		/* cos and sine of rotation	*/
     Region xregion;			/* X Region defined by final image */
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  if (!zflag && !rflag) {
    /*  No rotation, no scaling  */
    Map(src, dst, dstw, dsth, dstlinew,
	a, b, pixels, numpixels);
  } else if (!zflag && rflag) {
    /*  just rotate  */
    Rotate(src, srcw, srch,
           dst, dstw, dsth, dstlinew,
	   angle, csn, sn, xregion,
	   a, b, pixels, numpixels);
  } else if (zflag && !rflag) {
    /* just scale */
    Zoom(src, srcw, srch,
	 dst, dstw, dsth, dstlinew,
	 xfact, yfact,
	 a, b, pixels, numpixels);
  } else {
    /*  scale and rotate  */
    ZRotate(src, srcw, srch,
	    dst, dstw, dsth, dstlinew,
	    xfact, yfact,
	    angle, csn, sn, xregion,
	    a, b, pixels, numpixels);
  }
}

/***************************************************************
 ****	 Mapping of src values to pixel values              ****
 ***************************************************************/

static void Map(src, dst, dstw, dsth, dstlinew,
		a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstw, dsth, dstlinew;		/* destination buffer dims	*/
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  int dstgarb;
  float *psrc, *srclineend, *srcend;
  unsigned char *pdst;
  unsigned char minpix, maxpix;
  int val;

  minpix = pixels[0];
  maxpix = pixels[numpixels-1];

  psrc = src;
  srclineend = src + dstw;
  srcend = src + dstw*dsth;

  pdst = dst;
  dstgarb = dstlinew - dstw;
  
  while (psrc < srcend) {
    while (psrc < srclineend) {
      val = (int)(a * (*psrc++) + b);
      if (val < 0)
	*pdst++ = minpix;
      else if (val >= numpixels)
	*pdst++ = maxpix;
      else
	*pdst++ = pixels[val];
    }
    pdst += dstgarb;
    srclineend += dstw;
  }
}
  
/***************************************************************
 ***************************************************************/

/***************************************************************
 ****                 ImageZooming                          ****
 ***************************************************************/

/***************************************************************
 ***************************************************************/

/**  Resizing of pixel arrays
 **  Expansion uses pixel duplication
 **  Reduction picks up the closest pixel
 **/

static void Zoom(src, srcw, srch,
		 dst, dstw, dsth, dstlinew,
		 xfact, yfact,
		 a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     int srcw, srch;			/* source data dims		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstw, dsth, dstlinew;		/* destination buffer dims	*/
     float xfact, yfact;		/* rescale ratios		*/
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  int I, J;
  unsigned char *pdst;
  unsigned char minpix, maxpix;
  float *srcline;
  int val;
  int dstgarb;
  float srcx0, srcx, srcy;

  minpix = pixels[0];
  maxpix = pixels[numpixels-1];

  dstgarb = dstlinew - dstw;
  pdst = dst;

  /**  0.5 == coordinate of the center of the first pixel  **/
  srcx0 = 0.5 * xfact;
  srcy = 0.5 * yfact;

  for (J = 0; J < dsth; J++) {
    srcx = srcx0;
    srcline = src + srcw * (int)srcy;
    for (I = 0; I < dstw; I++) {
      val = (int)(a * srcline[(int)srcx] + b);
      if (val < 0)
	*pdst++ = minpix;
      else if (val >= numpixels)
	*pdst++ = maxpix;
      else
	*pdst++ = pixels[val];
      srcx += xfact;
    }
    srcy += yfact;
    pdst += dstgarb;
  }
}

/***************************************************************
 ***************************************************************/

/***************************************************************
 ****		     Image Rotation                         ****
 ***************************************************************/

/***************************************************************
 ***************************************************************/

static void Rotate(src, srcw, srch,
		   dst, dstw, dsth, dstlinew,
		   angle, csn, sn, xregion,
		   a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     int srcw, srch;			/* source data dims		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstw, dsth, dstlinew;		/* destination buffer dims	*/
     float angle, csn, sn;		/* cos and sine of rotation	*/
     Region xregion;			/* X Region defined by final image */
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  if (FEQUAL(angle, 90.0)) {
    RotatePos90(src, srcw, srch, dst, dstlinew,
		a, b, pixels, numpixels);
  } else if (FEQUAL(angle, -90.0)) {
    RotateNeg90(src, srcw, srch, dst, dstlinew,
		a, b, pixels, numpixels);
  } else if (FEQUAL(fabs(angle), 180.0)) {
    Rotate180(src, srcw, srch, dst, dstlinew,
	      a, b, pixels, numpixels);
  } else {
    RotateAny(src, srcw, srch,
	      dst, dstlinew,
	      csn, sn, xregion,
	      a, b, pixels, numpixels);
  }
}

/***************************************************************
 ****		  90 degrees rotation                       ****
 ***************************************************************/

static void RotatePos90(src, srcw, srch, dst, dstlinew,
			a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     int srcw, srch;			/* source data dims		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstlinew;			/* destination buffer dims	*/
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  float *psrc, *srcline, *srclineend, *srcend;
  unsigned char *pdst, *dstcol;
  unsigned char minpix, maxpix;
  int val;

  minpix = pixels[0];
  maxpix = pixels[numpixels-1];
  
  srcend = src + srcw*srch;
  srclineend = src + srcw;
  
  /**  First src pixel goes in last line of first dst column  **/
  dstcol = dst + dstlinew*(srcw-1);
  
  for (srcline = src;
       srcline < srcend;
       srcline += srcw, srclineend += srcw) {
    psrc = srcline;
    pdst = dstcol;
    while (psrc < srclineend) {
      val = (int)(a * (*psrc++) + b);
      if (val < 0)
	*pdst = minpix;
      else if (val >= numpixels)
	*pdst = maxpix;
      else
	*pdst = pixels[val];
      pdst -= dstlinew;
    }
    dstcol++;
  }
}

/***************************************************************
 ****		  -90 degrees rotation                       ****
 ***************************************************************/

static void RotateNeg90(src, srcw, srch, dst, dstlinew,
			a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     int srcw, srch;			/* source data dims		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstlinew;			/* destination buffer dims	*/
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  float *psrc, *srcline, *srclineend, *srcend;
  unsigned char *pdst, *dstcol;
  unsigned char minpix, maxpix;
  int val;
  
  minpix = pixels[0];
  maxpix = pixels[numpixels-1];
  
  srcend = src + srcw*srch;
  srclineend = src + srcw;

  /**  First src pixel goes in first line of last dst column  **/
  dstcol = dst + srch - 1;
  
  for (srcline = src;
       srcline < srcend;
       srcline += srcw, srclineend += srcw) {
    psrc = srcline;
    pdst = dstcol;
    while (psrc < srclineend) {
      val = (int)(a * (*psrc++) + b);
      if (val < 0)
	*pdst = minpix;
      else if (val >= numpixels)
	*pdst = maxpix;
      else
	*pdst = pixels[val];
      pdst += dstlinew;
    }
    dstcol--;
  }
}

/***************************************************************
 ****		  180 degrees rotation                      ****
 ***************************************************************/

static void Rotate180(src, srcw, srch, dst, dstlinew,
			a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     int srcw, srch;			/* source data dims		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstlinew;			/* destination buffer dims	*/
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  float *psrc, *srcline, *srclineend, *srcend;
  unsigned char *pdst, *dstline;
  unsigned char minpix, maxpix;
  int val;
  
  minpix = pixels[0];
  maxpix = pixels[numpixels-1];
  
  srcend = src + srcw*srch;
  srclineend = src + srcw;
  dstline = dst + srch*dstlinew - 1;
  
  for (srcline = src;
       srcline < srcend;
       srcline += srcw, srclineend += srcw) {
    psrc = srcline;
    pdst = dstline;
    while (psrc < srclineend) {
      val = (int)(a * (*psrc++) + b);
      if (val < 0)
	*pdst-- = minpix;
      else if (val >= numpixels)
	*pdst-- = maxpix;
      else
	*pdst-- = pixels[val];
    }
    dstline -= dstlinew;
  }
}

/***************************************************************
 ****		    General rotation                        ****
 ***************************************************************/

static void RotateAny(src, srcw, srch,
		      dst, dstlinew,
		      csn, sn, xregion,
		      a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     int srcw, srch;			/* source data dims		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstlinew;			/* destination buffer dims	*/
     float csn, sn;			/* cos and sine of rotation	*/
     Region xregion;			/* X Region defined by final image */
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  int val;
  unsigned char minpix, maxpix;
  Region cregion;
  XRectangle rect;
  float srcx, srcy, dsty;
  float srcx0, srcy0, dstx0;
  float **srcline, *psrc;
  unsigned char *pdst;
  int I, J, i, j, dstgarb;

  minpix = pixels[0];
  maxpix = pixels[numpixels-1];

  /*  translate region so that ul-corner of its bbox is in (0,0)  */
  cregion = XCreateRegion();
  XUnionRegion(cregion, xregion, cregion);
  XClipBox(cregion, &rect);
  XOffsetRegion(cregion, -rect.x, -rect.y);

  srcline = (float **)malloc(srch * sizeof(float *));
  psrc = src;
  for (j = 0; j < srch; j++, psrc += srcw)
    srcline[j] = psrc;

  dstx0 = -0.5*rect.width + 0.5; /* add 0.5 to get the center of the pixel */
  srcx0 = 0.5*srcw + csn*dstx0;
  srcy0 = 0.5*srch + sn*dstx0;
  
  pdst = dst;
  dstgarb = dstlinew - rect.width;

  for (J = 0, dsty = -0.5*rect.height + 0.5; /* add 0.5 to get the center of the pixel */
       J < rect.height;
       J++, dsty += 1.0) {

    srcx = srcx0 - sn*dsty;
    srcy = srcy0 + csn*dsty;
    
    for (I = 0; I < rect.width; I++,
	 pdst++, srcx += csn, srcy += sn) {
      
      if (XPointInRegion(cregion, I, J) != True)
        continue;
      
      i = (int)srcx;
      j = (int)srcy;
      
      if (i < 1) {
        /*  first column  */
        if (j < 1)
          val = (int)(a * (*src) + b);
        else if (j > srch-1)
          val = (int)(a * (*srcline[srch-1]) + b);
        else {
          val = (int)(a * (*srcline[j]) + b);
        }
      } else if (i > srcw-1) {
        /*  last column  */
        if (j < 1)
          val = (int)(a * (src[srcw-1]) + b);
        else if (j > srch-1)
          val = (int)(a * (srcline[srch-1][srcw-1]) + b);
        else {
          val = (int)(a * (srcline[j][srcw-1]) + b);
        }
      } else {
        /* any column */
        if (j <= 1) {
          val = (int)(a * (src[i]) + b);
        } else if (j >= srch-1) {
          val = (int)(a * (srcline[srch-1][i]) + b);
        } else {
          val = (int)(a * (srcline[j][i]) + b);
        }
      }
      if (val < 0)
	*pdst = minpix;
      else if (val >= numpixels)
	*pdst = maxpix;
      else
	*pdst = pixels[val];
    }
    pdst += dstgarb;
  }
  XDestroyRegion(cregion);
  free(srcline);
}

/***************************************************************
 ***************************************************************/

/***************************************************************
 ****	       Scale / Rotate combination                   ****
 ***************************************************************/

/***************************************************************
 ***************************************************************/

static void ZRotate(src, srcw, srch,
		    dst, dstw, dsth, dstlinew,
		    xfact, yfact,
		    angle, csn, sn, xregion,
		    a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     int srcw, srch;			/* source data dims		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstw, dsth, dstlinew;		/* destination buffer dims	*/
     float xfact, yfact;		/* rescale ratios		*/
     float angle, csn, sn;		/* cos and sine of rotation	*/
     Region xregion;			/* X Region defined by final image */
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  if (xregion == None) {
    if (FEQUAL(angle, 90.0)) {
      ZRotatePos90(src, srcw, srch,
		   dst, dstw, dsth, dstlinew,
		   xfact, yfact,
		   a, b, pixels, numpixels);
    } else if (FEQUAL(angle, -90.0)) {
      ZRotateNeg90(src, srcw, srch,
		   dst, dstw, dsth, dstlinew,
		   xfact, yfact,
		   a, b, pixels, numpixels);
    } else if (FEQUAL(fabs(angle), 180.0)) {
      ZRotate180(src, srcw, srch,
		 dst, dstw, dsth, dstlinew,
		 xfact, yfact,
		 a, b, pixels, numpixels);
    }
  } else {
    ZRotateAny(src, srcw, srch,
	       dst, dstw, dsth, dstlinew,
	       xfact, yfact,
	       csn, sn,
	       a, b, pixels, numpixels);
  }
}

/***************************************************************
 ****		zoom & +90 degrees rotation                 ****
 ***************************************************************/

static void ZRotatePos90(src, srcw, srch,
			 dst, dstw, dsth, dstlinew,
			 xfact, yfact,
			 a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     int srcw, srch;			/* source data dims		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstw, dsth, dstlinew;		/* destination buffer dims	*/
     float xfact, yfact;		/* rescale ratios		*/
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  int I, J, i, j;
  float **srcline, *psrc;
  unsigned char *pdst;
  float srcx, srcy;
  int dstgarb;
  unsigned char minpix, maxpix;
  int val;

  minpix = pixels[0];
  maxpix = pixels[numpixels-1];

  /* line starts in src */
  srcline = (float **)malloc(srch * sizeof(float *));
  psrc = src;
  for (j = 0; j < srch; j++, psrc += srcw)
    srcline[j] = psrc;

  pdst = dst;
  dstgarb = dstlinew - dstw;

  for (J = 0, srcx = srcw - xfact;
       J < dsth;
       J++, pdst += dstgarb, srcx -= xfact) {
    i = (int)srcx;
    for (I = 0, srcy = 0.0;
	 I < dstw;
	 I++, srcy += yfact) {

      /* should be in a lookup table */
      j = (int)srcy;

      val = (int)(a * (srcline[j][i]) + b);
      if (val < 0)
	*pdst++ = minpix;
      else if (val >= numpixels)
	*pdst++ = maxpix;
      else
	*pdst++ = pixels[val];
    }
  }

  free(srcline);
}

/***************************************************************
 ****		  -90 degrees rotation                       ****
 ***************************************************************/

static void ZRotateNeg90(src, srcw, srch,
			 dst, dstw, dsth, dstlinew,
			 xfact, yfact,
			 a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     int srcw, srch;			/* source data dims		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstw, dsth, dstlinew;		/* destination buffer dims	*/
     float xfact, yfact;		/* rescale ratios		*/
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  int I, J, i, j;
  float **srcline, *psrc;
  unsigned char *pdst;
  float srcx, srcy;
  int dstgarb;
  unsigned char minpix, maxpix;
  int val;

  minpix = pixels[0];
  maxpix = pixels[numpixels-1];

  /* line starts in src */
  srcline = (float **)malloc(srch * sizeof(float *));
  psrc = src;
  for (j = 0; j < srch; j++, psrc += srcw)
    srcline[j] = psrc;

  pdst = dst;
  dstgarb = dstlinew - dstw;

  for (J = 0, srcx = 0.0;
       J < dsth;
       J++, pdst += dstgarb, srcx += xfact) {
    i = (int)srcx;
    for (I = 0, srcy = srch - yfact;
	 I < dstw;
	 I++, srcy -= yfact) {

      /* should be in a lookup table */
      j = (int)srcy;

      val = (int)(a * (srcline[j][i]) + b);
      if (val < 0)
	*pdst++ = minpix;
      else if (val >= numpixels)
	*pdst++ = maxpix;
      else
	*pdst++ = pixels[val];
    }
  }

  free(srcline);
}

/***************************************************************
 ****		  180 degrees rotation                      ****
 ***************************************************************/

static void ZRotate180(src, srcw, srch,
		       dst, dstw, dsth, dstlinew,
		       xfact, yfact,
		       a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     int srcw, srch;			/* source data dims		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstw, dsth, dstlinew;		/* destination buffer dims	*/
     float xfact, yfact;		/* rescale ratios		*/
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  int I, J, i, j;
  float **srcline, *psrc;
  unsigned char *pdst;
  float srcx, srcy;
  int dstgarb;
  unsigned char minpix, maxpix;
  int val;

  minpix = pixels[0];
  maxpix = pixels[numpixels-1];

  /* line starts in src */
  srcline = (float **)malloc(srch * sizeof(float *));
  psrc = src;
  for (j = 0; j < srch; j++, psrc += srcw)
    srcline[j] = psrc;
  
  pdst = dst;
  dstgarb = dstlinew - dstw;

  for (J = 0, srcy = srch - yfact;
       J < dsth;
       J++, pdst += dstgarb, srcy -= yfact) {

    j = (int)srcy;

    for (I = 0, srcx = srcw - xfact;
	 I < dstw;
	 I++, srcx -= xfact) {

      i = (int)srcx;

      val = (int)(a * (srcline[j][i]) + b);

      if (val < 0)
	*pdst++ = minpix;
      else if (val >= numpixels)
	*pdst++ = maxpix;
      else
	*pdst ++= pixels[val];
    }
  }

  free(srcline);
}

/***************************************************************
 ****		    General zoom + rotation                 ****
 ***************************************************************/

static void ZRotateAny(src, srcw, srch,
		       dst, dstw, dsth, dstlinew,
		       xfact, yfact,
		       csn, sn,
		       a, b, pixels, numpixels)
     float *src;			/* source data buffer		*/
     int srcw, srch;			/* source data dims		*/
     unsigned char *dst;		/* destination data buffer	*/
     int dstw, dsth, dstlinew;		/* destination buffer dims	*/
     float xfact, yfact;		/* rescale ratios		*/
     float csn, sn;			/* cos and sine of rotation	*/
     float a, b;			/* ax+b gives pixel indice	*/
     int *pixels, numpixels;		/* pixel values lookup table	*/
{
  int I, J, i, j;
  float **srcline, *psrc;
  unsigned char *pdst;
  float xfcsn, xfsn, yfcsn, yfsn;
  float srcx0, srcy0, srcx, srcy;
  float buf1, buf2;
  int dstgarb;
  unsigned char minpix, maxpix;
  int val;

  /**  Method : for each dst pixel in region,  **/
  /**  apply transform on the pixel center,  **/
  /**  find closest src pixel, and pick up its value.  **/

  minpix = pixels[0];
  maxpix = pixels[numpixels-1];

  /* line starts in src */
  srcline = (float **)malloc(srch * sizeof(float *));
  psrc = src;
  for (j = 0; j < srch; j++, psrc += srcw)
    srcline[j] = psrc;

  xfcsn = xfact * csn;
  xfsn  = xfact * sn;
  yfcsn = yfact * csn;
  yfsn  = yfact * sn;

  /* find translation to push dst bbox up left */
  buf1 = csn*srcw/xfact;
  buf2 = sn*srch/yfact;
  srcx0 = 0.0;
  if (buf1 < srcx0) srcx0 = buf1;
  if (buf2 < srcx0) srcx0 = buf2;
  if (buf1+buf2 < srcx0) srcx0 = buf1+buf2;

  buf1 = -sn*srcw/xfact;
  buf2 = csn*srch/yfact;
  srcy0 = 0.0;
  if (buf1 < srcy0) srcy0 = buf1;
  if (buf2 < srcy0) srcy0 = buf2;
  if (buf1+buf2 < srcy0) srcy0 = buf1+buf2;

  buf1 = xfact*(csn*srcx0 - sn*srcy0);
  buf2 = yfact*(sn*srcx0 + csn*srcy0);
  
  /** Now the dst->src transform is:
   **   x = buf1 + xfact * (csn*X - sn*Y)
   **   y = buf2 + yfact * (sn*X + csn*Y)
   **/

  /**  add 0.5 to get the center of the first pixel  **/
  srcx0 = buf1 + xfact * (csn*0.5 - sn*0.5);
  srcy0 = buf2 + yfact * (sn*0.5 + csn*0.5);
    
  pdst = dst;
  dstgarb = dstlinew - dstw;

  for (J = 0; J < dsth;
       J++, srcx0 -= xfsn, srcy0 += yfcsn, pdst += dstgarb) {

    srcx = srcx0;
    srcy = srcy0;
    
    for (I = 0; I < dstw;
	 I++, srcx += xfcsn, srcy += yfsn, pdst++) {
      
      i = (int)srcx;
      j = (int)srcy;

      if ((i < 0) || (i > srcw-1) || (j < 0) || (j > srch-1))
	continue;
      val = (int)(a * (srcline[j][i]) + b);
      if (val < 0)
	*pdst = minpix;
      else if (val >= numpixels)
	*pdst = maxpix;
      else
	*pdst = pixels[val];
    }
  }

  free(srcline);
}
