#include <stdio.h>
#include <tcl.h>
#include <time.h>

str_fromintCmd(cdata, interp, argc, argv)
    ClientData cdata; Tcl_Interp *interp; int argc; char **argv;
{
    int i;
    static char str_fromint_b[2] = {'\0', '\0'};

    if ((argc != 2) ||
        (Tcl_GetInt(interp, argv[1], &i) == TCL_ERROR)) {
        return args_should_be(interp, argv[0], "smallInteger");
    }
    *str_fromint_b = i;
    Tcl_SetResult(interp, str_fromint_b, TCL_STATIC);
    return TCL_OK;
}

/*- 
    bug - needs to check for legal argv[1] value 

    If no time argument is supplied the current one is used 

    If no arguments at all are supplied the the value of time(NULL) is
    returned
*/

str_ftimeCmd(cdata, interp, argc, argv)
    ClientData cdata; Tcl_Interp *interp; int argc; char **argv;
{
    extern long atol();
    char buf[256];
    time_t t;
    struct tm *tm_p;

    switch(argc) {
    case 1:
	sprintf(buf, "%ld", (long)time((time_t *)NULL));
	Tcl_SetResult(interp, buf, TCL_VOLATILE);
	return TCL_OK;

    case 2:
	t = time((time_t *)NULL);
	break;
    case 3:
	t = (time_t)atol(argv[2]);
	break;
    default:
	Tcl_AppendResult(interp, argv[0], ": wrong # of args", NULL);
	return TCL_ERROR;
    }

    tm_p = gmtime(&t);
    if (!strftime(buf, sizeof(buf), argv[1], tm_p)) {
	Tcl_AppendResult(interp, argv[0], ": format error", NULL);
	return TCL_ERROR;
    }
    Tcl_SetResult(interp, buf, TCL_VOLATILE);
    return TCL_OK;
}
