/*-
    pickUtils.h - utilities for use in picking
*/
/*
    terms for this file

    box - a rectangle described by two corners e.g.
	box =   xA yA xB yB

    area - a rectangle described by four boundary lines  e.g.
	area =  leftBound rightBound bottomBound topBound

    rect - a rectangle described by a point and a width and height e.g.
	rect =  x y w h
*/


#define BOX_TO_AREA(a,x1,y1,x2,y2) do {\
    if (x1<x2) {a->left=x1; a->right=x2;} else {a->right=x1; a->left=x2;} \
    if (y1<y2) {a->bottom=y1; a->top=y2;} else {a->top=y1; a->bottom=y2;} \
} while(0)

/*
 * BOXES_OVERLAP
 *
 */
#define bMIN(a,b) (((a)<(b))?(a):(b))
#define bMAX(a,b) (((a)>(b))?(a):(b))
#define BOXES_OVERLAP(x0,y0,x1,y1,X0,Y0,X1,Y1) \
    ((bMAX(x0,X0)<bMIN(x1,X1)) && (bMAX(y0,Y0)<bMIN(y1,Y1)))
#undef bMIN
#undef bMAX
