#
# g_rotate.t 
# tests the g_rotate cmd
#
set doBuffering true

proc draw_legend {x y sv} {
    set y [expr $y+0.04]
    foreach s $sv {
	set y [expr $y-0.04]
	g_move $x $y
	g_drawstr $s
    }
}

proc rotate_test {w} {

    g_color white; g_clear 
    g_color black
    draw_legend -.9 -.86 \
    { "rotate test, you should see 4 cones" "projecting from the center" "to form a clover leaf pattern" }

    g_move -.5 -.5
    g_pushmatrix
    for {set i 1} {$i<=4} {incr i} {
	g_rotate 90 z
	g_pushmatrix
	for {set p 1} {$p<=180} {incr p} {
	    g_move 0 0
	    g_draw .5 .5
	    g_rotate 2 z
	    g_rotate 2 y
	    g_rotate 2 x
	}
	g_popmatrix
    }
    g_popmatrix
}

wm minsize . 64 64 
wm maxsize . 500 800 
graphic .top -command {rotate_test .top} \
    -font helvetica \
    -geometry 250x250 -bg none -doublebuffered $doBuffering \
    -relief raised -border 4
pack append . .top {top fill expand}
g_init .top
g_font small
update
