  
  # ------------------------------------------------------------------------
  # Copyright (c) 1995 Christian Krone, Varziner Str. 12, D-12161 Berlin
  # All rights reserved.
  # ------------------------------------------------------------------------
  # Permission is hereby granted, without written agreement and without
  # license or royalty fees, to use, copy, modify, and distribute this
  # software and its documentation for any purpose, provided that the
  # above copyright notice and the following two paragraphs appear in
  # all copies of this software.
  # ------------------------------------------------------------------------
  # IN NO EVENT SHALL CHRISTIAN KRONE BE LIABLE TO ANY PARTY FOR DIRECT,
  # INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  # OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF CHRISTIAN
  # KRONE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  # ------------------------------------------------------------------------
  # CHRISTIAN KRONE SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT
  # NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
  # FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  # "AS IS" BASIS, AND CHRISTIAN KRONE HAS NO OBLIGATION TO PROVIDE
  # MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
  # ------------------------------------------------------------------------
    proc kopiereRegeln {dest src} {
        foreach regel {kartenSatz stapelAnz patName stapelReihe stockBasis
                       stockReihe strafReihe streitArt leerStapelNurHoch
                       talonAbraeumbar teilStapelReihe exist
                       stapelGrund stapelVerdeckt} {
          upvar #0 $regel var

          foreach name [array names var] {
            if {$src == $name} {
              set var($dest) $var($name)
            } elseif {[regexp ^${src},(.*)$ $name egal subIndex]} {
              set var($dest,$subIndex) $var($name)
            }
          }
        }
      }
    proc liesSpiel {} {
      global patArt patName kartenSatz streitArt exist stapelAnz \
             stapelGrund stapelVerdeckt stapelReihe stockBasis   \
             stockReihe teilStapelReihe strafReihe               \
             leerStapelNurHoch talonAbraeumbar
      global patiencePath neuPat
      foreach spiel [glob -nocomplain $patiencePath/spiel/*.spr] {
        source $spiel
      }
      if {![info exists patArt]} {
        set patArt standard
        set patName($patArt,deutsch)    "Standard"
        set patName($patArt,english)    "Standard"
        set kartenSatz($patArt)         2
        set streitArt($patArt)          0
        set exist($patArt,talon)        0
        set exist($patArt,strafe)       0
        set exist($patArt,arbeit)       0
        set stapelAnz($patArt)          8
        set stapelGrund($patArt,0)      3
        set stapelGrund($patArt,1)      3
        set stapelGrund($patArt,2)      3
        set stapelGrund($patArt,3)      3
        set stapelGrund($patArt,4)      3
        set stapelGrund($patArt,5)      3
        set stapelGrund($patArt,6)      3
        set stapelGrund($patArt,7)      3
        set stapelVerdeckt($patArt,0)   2
        set stapelVerdeckt($patArt,1)   2
        set stapelVerdeckt($patArt,2)   2
        set stapelVerdeckt($patArt,3)   2
        set stapelVerdeckt($patArt,4)   2
        set stapelVerdeckt($patArt,5)   2
        set stapelVerdeckt($patArt,6)   2
        set stapelVerdeckt($patArt,7)   2
        set stapelReihe($patArt)        abst,unecht
        set teilStapelReihe($patArt)    abst,unecht
        set stockBasis($patArt)         a
        set stockReihe($patArt)         aufst,echt
        set strafReihe($patArt)         aufAb,echt
        set leerStapelNurHoch($patArt)  0
        set talonAbraeumbar($patArt)    1
      }
      set vorgabe [winfo name .]
      set gefunden 0
      foreach bekannteRegel [array names stapelAnz] {
        if {[string match $bekannteRegel* $vorgabe]} {
          set patArt $bekannteRegel
          set gefunden 1
        }
      }
      if {!$gefunden} {
        set patArt standard
      }
      set neuPat $patArt
    }
    proc schrRegeln {fileName schrPat {offen -1}} {
      global patArt patName kartenSatz streitArt exist stapelAnz \
             stapelGrund stapelVerdeckt stapelReihe stockBasis   \
             stockReihe teilStapelReihe strafReihe               \
             leerStapelNurHoch talonAbraeumbar
      if {$offen == -1} {
        set aus [open $fileName "w"]
        global patienceVersion
        puts $aus "# ------------------------------------------------------------"
        puts $aus "#    Patience Version $patienceVersion"
        puts $aus "#    Spielregeln erzeugt durch 'Regeln editieren/Speichern'"
        puts $aus "#    Per Hand aendern ist unsportlich UND wird geahndet."
        puts $aus "# ------------------------------------------------------------"
      } else {
        set aus $offen
      }
      puts $aus "set patArt [string trimleft $schrPat :]"
      foreach regel {kartenSatz stapelAnz patName stapelReihe stockBasis
                     stockReihe strafReihe streitArt leerStapelNurHoch
                     talonAbraeumbar teilStapelReihe exist
                     stapelGrund stapelVerdeckt} {
        upvar #0 $regel var

        foreach name [array names var] {
          if {$schrPat == $name} {
            puts $aus "set ${regel}(\$patArt) \"$var($name)\""
          } elseif {[regexp ^${schrPat},(.*)$ $name egal subIndex]} {
            puts $aus "set ${regel}(\$patArt,$subIndex) \"$var($name)\""
          }
        }
      }
      if {$offen == -1} {
        close $aus
      }
    }
    proc initZustand {} {
        global stapel fuelle verdeckt teilStapelUnterst streitArt patArt \
               inversZug vorschlagZaehler mogelZaehler zugNr aktiverSpieler text

        foreach var {stapel fuelle verdeckt teilStapelUnterst aktiverSpieler} {
          catch "unset $var"
        }
        set fuelle(hand2) " "
        trace variable fuelle(hand) w chkKartenAnz

        set inversZug        {}
        set vorschlagZaehler 0
        set mogelZaehler     0
        set zugNr            0
        if {$streitArt($patArt)} {
          set aktiverSpieler $text(mensch)
        }
      }
    proc schrZustand {fileName} {
      global patienceVersion exist streitArt patArt stapelAnz kartenSatz
      global zugNr mogelZaehler inversZug vorschlagZaehler hand \
             stapel fuelle verdeckt teilStapelUnterst aktuellErste aktiverSpieler

      set aus [open $fileName "w"]
      puts $aus "# --------------------------------------------------------------"
      puts $aus "#    Patience Version $patienceVersion"
      puts $aus "#    Programmzustand erzeugt durch die Funktion 'Speichern'"
      puts $aus "#    Per Hand aendern ist unsportlich UND wird geahndet."
      puts $aus "# --------------------------------------------------------------"
      puts $aus ""
      schrRegeln $fileName $patArt $aus
      puts $aus ""
      puts $aus "global zugNr;            set zugNr            $zugNr"
      puts $aus "global mogelZaehler;     set mogelZaehler     $mogelZaehler"
      puts $aus "global vorschlagZaehler; set vorschlagZaehler $vorschlagZaehler"
      puts $aus "global aktuellErste;     set aktuellErste     $aktuellErste"
      if {[info exists aktiverSpieler]} {
        puts $aus "global aktiverSpieler; set aktiverSpieler   $aktiverSpieler"
      }
      puts $aus "global stapel fuelle verdeckt teilStapelUnterst"
      pArray $aus stapel
      pArray $aus fuelle
      pArray $aus verdeckt
      pArray $aus teilStapelUnterst
      puts $aus "global inversZug;    set inversZug [list $inversZug]"
      close $aus
    }
    proc liesZustand {fileName} {
      global patArt patName kartenSatz streitArt exist stapelAnz \
             stapelGrund stapelVerdeckt stapelReihe stockBasis   \
             stockReihe teilStapelReihe strafReihe               \
             leerStapelNurHoch talonAbraeumbar
      global neuPat

      initZustand
      source $fileName

      set patArt $patArt
      set neuPat $patArt

      setBitPath <>
      if {[info exists aktiverSpieler] && $aktiverSpieler == "Computer"} {
        demo
      }
    }
    proc pArray {aus a} {
      upvar 1 $a array

      foreach name [array names array] {
        puts $aus [format "  set %s(%s) %s" $a $name $array($name)]
      }
    }
    proc liesTexte {} {
        global text flaeche patiencePath sprache sprachDefault

        set sprache [option get .patience sprache Sprache]
        if {[catch "source $patiencePath/text/$sprache"]} {
          puts "Setzen der deutschen Defaulttexte..."
          set text(patience) "Patience"
          set text(erstelltVon) "Erstellt von..."
          set text(spiel)           " Patience "
          set text(werStreitetSich) "Wer streitet sich?"
          set text(mensch)          "Mensch"
          set text(mensch2)         "Mensch2"
          set text(computer)        "Computer"
          set text(demo)            "Demo"
          set text(warte)           "Warte "
          set text(sekunden)        " s"
          set text(bildErneuern)    "Bild erneuern"
          set text(beenden)         "Beenden"
          set text(acc,neuesSpiel)  "n"
          set text(acc,demo)        "d"
          set text(acc,beenden)     "e"
          set text(datei)           " Datei "
          set text(spielzustand)    "Spielzustand"
          set text(laden)           "Laden"
          set text(speichern)       "Speichern"
          set text(regelnEditieren) "Regeln editieren"
          set text(sprache)         "Sprache"
          set text(acc,laden)       "l"
          set text(acc,speichern)   "s"
          set text(sprache) "Sprache"
          set text(unterstuetzung)  " Untersttzung "
          set text(vorschlag)       "Vorschlag"
          set text(ablegen)         "Ablegen"
          set text(zugZurueck)      "Zug zurck"
          set text(zumAnfang)       "zum Anfang"
          set text(merken)          "Merken"
          set text(zurMarke)        "Zur Marke"
          set text(veraendern)      "Verndern"
          set text(acc,vorschlag)   "v"
          set text(acc,ablegen)     "a"
          set text(acc,zugZurueck)  "z"
          set text(karten)          " Karten "
          set text(geben)           "Geben"
          set text(noch)            "Noch "
          set text(kartenUebrig)    " Karten"
          set text(kartenfonts)     " Kartenfonts "
          set text(mitComics)       "Mit Comics"
          set text(verteilen)       "Verteilen"
          set text(kartenbewegen)   "Kartenbewegen"
          set text(acc,geben)       "k"
          set text(hilfe)           " Hilfe "
          set text(spielregeln)     "Spielregeln"
          set text(demoHilfe)    "Das Drcken irgendeiner Taste beendet die Demo"
          set text(streitHilfe)  "Das Drcken von e oder n beendeet das Spiel"
          set text(zurueckHilfe) "Das Drcken irgendeiner Taste beendet die Rcknahme"
          set text(speicherAuswahl) "Dateiauswahl zum Speichern"
          set text(ladeAuswahl)     "Dateiauswahl zum Laden"
          set text(keineKartenFonts) \
                  "Nanu? Keine Kartenbitmap gefunden; deshalb ist jetzt Schluss..."
          set text(demonstration)    "Demonstration"
          set text(zeitverzoegerung) "Zeitverzgerung (in 1/10 Sekunden)"
          set text(regelEditor) "Regel-Editor"
          set text(neu)         "Neu"
          set text(anwenden)    "Anwenden"
          set text(nameIntern)  "Name (intern):"
          set text(nameExtern)  "Name (extern):"
          set text(kartensatz)  "Kartensatz:"
          set text(einSatz)     "1 (52 Karten)"
          set text(zweiSaetze)  "2 (104 Karten)"
          set text(streitArt)   "Streitpatience:"
          set text(nein)        "nein"
          set text(ja)          "ja"
          set text(jaGemeinsam) "ja, gemeinsamer Kartensatz"
          set text(jaGetrennt)  "ja, getrennter  Kartensatz"
          set text(talonExist)  "Talon        :"
          set text(strafeExist) "Strafstapel:"
          set text(stapelAnz)   "Anz. Stapel:"
          set text(stapelReihe) "Ablage Stapel:"
          set text(absteigend)  "Absteigend"
          set text(aufsteigend) "Aufsteigend"
          set text(aufAb)       "Auf-/Absteigend"
          set text(echt)        "Echt"
          set text(unecht)      "Unecht"
          set text(egal)        "Egal"
          set text(teilStapel)  "Teilstapel:"
          set text(einzelKarte) "nur einzelne Karte"
          set text(komplett)    "Komplett"
          set text(stockReihe)  "Ablage Stock:" 
          set text(strafReihe)  "Ablage Strafe:"
          set text(stockBasis)  "Stock Basis:"
          set text(bauer)       "Bauer"
          set text(dame)        "Dame"
          set text(koenig)      "Knig"
          set text(as)          "As"
          set text(ersteKarte)  "Erste Karte"
          set text(stapelBasis) "Stapel Basis:"
          set text(jedeKarte)   "jede Karte"
          set text(nurHoechste) "nur hchste Karte"
          set text(talonAb)     "Talon abrumbar:"
          set text(neuerSpielregeln) "Neue Spielregeln"
          set text(nameAufforderung) \
                  "Bitte noch nicht benutzten internen Name der Patience angeben:"
          set text(bisherVergeben) "Bisher vergebene interne Namen sind "
          set text(nurErlaubt) \
                  ". Es sind nur Buchstaben, Zahlen sowie - und _ erlaubt."
          set text(fs,ordner) "Ordner:"
          set text(fs,datei)  "Datei:"
          set text(fs,maske)  "Maske:"
          set text(version)          "Version"
          set text(patienceFuerX11)  "Eine Patience fr das X11-Windowsystem mit Tcl/Tk"
          set text(erstelltVonCK)    "erstellt von Christian Krone"
          set text(okay)             "Okay"
          set text(beendenTitel)     "Wirklich beenden?"
          set text(hoffeSpielWarGut) "Ich hoffe, Ihnen hat das Patience-Spiel gefallen."
          set text(wirklichBeenden)  "Wirklich Spiel beenden?"
          set text(abbruch)          "Abbruch"
          set text(spielende)        "Spielende"
          set text(neuesSpiel)       "Neues Spiel"
          set text(wirklichNeu)      "Wollen Sie wirklich ein neues Spiel beginnen?"
          set text(glueckwunsch)     "Glckwunsch"
          set text(gratuliere)       "Gratuliere!"
          set text(undEsGab)         "Und es gab "
          set text(einVorschlag)     "1 Vorschlag."
          set text(vorschlaege)      " Vorschlge."
          set text(patienceGeloest)  "Sie haben diese Patience gelst."
          set text(dazuBenoetigt)    "Dazu bentigten Sie "
          set text(zuege)            " Zge."
          set text(super)            "Super"
          set text(sieHabenGewonnen) "Sie haben diese Streit-Patience gewonnen. "
          set text(undGegnerHat)     "Und der Gegner hatte noch "
          set text(restKarte1)       " Karte auf seinen Stapeln."
          set text(restKarten1)      " Karten auf seinen Stapeln."
          set text(beileid)          "Beileid"
          set text(schade)           "Schade!"
          set text(sieHabenVerloren) "Sie haben diese Streit-Patience leider verloren. "
          set text(undSieHatten)     "Und Sie hatten noch "
          set text(restKarte2)       " Karte auf Ihren Stapeln."
          set text(restKarten2)      " Karten auf Ihren Stapeln."
          set text(naechstesMal)     "Nchste Mal"
          set text(spielAufgegangen) "Die Patience ist aufgegangen!"
          set text(aberSieHaben)     "Aber Sie haben genau "
          set text(malGeschummelt)   " mal geschummelt!"
          set text(vielleichtBesser) "Vielleicht geht es beim nchsten mal besser?"
          set text(probieren)        "Probieren"
          set text(nichtLesbar)        "Nicht Lesbar"
          set text(nichtSchreibbar)    "Nicht Schreibbar"
          set text(dieDatei)           "Die Datei "
          set text(istNichtLesbar)     " ist nicht lesbar."
          set text(istNichtSchreibbar) " ist nicht lesbar."
          set text(dannNicht)          "Dann nicht"
        }
        setzBenutzernamen
      }
    proc setzBenutzernamen {} {
      global env text

      if {[info exists env(USER)]} {
        set vorgabe $env(USER)
      } elseif {[info exists env(LOGNAME)]} {
        set vorgabe $env(LOGNAME)
      } else {
        set vorgabe ""
      }
      if {$vorgabe != ""} {
        set ersterGross [string toupper [string index $vorgabe 0]]
        set restKlein   [string range $vorgabe 1 end]
        set text(mensch) $ersterGross$restKlein
      }
    }
    proc kartenFarbe {rang} {
        switch -- $rang {
          0 {set aktFarbe c}
          1 {set aktFarbe h}
          2 {set aktFarbe p}
          3 {set aktFarbe k}
        }
      }
      proc farbRang {farbe} {
        switch -glob $farbe {
          *c* {set aktFarbe 0}
          *h* {set aktFarbe 1}
          *p* {set aktFarbe 2}
          *k* {set aktFarbe 3}
        }
      }
      proc passt {alt neu stapel} {
        global stapelReihe teilStapelReihe stockReihe strafReihe \
               patArt aktuellErste

        if {$neu == "" && [string match ?,? $stapel]} {
          set stockFarbe [string index $stapel 2]
          return [expr {[string match *,kompl $stockReihe($patArt)]
                        ? [aufsteigend $alt $aktuellErste 1]
                          && $stockFarbe == [string index $alt 1]
                        : [string range $alt 0 1] == "$aktuellErste$stockFarbe"}]
        }
        switch -glob $stapel {
          ?                {set regel $stapelReihe($patArt)}
          ?,?              {set regel $stockReihe($patArt)}
          teil             {set regel $teilStapelReihe($patArt)}
          talon* - strafe* {set regel $strafReihe($patArt)}
          default          {return 0}
        }
        switch -glob $regel {
          aufst,* {if {![aufsteigend $neu $alt 0]} {return 0}}
          abst,*  {if {![aufsteigend $alt $neu 0]} {return 0}}
          aufAb,* {if {![aufsteigend $alt $neu 0] &&
                       ![aufsteigend $neu $alt 0]} {return 0}}

          garNicht {return 0}
        }
        switch -glob $regel {
          *,unecht {if {![unecht $alt $neu]} {return 0}}
          *,echt   {if {![  echt $alt $neu]} {return 0}}
          *,kompl  {return 0}
        }
        return 1
      }
    proc mischen {} {
      global stapel fuelle kartenSatz patArt streitArt

      foreach runde {0 1} {
        set karten$runde {}
        if {$runde < $kartenSatz($patArt)} {
          foreach wert {k d b 0 9 8 7 6 5 4 3 2 a} {
            foreach farbe {c h p k} {
              lappend karten$runde $wert$farbe$runde
            }
          }
        }
      }
      if {$streitArt($patArt) != 2} {
        set karten [concat $karten0 $karten1]
      }
      foreach hand [expr {$streitArt($patArt) ? "hand hand2" : "hand"}] {
        if {$streitArt($patArt) == 2} {
          set karten [expr {$hand=="hand2" ? $karten1 : $karten0}]
        }
        set fuelle($hand) 0
        set nochDa [llength $karten]
        while {$nochDa > 0} {
          set oben [unifRand $nochDa] 
          set stapel($hand,$fuelle($hand)) [lindex $karten $oben]
          set karten [lreplace $karten $oben $oben]
          incr fuelle($hand)
          incr nochDa -1
        }
      }
    }
    proc mkMenue {} {
        global patArt fuelle patiencePath patName zugNr flaeche \
            kartenFont kartenFonts text sprache warteZeit

        wm iconbitmap . @$patiencePath/bitmaps/icon
        frame .menu -relief raised -borderwidth 1
        pack  .menu -fill x
        menubutton .menu.xlogo -bitmap @/usr/include/X11/bitmaps/xlogo11 \
                               -menu .menu.xlogo.m
        menu .menu.xlogo.m
        .menu.xlogo.m add command -label $text(erstelltVon) -command "erstelltVon"
        menubutton .menu.pat -text $text(spiel) -menu .menu.pat.m -underline 1
        menu .menu.pat.m

        foreach aktPat [interneRegelNamen] {
          if {[info exists patName($aktPat,$sprache)]} {
            .menu.pat.m add radio -label $patName($aktPat,$sprache) \
                        -var neuPat -val $aktPat -command "starteSpiel 1"
          }
        }
        .menu.pat.m add separator
        .menu.pat.m add command -lab $text(werStreitetSich) -state disabled
        .menu.pat.m add radio   -lab $text(mensch)/$text(computer) \
                                -var streitGegner -val computer
        .menu.pat.m add separator
        .menu.pat.m add command -lab $text(demo) -acc $text(acc,demo) \
                                -com "demo" -und 0
        set zehntel [expr {double($warteZeit)/10}]
        .menu.pat.m add command -lab $text(warte)$zehntel$text(sekunden) \
                                -com "warteZeit" -und 0
        .menu.pat.m add separator
        .menu.pat.m add command -lab $text(bildErneuern) -com "bildNeu" -acc ^L
        .menu.pat.m add separator
        .menu.pat.m add command -lab $text(beenden) -com "schluss" \
                                -und 0 -acc $text(acc,beenden)
        menubutton .menu.datei -text $text(datei) -menu .menu.datei.m -underline 1
        menu .menu.datei.m
        .menu.datei.m add command -lab $text(spielzustand) -state disabled
        .menu.datei.m add command -lab $text(laden) \
                                -com laden -acc $text(acc,laden) -und 0
        .menu.datei.m add command -lab $text(speichern) \
                                -com speichern -acc $text(acc,speichern) -und 0
        .menu.datei.m add separator
        .menu.datei.m add command -lab $text(regelnEditieren) -com "regelEdit" -und 0
        .menu.datei.m add separator
        .menu.datei.m add command -lab $text(sprache) -state disabled
        foreach sprachDatei [glob -nocomplain $patiencePath/text/*] {
          regexp {.*/([^/]*)$} $sprachDatei egal aktSprache
          set ersterGross [string toupper [string index $aktSprache 0]]
          set restKlein   [string range $aktSprache 1 end]
          .menu.datei.m add radio -lab $ersterGross$restKlein \
                        -var sprache -val $aktSprache -command "setzSprache"
        }
        menubutton .menu.hilfe -text $text(hilfe) -menu .menu.hilfe.m -underline 1
        menu .menu.hilfe.m
        .menu.hilfe.m add command -lab $text(spielregeln) -com ersteHilfe -und 0
        if {![file readable $patiencePath/manual/pat-$sprache.tty]} {
          .menu.hilfe.m entryconfigure $text(spielregeln) -state disabled
        }
        menubutton .menu.schmu -text $text(unterstuetzung) -menu .menu.schmu.m -und 1
        menu .menu.schmu.m
        .menu.schmu.m add command -lab $text(vorschlag) \
                                  -com "vorschlag 0" -acc $text(acc,vorschlag)
        .menu.schmu.m add command -lab $text(ablegen) \
                                  -com "ablegen" -acc $text(acc,ablegen)
        .menu.schmu.m add sep
        .menu.schmu.m add command -lab $text(zugZurueck) -com "zugZurueck"  \
                                        -acc $text(acc,zugZurueck)  -state disabled
        .menu.schmu.m add command -lab $text(zumAnfang) -com "zumAnfang" \
                                                        -state disabled
        .menu.schmu.m add sep
        .menu.schmu.m add check   -lab $text(merken)    -com merken -var gemerkt \
                                                     -state disabled
        .menu.schmu.m add command -lab $text(zurMarke)  -com "zurMarke" \
                                                        -state disabled
        .menu.schmu.m add sep
        .menu.schmu.m add check   -lab $text(veraendern)  -var veraendern
        menubutton .menu.karten -text $text(karten) -menu .menu.karten.m -und 1
        menu .menu.karten.m
        .menu.karten.m add command -lab $text(geben) \
                                   -command "geben hand" -acc $text(acc,geben)
        .menu.karten.m add command -lab $text(noch)0$text(kartenUebrig) \
                                                         -state disabled
        .menu.karten.m add sep
        .menu.karten.m add command -lab $text(kartenfonts) -state disabled
        foreach font [array names kartenFonts] {
          if {[info exists kartenFont($font,name-$sprache)]} {
            set fontLabel $kartenFont($font,name-$sprache)
          } else {
            set fontLabel font
          }
          .menu.karten.m add radio -label $fontLabel -var aktFont -val $font \
                                   -command {setBitPath $aktFont}
        }
        .menu.karten.m add sep
        .menu.karten.m add command -lab $text(mitComics)   -state disabled
        .menu.karten.m add check   -lab $text(verteilen)     -var mitMischComic
        .menu.karten.m add check   -lab $text(kartenbewegen) -var mitBewegComic
        pack .menu.xlogo .menu.pat .menu.datei .menu.schmu .menu.karten -side left
        pack .menu.hilfe -side right
        tk_bindForTraversal $flaeche
        bind . <Any-Enter> {focus $flaeche}
        tk_menuBar .menu .menu.xlogo  .menu.pat .menu.datei .menu.schmu .menu.karten \
                         .menu.hilfe
        trace variable zugNr        w chkZugNr
        trace variable fuelle(hand) w chkKartenAnz
        trace variable patArt       w chkStreitGegner
        chkStreitGegner patArt "" w
      }
    proc chkZugNr {name1 name2 op} {
      global zugNr marke gemerkt streitArt patArt text

      if {!$streitArt($patArt)} {
        .menu.schmu.m entryconfigure $text(zugZurueck) \
            -state [expr {$zugNr > 0 ? "normal" : "disabled"}]
        .menu.schmu.m entryconfigure $text(zumAnfang) \
            -state [expr {$zugNr > 0 ? "normal" : "disabled"}]
        if {$zugNr<$marke} {set gemerkt 0}
        .menu.schmu.m entry $text(zurMarke) \
            -state [expr {$gemerkt && $zugNr > $marke ? "normal" : "disabled"}]
        .menu.schmu.m entry $text(merken) \
            -state [expr {$zugNr > 0 ? "normal" : "disabled"}]
      }
    }
    proc chkStreitGegner {name1 name2 op} {
      upvar #0 $name1 patArt
      global streitArt altGegner streitGegner text

      foreach gegner "$text(mensch)/$text(computer)" {
        if {$streitArt($patArt)} {
          if {[info exists altGegner]} {
            set streitGegner $altGegner
            unset altGegner
          }
          .menu.pat.m entryconfigure $gegner     -state normal
          .menu.pat.m entryconfigure $text(demo) -state disabled
          .menu.schmu configure -state disabled
          .menu.schmu.m unpost
        } else {
          if {[info exists streitGegner] && ![info exists altGegner]} {
            set altGegner $streitGegner
          }
          set streitGegner ""
          .menu.pat.m entryconfigure $gegner     -state disabled
          .menu.pat.m entryconfigure $text(demo) -state normal
          .menu.schmu configure -state normal
        }
      }
    }
    proc chkKartenAnz {name1 name2 op} {
      upvar #0 $name1 fuelle
      global text

      .menu.karten.m entryconf "$text(noch)*$text(kartenUebrig)" \
            -label $text(noch)$fuelle($name2)$text(kartenUebrig)
    }
    proc aktiviereKritischeKommandos {an} {
      global flaeche text streitArt patArt

      if {$an == "ein"} {
        if {!$streitArt($patArt)} {
          .menu.pat.m  entryconfigure $text(demo)      -state normal
        }
        .menu.schmu.m  entryconfigure $text(vorschlag) -state normal
        .menu.karten.m entryconfigure $text(geben)     -state normal
      } else {
        .menu.pat.m    entryconfigure $text(demo)      -state disabled
        .menu.schmu.m  entryconfigure $text(vorschlag) -state disabled
        .menu.karten.m entryconfigure $text(geben)     -state disabled

        bind $flaeche <$text(acc,demo)> ""
        bind $flaeche <$text(acc,neuesSpiel)> ""
        bind $flaeche <$text(acc,vorschlag)> ""
        bind $flaeche <$text(acc,geben)> ""
      }
    }
    proc aktiviereGeben {hand an} {
      global flaeche text demoAktiv

      if {$an == "ein"} {
        if {![info exists demoAktiv] || $demoAktiv == 0} {
          $flaeche bind $hand <1> "geben $hand"
          bind $flaeche $text(acc,geben) "geben $hand"
        }
        .menu.karten.m entryconfigure $text(geben) -state normal
      } else {
        nichtVerschiebbar $hand
        bind $flaeche $text(acc,geben) ""
        .menu.karten.m entryconfigure $text(geben) -state disabled
      }
    }
    proc istGebenAktiv {} {
      global text

      set status [lindex [.menu.karten.m entryconfigure $text(geben) -state] 4]
      return [expr {$status == "normal"}]
    }
    proc menueHilfe {was} {
      global alteMenueLeiste text

      if {$was == "aus"} {
        catch {destroy .menu.endtext}

        eval $alteMenueLeiste
      } else {
        if {![info exists alteMenueLeiste]} {
          set alteMenueLeiste ""
          foreach menuePunkt [pack slaves .menu] {
            set aktiv [lindex [$menuePunkt configure -state] 4]
            append alteMenueLeiste "
                   pack $menuePunkt [pack newinfo $menuePunkt]
                   $menuePunkt configure -state $aktiv"
          }
        }
        foreach menuePunkt [pack slaves .menu] {
          if {![catch {$menuePunkt configure -state disabled}]} {
            pack forget $menuePunkt
          }
        }
        catch {label .menu.endtext -text $text(${was}Hilfe)}
        pack  .menu.endtext -anchor w -side left
      }
      update
    }
    proc ersteHilfe {} {
      global sprache patiencePath text

      set w .regeln
      catch {destroy $w}
      toplevel $w
      wm title    $w $text(spielregeln)
      wm iconname $w $text(spielregeln)
      button $w.ok -text Okay -command "destroy $w"
      text $w.t -relief raised -bd 2 -yscrollcommand "$w.s set" -width 85 \
            -font -Adobe-times-medium-r-normal--*-140*
      scrollbar $w.s -relief flat -command "$w.t yview"
      pack $w.ok -side bottom -fill x
      pack $w.s -side right -fill y
      pack $w.t -expand yes -fill both

      set f [open $patiencePath/manual/pat-$sprache.tty]
      while {![eof $f]} {
        $w.t insert end [read $f 1000]
      }
      close $f
      $w.t configure -state disabled 
      bind $w <Any-Enter> "focus $w.t"
    }
    proc speichern {} {
      global zustDateiName text

      if [holDateiName $text(speicherAuswahl) zustDateiName "" \
                       "*.pat" "spiel.pat"] {
        schrZustand $zustDateiName
      }
    }
    proc laden {} {
      global zustDateiName text

      if [holDateiName $text(ladeAuswahl) zustDateiName "*" \
                       "*.pat" "spiel.pat"] {
        liesZustand $zustDateiName
      }
    }
    proc holDateiName {text dateiName magic ext defaultName} {
      upvar 1 $dateiName name

      if {![info exist name] || $name == ""} {
        set dir   [pwd]
        set datei $defaultName
      } else {
        set dir   ""; regexp {(.*)/}  $name egal dir
        set datei ""; regexp {[^/]*$} $name datei
      }
      set neuName [fileSelect .fs $text $datei $dir $ext]
      if {$neuName == ""} {return 0}

      if {$magic != ""} {
        if {![file readable $neuName]} {
          nichtLesbar $neuName
          return 0
        }
      } else {
        if {[file exist $neuName]} {
          set allesKlar [expr {[file writable $neuName] &&
                               ![file isdirectory $neuName]}]
        } else {
          set zielDirectory [file dirname $neuName]
          set allesKlar [expr {[file writable $zielDirectory] &&
                               [file isdirectory $zielDirectory]}]
        }
        if {!$allesKlar} {
          nichtSchreibbar $neuName
          return 0
        }
      }
      set name $neuName
      return 1
    }
    proc setzSprache {} {
      global sprache patiencePath text patArt

      if [catch {source $patiencePath/text/$sprache}] return
      destroy .menu
      setzBenutzernamen
      mkMenue
      aktiviereBindings
      set patArt $patArt
      regelEdit 1
    }
    proc mkFlaeche {} {
        global flaeche roteFarbe weisseFarbe graueFarbe warteZeit \
               mitMischComic mitBewegComic

        set flaeche [canvas .patience -closeenough 0.0]

        global patiencePath env
        catch {option readfile $patiencePath/app-default startupFile}
        catch {option readfile $env(HOME)/.Xdefaults     userDefault}
        option add *patience.width         640            widgetDefault
        option add *patience.height        404            widgetDefault
        option add *patience.warteZeit     10             widgetDefault
        option add *patience.rot           IndianRed4     widgetDefault
        option add *patience.grau          gray80         widgetDefault
        option add *patience.weiss         gray95         widgetDefault
        option add *patience.mitMischComic True           widgetDefault
        option add *patience.mitBewegComic True           widgetDefault
        option add *patience.kartenFont    normal         widgetDefault
        option add *patience.sprache       deutsch        widgetDefault

        liesTexte

        pack $flaeche -side bottom -expand 1 -fill both
        
        global kartenFont kartenFonts patiencePath aktFont

        foreach kartenSatz [glob -nocomplain $patiencePath/bitmaps/*/dimensionen] {
          source $kartenSatz
          set kartenFonts($kartenSatz) $kartenSatz
        }
        set aktFont [option get $flaeche kartenFont KartenFont]
        if {![info exists kartenFonts($aktFont)]} {
          set aktFont normal
          if {![info exists kartenFonts($aktFont)]} {
            global text

            puts $text(keineKartenFonts)
            exit 1
          }
        }

        set warteZeit [option get $flaeche warteZeit WarteZeit]
        if [catch {set warteZeit [expr int($warteZeit)]}] {
          set warteZeit 10
        }

        set roteFarbe   [option get $flaeche rot   Foreground]
        set graueFarbe  [option get $flaeche grau  Background]
        set weisseFarbe [option get $flaeche weiss Background]

        set mitMischComic [string match {[Tt]*} \
                               [option get $flaeche mitMischComic MitComic]]
        set mitBewegComic [string match {[Tt]*} \
                               [option get $flaeche mitBewegComic MitComic]]
      }
      proc fuellFlaeche {} {
        global patiencePath patName zugNr flaeche patArt

        trace variable patArt w setzFenstertitel
        setzFenstertitel patArt "" w

        trace variable patArt w setzStrafX
        bind $flaeche <Configure> "setBitPath"
        setBitPath <>

        set hinterGrund [lindex [$flaeche configure -background] 4]
        label $flaeche.kartenAnz  -textvar fuelle(hand)  -width 3 -back $hinterGrund
        label $flaeche.kartenAnz2 -textvar fuelle(hand2) -width 3 -back $hinterGrund
        update
        wm minsize . [winfo width .] [winfo height .]
      }
      proc setzFenstertitel {art leer op} {
        global patienceVersion patName text sprache
        upvar #0 $art patArt

        if {[info exists patName($patArt,$sprache)]} {
          set name $patName($patArt,$sprache)
        } else {
          set name $patArt
        }
        wm title . "$text(patience) $patienceVersion / $name"
      }
    proc aktiviereBindings {{command {}}} {
      global flaeche streitArt patArt text spezialKommando

      set spezialKommando $command
      if {$command == ""} {
        foreach event [list Key Button] {
          bind $flaeche <$event> ""
        }
        foreach stapel {hand hand2} {
          $flaeche bind $stapel <1> "geben $stapel"
        }
        bind $flaeche <3>                    "tuWasGutes %x %y"
        bind $flaeche <$text(acc,speichern)> "speichern"
        bind $flaeche <$text(acc,laden)>     "laden"
        bind $flaeche <Control-Key>          "vorschlagDebug %K"
        if {!$streitArt($patArt)} {
          bind $flaeche <$text(acc,ablegen)>    "ablegen"
          bind $flaeche <$text(acc,vorschlag)>  "vorschlag 0"
          bind $flaeche <$text(acc,zugZurueck)> "zugZurueck"
          bind $flaeche <$text(acc,demo)>       "demo"
          bind $flaeche <$text(acc,geben)>     "geben hand"
        } else {
          bind $flaeche <$text(acc,geben)>     "geben hand2"
        }
      } else {
        foreach stapel {hand hand2} {
          $flaeche bind $stapel <1> $command
          $flaeche bind $stapel <3> $command
        }
        if {[string index $command 0] == "+"} {
          set command [string range $command 1 end]
          set addBinding "+"
        } else {
          set addBinding ""
        }
        foreach event [list $text(acc,geben)     $text(acc,ablegen)    \
                            $text(acc,vorschlag) $text(acc,demo)       \
                            $text(acc,speichern) $text(acc,zugZurueck) \
                            $text(acc,laden) Key Button] {
          bind $flaeche <$event> \
                    "${addBinding}if {\"%K\" != \"Control_L\"} {$command}"
        }
      }
      bind $flaeche <$text(acc,beenden)>    "schluss"
      bind $flaeche <$text(acc,neuesSpiel)> "starteSpiel 1"
      bind $flaeche <Control-l>             "bildNeu"
    }
    proc setBitPath {{neuFont ""}} {
      global bitPath patiencePath kartenHoehe stapelBreite fuelle posX posY \
          gesStockHoehe bildBreite bildHoehe flaeche stockHoehe \
          streitArt stapelAnz kartenSatz patArt kartenFont aktFont stapel

      set stapelBreite  $kartenFont($aktFont,breite)
      set kartenHoehe   $kartenFont($aktFont,hoehe)
      set stockHoehe    [expr {$kartenHoehe*2/3}]
      set gesStockHoehe [expr {$stockHoehe*3+$kartenHoehe+2}]

      set minStapel [expr {$stapelAnz($patArt)+$kartenSatz($patArt)}]
      if {$minStapel < 10} {set minStapel 10}
      set minBreite     [expr {$stapelBreite*$minStapel}] 
      set minHoehe      [expr {$gesStockHoehe+$kartenHoehe+30}]

      set bitPath "$patiencePath/bitmaps/$aktFont"

      set derzeitigeBreite [winfo width $flaeche]
      set derzeitigeHoehe  [winfo height $flaeche]
      if {$neuFont == "<>" && $minBreite <= $derzeitigeBreite &&
                              $minHoehe  <= $derzeitigeHoehe} {
        set neuFont ""
      }
      if {$neuFont != ""} {
        wm geometry . {}
        $flaeche configure -width $minBreite -height $minHoehe
        update
        if {$minHoehe != $derzeitigeHoehe || $minBreite != $derzeitigeBreite} {
          return
        }
      }

      set bildBreite [winfo width  $flaeche]
      set bildHoehe  [winfo height $flaeche]
      set posX(hand)      [expr $bildBreite-$stapelBreite+4]
      set posY(hand)      [expr $bildHoehe-$kartenHoehe]
      set posX(hand2)     0
      set posY(hand2)     $posY(hand)
      set posX(talon)     [expr $bildBreite-2*$stapelBreite]
      set posY(talon)     $posY(hand)
      set posX(talon2)    [expr $stapelBreite+2]
      set posY(talon2)    $posY(hand)
      set posX(schachUhr) [expr $bildBreite/2]
      set posY(schachUhr) $bildHoehe
      set posY(strafe)    $posY(hand)
      set posX(strafe2)   [expr 2*$stapelBreite+2]
      set posY(strafe2)   $posY(hand)
      setzStrafX patArt "" w

      if {$bildBreite < $minBreite || $bildHoehe < $minHoehe} {
        # Notfall: Bildschirmgroesse reicht fuer Font nicht aus; deshalb jetzt
        # auf kleinen Font umschalten, und sich selbst rekursiv aufrufen.
        set aktFont normal
        setBitPath $aktFont
      } elseif {[info exists stapel]} {
        # Bild mit dem aktuellen Spiel neu aufbauen.
        bildNeu
      }
    }
    proc setzStrafX {art leer op} {
      global posX bildBreite stapelBreite streitArt
      upvar #0 $art patArt

      if {$streitArt($patArt)} {
        set posX(strafe) [expr {$bildBreite-3*$stapelBreite}]
      } else {
        set posX(strafe) 0
      }
    }
    proc spielXY {spielX spielY absX absY} {
      upvar $spielX relX $spielY relY
      global bildBreite bildHoehe flaeche

      set relX [$flaeche canvasx $absX]
      set relY [$flaeche canvasy $absY]
      if {$relX<0} {set relX 0} elseif {$relX>$bildBreite} {set relX $bildBreite}
      if {$relY<0} {set relY 0} elseif {$relY>$bildHoehe}  {set relY $bildHoehe}
    }
    proc stapelX {stapel} {
      global stapelBreite bildBreite posX

      switch -glob $stapel {
        ?       {return [expr $stapel*$stapelBreite+2]}
        ?,?     {return [expr $bildBreite \
                                 - ([string index $stapel 0]+1)*$stapelBreite]}
        default {return $posX($stapel)}
      }
    }
    proc stapelY {stapel {aktY 0}} {
      global stockHoehe bildHoehe kartenHoehe fuelle exist streitArt patArt posY

      switch -glob $stapel {
        ? {
          if {$aktY <= 0} {return 2}

          set verfuegbar [expr $bildHoehe-10]
          switch $stapel 0 - 1 - 2 {
            if {$streitArt($patArt) || $exist($patArt,strafe) > 0} {
              incr verfuegbar [expr -2*$kartenHoehe]
            }
          }
          set maxHoehe [expr {double($bildHoehe)/20}]
          if {$fuelle($stapel) > 1} {
            set hoeheProKarte [expr {double($verfuegbar)/$fuelle($stapel)}]
            if {$hoeheProKarte > $maxHoehe} {set hoeheProKarte $maxHoehe}
          } else {
            set hoeheProKarte $maxHoehe
          }

          return [expr {$aktY*$hoeheProKarte+2}]
        }
        ?,?     {return [expr {[farbRang $stapel]*$stockHoehe+2}]}
        default {return $posY($stapel)}
      }
    }
    proc findeStapel {neuX neuY} {
      global stapelAnz kartenSatz streitArt patArt fuelle posX posY \
          stapelBreite stockHoehe gesStockHoehe bildBreite kartenHoehe
      
      spielXY x y $neuX $neuY
      
      foreach sonderStapel {talon talon2 strafe strafe2 hand} {
        if {[info exists fuelle($sonderStapel)] && $fuelle($sonderStapel) > 0    \
            && $x>=$posX($sonderStapel) && $x<$posX($sonderStapel)+$stapelBreite \
            && $y>=$posY($sonderStapel) && $y<$posY($sonderStapel)+$kartenHoehe} {
          return $sonderStapel
        }
      }
      if {$x>=$posX(hand2) && $x<$posX(hand2)+$stapelBreite &&
          $y>=$posY(hand2) && $y<$posY(hand2)+$kartenHoehe} {
        if {$streitArt($patArt)} {return hand2}
      }
      if {$x < $stapelAnz($patArt)*$stapelBreite} {
        return [expr $x/$stapelBreite]
      } 
      if {$x > $bildBreite-$kartenSatz($patArt)*$stapelBreite \
          && $y < $gesStockHoehe} {
        if {$y >= $stockHoehe*4} {set y [expr $stockHoehe*4]}
        set aktSatz  [expr ($bildBreite-$x)/$stapelBreite]
        set aktFarbe [kartenFarbe [expr int (($y-2)/$stockHoehe)]]
        return $aktSatz,$aktFarbe
      }
      return ""
    }
    proc umdrehbar {karte stapel} {
      global flaeche

      $flaeche bind $karte <1> "drehUm $karte $stapel"
    }
    proc verschiebbar {karte stapel} {
      global flaeche

      $flaeche bind $karte <1> "startEinzelKarte $karte %x %y $stapel"
    }
    proc teilStapelBar {karte} {
      global flaeche

      $flaeche bind $karte <1> "startTeilStapel $karte %x %y"
    }
    proc nichtVerschiebbar {karte} {
      global flaeche

      $flaeche bind $karte <1> ""
      nichtBewegbar $karte
    }
    proc nichtBewegbar {karte} {
      global flaeche

      $flaeche bind $karte <B1-Motion>           ""
      $flaeche bind $karte <Any-ButtonRelease-1> ""
    }
    proc kurzePause {} {
      after 1 {set kurzePauseZumDruecken 1}
      tkwait variable kurzePauseZumDruecken
    }
    proc pruefStapelFuelle {aktStapel} {
      global stapel fuelle flaeche

      set oben [expr {$fuelle($aktStapel)-1}]
      if {$oben < 1 || [lindex [$flaeche coords $stapel($aktStapel,$oben)] 1]
                         == [stapelY $aktStapel $oben]} return

      set aktX [stapelX $aktStapel]
      for {set aktI 0} {$aktI < $fuelle($aktStapel)} {incr aktI} {
        $flaeche coords $stapel($aktStapel,$aktI) \
                        $aktX [stapelY $aktStapel $aktI]
      }
    }
    proc maleLeereStoecke {} {
      global kartenSatz patArt bitPath flaeche streitArt \
             kartenFont aktFont roteFarbe weisseFarbe graueFarbe

      set mitFarbe [expr {![info exists kartenFont($aktFont,sw)]}]

      set letzter ""
      for {set aktSatz 0} {$aktSatz < $kartenSatz($patArt)} {incr aktSatz} {
        foreach aktFarbe {c h p k} {
          set tag s$aktFarbe$aktSatz
          $flaeche create bitmap [stapelX $aktSatz,$aktFarbe] \
                 [stapelY $aktSatz,$aktFarbe] -background $weisseFarbe \
                  -anchor nw -bitmap @$bitPath/s$aktFarbe -tag $tag
          if {$mitFarbe} {
            switch $aktFarbe c - h {
              $flaeche itemconfigure $tag -foreground $roteFarbe
            }
            $flaeche itemconfigure $tag -background $graueFarbe
          }
          $flaeche lower $tag
          if {$letzter != ""} {
            $flaeche raise $tag $letzter
          }
          set letzter $tag
        }
      }
    }
    proc maleZugbestaetigungsknopf {} {
      global flaeche aktiverSpieler weisseFarbe roteFarbe

      set uhr $flaeche.schachUhr
      if {![winfo exists $uhr]} {
        button $uhr -textvariable aktiverSpieler                            \
                    -background $weisseFarbe -activebackground $weisseFarbe \
                    -command "streitZugBestaetigung $uhr" 
      }
      $flaeche create window [stapelX schachUhr] [stapelY schachUhr] \
                            -anchor s -window $uhr -tag schachUhr    \
                            -width 150 -height 50
      set lr [expr {[stapelX schachUhr] - 75}]
      set ll [expr {$lr - 10}]
      set rl [expr {[stapelX schachUhr] + 75}]
      set rr [expr {$rl + 10}]
      set u  [stapelY schachUhr]
      set o  [expr {$u - 50}]
      set m  [expr {($o+$u)/2}]
      $flaeche create polygon $lr $u $lr $o $ll $m $lr $u -tags links
      $flaeche create polygon $rl $u $rl $o $rr $m $rl $u -tags rechts
      if {$aktiverSpieler == "Computer"} {
        $uhr configure -state "disabled"
        $flaeche itemconfigure links  -fill ""
        $flaeche itemconfigure rechts -fill $roteFarbe
      } else {
        $uhr configure -state "normal"
        $flaeche itemconfigure links  -fill $roteFarbe
        $flaeche itemconfigure rechts -fill ""
      }
    }
    proc streitZugBestaetigung {uhr} {
      global aktiverSpieler text flaeche roteFarbe

      set aktiverSpieler Computer
      $uhr configure -state disabled
      $flaeche itemconfigure links  -fill ""
      $flaeche itemconfigure rechts -fill $roteFarbe
      .menu.karten.m entryconfigure $text(geben) -command ""
      demo
    }
    proc bildNeu {} {
      global stapel fuelle verdeckt bildBreite bildHoehe stapelBreite      \
             patArt stapelAnz kartenSatz exist bitPath spielFertig flaeche \
             posX posY streitArt kartenFont aktFont graueFarbe weisseFarbe

      # Alle Items der Spielflaeche wegschmeissen und leere Flaeche malen.
      $flaeche delete all
      update

      foreach aktHand {hand hand2} {
        if {[info exists fuelle($aktHand)] && $fuelle($aktHand) != " "} {
          $flaeche create bitmap $posX($aktHand) $posY($aktHand) \
                -tag $aktHand -anchor nw \
                -bitmap @$bitPath/[expr {$fuelle($aktHand) ? "ruecken" : "h"}]
          if {$fuelle($aktHand) || [info exists kartenFont($aktFont,sw)]} {
            $flaeche itemconfigure $aktHand -background $weisseFarbe
          } else {
            $flaeche itemconfigure $aktHand -background $graueFarbe
          }
        }
      }
      maleLeereStoecke
      maleKartenAnz
      for {set aktSatz 0} {$aktSatz < $kartenSatz($patArt)} {incr aktSatz} {
        foreach aktFarbe {c h p k} {
          set aktStock $aktSatz,$aktFarbe
          for {set aktY 0} {$aktY < $fuelle($aktStock)} {incr aktY} {
            set karte $stapel($aktStock,$aktY)
            maleKarte    $karte neu $aktStock
            steckInStock $aktStock $karte 0
          }
        }
      }
      update
      foreach sonderStapel {talon talon2 strafe strafe2} {
        if {[info exists fuelle($sonderStapel)]} {
          set verdeckt($sonderStapel) 0
          for {set aktI 0} {$aktI < $fuelle($sonderStapel)} {incr aktI} {
            maleKarte $stapel($sonderStapel,$aktI) neu $sonderStapel
          }
        }
      }
      update
      for {set aktStapel 0} {$aktStapel < $stapelAnz($patArt)} {incr aktStapel} {
        for {set aktY 0} {$aktY < $fuelle($aktStapel)} {incr aktY} {
          set karte $stapel($aktStapel,$aktY)

          if {$aktY < $verdeckt($aktStapel)} {
            $flaeche create bitmap [stapelX $aktStapel] \
                                   [stapelY $aktStapel $aktY] \
                                   -background $weisseFarbe -anchor nw \
                                   -tags $karte -bitmap @$bitPath/ruecken
            nichtVerschiebbar $karte
          } else {
            maleKarte $karte neu $aktStapel $aktY
          }
        }
        pruefFreieKarte $aktStapel minusEins
        update
      }

      if {$streitArt($patArt)} {
        maleZugbestaetigungsknopf
      }
    }
    proc maleKartenAnz {} {
      global flaeche posX posY stapelBreite streitArt patArt

      $flaeche create window [expr $posX(hand)+$stapelBreite/2] $posY(hand) \
          -anchor s -window $flaeche.kartenAnz
      if {$streitArt($patArt)} {
        $flaeche create window [expr $posX(hand2)+$stapelBreite/2] $posY(hand2) \
            -anchor s -window $flaeche.kartenAnz2
      }
    }
    proc maleKarte {karte neu aktStapel {aktY 0}} {
      global bitPath flaeche roteFarbe weisseFarbe fuelle

      if {$neu >= "neu"} {
        $flaeche create bitmap [stapelX $aktStapel] [stapelY $aktStapel $aktY] \
                    -background $weisseFarbe -anchor nw -tags $karte
      } else {
        $flaeche coords $karte [stapelX $aktStapel] [stapelY $aktStapel $aktY]
        $flaeche raise  $karte
      }
      $flaeche itemconfigure $karte -bitmap @$bitPath/[string range $karte 0 1]
      verschiebbar $karte $aktStapel

      if [string match ?\[ch\]? $karte] {
        $flaeche itemconfigure $karte -foreground $roteFarbe
      }
    }
    proc maleRuecken {karte aktStapel {aktY -1}} {
      global bitPath flaeche weisseFarbe

      if {$aktY >= 0} {
        $flaeche create bitmap [stapelX $aktStapel] [stapelY $aktStapel $aktY] \
                    -background $weisseFarbe -anchor nw -tags $karte
      }
      $flaeche itemconfigure $karte -bitmap @$bitPath/ruecken -foreground Black
      nichtVerschiebbar $karte
    }
    proc pfeil {vonStap vonY nachStap nachY festeZeit} {
      global warteZeit flaeche

      set tausendstel [expr $warteZeit*100]
      if {$festeZeit && $tausendstel <= 0} {set tausendstel 0}

      set vonX  [expr {[stapelX $vonStap]        +30}]
      set vonY  [expr {[stapelY $vonStap  $vonY] +10}]
      set nachX [expr {[stapelX $nachStap]       +30}]
      set nachY [expr {[stapelY $nachStap $nachY]+10}]

      if {$tausendstel} {
        $flaeche create line $vonX $vonY $nachX $nachY -tag pfeil -width 5 \
            -arrow last -arrowshape {10 10 5}
      }
      update idletasks
      if {$festeZeit} {
        # Ab tk3.3 reagiert after nicht mehr auf Events. Schade eigentlich...
        after $tausendstel set warteZeitVorbei 1
        tkwait variable warteZeitVorbei
      } else {
        aktiviereBindings "+set pfeilAus 0"
        tkwait variable pfeilAus
        aktiviereBindings
      }
      if {$tausendstel} {
        $flaeche delete pfeil
      }
    }
    proc karteWeg {karte} {
      global flaeche bildBreite bildHoehe

      $flaeche coords $karte $bildBreite $bildHoehe
    }
    proc mischComic {hand} {
      global bitPath flaeche posX posY stapelBreite mitMischComic weisseFarbe

      $flaeche create bitmap $posX($hand) $posY($hand) -anchor nw \
          -bitmap @$bitPath/ruecken -background $weisseFarbe -tag $hand
      if {!$mitMischComic} return

      $flaeche create bitmap $posX($hand) $posY($hand) -anchor nw \
          -bitmap @$bitPath/ruecken -background $weisseFarbe -tag beweg

      # Falls die Hand links unten ist, muss nach rechts gemischt werden...
      set hin     [expr {$posX($hand) < $stapelBreite ? 3 : -3}]
      set zurueck [expr {-$hin}]

      for {set j 0} {$j < 8} {incr j} {
        $flaeche raise beweg
        for {set i 0} {$i < 20} {incr i} {
          $flaeche move beweg $hin 0
          update idletask
        }
        $flaeche lower beweg
        for {set i 0} {$i < 20} {incr i} {
          $flaeche move beweg $zurueck 0
          update idletask
        }
      }
      $flaeche delete beweg
    }
    proc verteilComic {vonStapel vonY nachStapel nachY {kartenAnz 1}} {
      global stapelBreite kartenHoehe flaeche mitBewegComic

      if {!$mitBewegComic} return

      # Die vier Start-Eckpunkte der durch die nordwestliche Ecke beschriebenen
      # Karte berechnen.
      set l  [stapelX $vonStapel]
      set r  [expr $l+$stapelBreite]
      set o  [stapelY $vonStapel $vonY]
      set u  [expr $o+$kartenHoehe+double($kartenAnz-1)*20]
      # Das neunschrittige Inkrement zwischen Start und Ziel berechnen.
      set dx [expr ([stapelX $nachStapel       ]-$l)/9]
      set dy [expr ([stapelY $nachStapel $nachY]-$o)/9]

      # Nach den ganzen Vorbereitungen nun die eigentliche Darstellung.
      $flaeche create line $r $u $l $u $l $o $r $o $r $u -tag umriss
      for {set k 0} {$k < 8} {incr k} {
        $flaeche move umriss $dx $dy
        update idletask
      }
      $flaeche delete umriss
      update idletask
    }
    proc warteZeit {{w .form}} {
        global warteZeit text

        catch {destroy $w}
        toplevel $w
        wm title $w    $text(demonstration)
        wm iconname $w $text(demonstration)
        message $w.msg -font -Adobe-times-medium-r-normal--*-180* -width 4i \
                  -text $text(demonstration)
        frame $w.f1 -bd 1
        scale $w.f1.scale -orient horizontal -length 280 -from 0 -to 100 \
                -command "setWarteZeit" -tickinterval 20
        $w.f1.scale set $warteZeit
        label $w.f1.label -text $text(zeitverzoegerung)
        pack append $w.f1 $w.f1.label top $w.f1.scale bottom
        button $w.ok -text OK -command "destroy $w"
        pack append $w $w.msg {top} $w.f1 {top fillx} $w.ok {bottom fill}
      }
      proc setWarteZeit {wert} {
        global warteZeit text

        set warteZeit $wert
        .menu.pat.m entryconfigure $text(warte)*$text(sekunden) \
                       -label $text(warte)[expr {double($wert)/10}]$text(sekunden)
      }
    proc demo {} {
      global fuelle verdeckt stapel stapelAnz streitArt patArt demoAktiv exist

      initVorschlaege
      set dieseRundeLebt 1
      set demoAktiv      1
      menueHilfe [expr {$streitArt($patArt) ? "streit" : "demo"}]
      aktiviereBindings "set demoAktiv $streitArt($patArt)"
      aktiviereGeben hand ein

      # Nun beschaeftigen wir uns solange alleine, bis die Benutzerin andeutet,
      # dass ihr die Demo langweilig ist, oder wir in einer Streitpatience
      # nicht mehr weiter duerfen.
      while {$demoAktiv} {
        set gezogen [vorschlag 1]

        # Eine Denkpause ist unumgaenglich, damit die Spielerin mit ihren
        # Tastendruecken ueberhaupt durchkommt.
        update; kurzePause
        if {!$demoAktiv} break

        set gewonnen [expr {$streitArt($patArt) && [checkSpielEnde 1]}]
        if {$gewonnen} {
          set gezogen 0
          aktiviereGeben hand aus
        }

        if {$gezogen} {
          set dieseRundeLebt 1
          for {set aktStap 0} {$aktStap < $stapelAnz($patArt)} {incr aktStap} {
            set oben [expr $fuelle($aktStap)-1]
            if {$oben < 0} continue
            if {$oben < $verdeckt($aktStap)} {
              drehUm $stapel($aktStap,$oben) $aktStap
              initVorschlaege
              update
            }
          }
        } elseif {$streitArt($patArt)} {
          if {![istGebenAktiv]} {
            set demoAktiv 0
            global flaeche aktiverSpieler text talonAbraeumbar patArt stapel \
                   fuelle verdeckt roteFarbe

            set aktiverSpieler $text(mensch)
            $flaeche.schachUhr configure -state normal
            $flaeche itemconfigure links  -fill $roteFarbe
            $flaeche itemconfigure rechts -fill ""
            aktiviereGeben hand2 ein
            foreach sonderStapel {talon strafe} {
              if {[info exists fuelle($sonderStapel)] && $fuelle($sonderStapel) > 0} {
                nichtVerschiebbar $stapel($sonderStapel,[expr {$fuelle($sonderStapel)-1}])
              }
            }

            if {!$talonAbraeumbar($patArt)} {
              foreach talon {talon talon2} {
                if {[info exists fuelle($talon)] && $fuelle($talon) > 0} {
                  set verdeckt($talon) $fuelle($talon)
                  nichtVerschiebbar $stapel($talon,[expr {$fuelle($talon)-1}])
                }
              }
            }
          }
        } else {
          initVorschlaege
          if {$fuelle(hand) > 0} {
            if {[geben hand]} {set dieseRundeLebt 1}
          } elseif {$exist($patArt,talon) && $fuelle(talon) > 0 && $dieseRundeLebt} {
            set dieseRundeLebt [handNachTalon hand talon 1]
          } else {
            starteSpiel 0
          }
        }
      }
      menueHilfe aus
      aktiviereBindings
    }
    proc vorschlag {mitSchieben} {
        global flaeche vorschlagZaehler vorschlaege zugNr \
               vorschlaegeAnzeigen vorschlagsReihe patArt nurZustand

        if {[info exists vorschlagsReihe($zugNr,priori)]} {
          set vorschlaege(zugNr)  $zugNr
          set vorschlaege(anzahl) 1
          set vorschlaege(index)  0
          foreach elem {priori prioriExpr pfeil schieb} {
            set vorschlaege(0,$elem) $vorschlagsReihe($zugNr,$elem)
          }
        } elseif {[info exists vorschlaege] && $vorschlaege(zugNr) == $zugNr
                  && $vorschlaege(anzahl) > 0} {
          if {$mitSchieben || [incr vorschlaege(index)] >= $vorschlaege(anzahl)} {
            # Wir sind einmal rum, und fangen wieder vorne an.
            set vorschlaege(index) 0      
          }
          $flaeche delete pfeil
        } else {
          berechneVorschlaege $mitSchieben
        }
        if {[info exists vorschlaegeAnzeigen]} {
          set result "Vorschlaege($vorschlaege(zugNr)):\n"
          for {set aktV 0} {$aktV < $vorschlaege(anzahl)} {incr aktV} {
            append result [format "%3d: (%3d) %s <%s>\n" $aktV       \
                $vorschlaege($aktV,priori) $vorschlaege($aktV,pfeil) \
                $vorschlaege($aktV,prioriExpr)]
          }

          if {![winfo exist .vorschlaege]} {
            toplevel .vorschlaege
            text .vorschlaege.text -relief raised -bd 2 -width 40 -height 10 \
                -font -Adobe-times-medium-r-normal--*-140*
            pack .vorschlaege.text
          } else {
            .vorschlaege.text configure -state normal
            .vorschlaege.text delete 1.0 end
          }
          .vorschlaege.text insert 1.0 $result
          .vorschlaege.text configure -state disabled
        }
        incr vorschlagZaehler
        if {$vorschlaege(anzahl) == 0} {
          if {!$mitSchieben} {
            bell
          }
          return 0
        } else {
          global vorschlagFertig pfeilFertig aktPfeil

          if {$mitSchieben} {
            set aktSchieb $vorschlaege($vorschlaege(index),schieb)
            set aktPfeil  $vorschlaege($vorschlaege(index),pfeil)

            if {![info exist vorschlagsReihe([expr {$zugNr+1}],priori)]} {
              set nurZustand 1

              eval $aktSchieb
              set vorschlagFertig 0
              set pfeilFertig     0
              after 1 {
                eval $aktPfeil 1
                set pfeilFertig 1
              }
              after 1 {
                berechneVorschlaege 1
                set vorschlagFertig 1
              }
              if {!$vorschlagFertig} {
                tkwait variable vorschlagFertig
              }
              if {!$pfeilFertig} {
                tkwait variable pfeilFertig
              }
              while {[info exists vorschlaegeAnzeigen] && $vorschlaegeAnzeigen > 1} {
                tkwait variable vorschlaegeAnzeigen
              }
              zurueckZumZug [expr {$zugNr-1}]
              unset nurZustand
            } else {
              eval $aktPfeil 1
            }
            eval $aktSchieb
          } else {
            eval $vorschlaege($vorschlaege(index),pfeil) 0
          }
          return 1
        }
      }
    proc berechneVorschlaege {mitSchieben} {
      global flaeche vorschlagZaehler vorschlaege zugNr streitArt \
             vorschlaegeAnzeigen vorschlagsReihe stapelAnz patArt \
             stapel fuelle verdeckt teilStapelUnterst exist       \
             prioritaet teilStapelReihe leerStapelFeld            \
             talonAbraeumbar nurZustand teilY stockReihe

      initVorschlaege $zugNr
        if {![string match *,kompl $stockReihe($patArt)]} {
            foreach sonderStapel {strafe talon} {
              if {$exist($patArt,$sonderStapel) > 0
                  && $fuelle($sonderStapel) > $verdeckt($sonderStapel)} {
                set oben [expr $fuelle($sonderStapel)-1]
                set karte $stapel($sonderStapel,$oben)
                set neuStock [kannAufStock $karte]
                if {$neuStock != ""} {
                  vorschlagAufStock $sonderStapel $sonderStapel $oben $karte \
                                    $neuStock [stockBonus $karte]
                }
              }
            }
          }
        set leerStapelFeld {}
        if {$teilStapelReihe($patArt) != "garNicht"} {
          set maxTeilStapelAnz 13
          for {set aktStapel 0} {$aktStapel<$stapelAnz($patArt)} {incr aktStapel} {
            set teilY($aktStapel) $teilStapelUnterst($aktStapel)
          }
        } else {
          set maxTeilStapelAnz 1
          for {set suchStap 0} {$suchStap < $stapelAnz($patArt)} {incr suchStap} {
            if {$fuelle($suchStap) == 0} {
              lappend leerStapelFeld $suchStap
              incr maxTeilStapelAnz $maxTeilStapelAnz
            }
          }
          for {set aktStapel 0} {$aktStapel<$stapelAnz($patArt)} {incr aktStapel} {
            set aktY [expr {$fuelle($aktStapel)-1}]
            while {$aktY > $verdeckt($aktStapel)
                   && [passt $stapel($aktStapel,$aktY) \
                             $stapel($aktStapel,[expr {$aktY-1}]) $aktStapel]} {
              incr aktY -1
            }
            set teilY($aktStapel) $aktY
          }
        }
        for {set aktStapel 0} {$aktStapel<$stapelAnz($patArt)} {incr aktStapel} {
          set oben [expr $fuelle($aktStapel)-1]
          if {[string match *,kompl $stockReihe($patArt)]} {
            set oben [expr {$oben-13}]
          }
          if {$oben >= 0 && $oben >= $verdeckt($aktStapel)
              && $oben >= $teilStapelUnterst($aktStapel)} {
            # Es liegt mindestens eine Karte auf dem Stapel.
            set aktKarte $stapel($aktStapel,$oben)
            set neuStock [kannAufStock $aktKarte]
            if {$neuStock != ""} {
              vorschlagAufStock $aktStapel stapel $oben $aktKarte \
                                $neuStock [stockBonus $aktKarte]
            }
            switch -glob $aktKarte {
              ?c? {set andereFarbe h}
              ?h? {set andereFarbe c}
              ?p? {set andereFarbe k}
              ?k? {set andereFarbe p}
            }
            set andereKarte [string index $aktKarte 0]$andereFarbe
            set neuStock [kannAufStock ${andereKarte}0]
            if {$neuStock != ""} {
              for {set neuStapel 0} {$neuStapel<$stapelAnz($patArt)} {incr neuStapel} {
                if {$neuStapel == $aktStapel} continue
                for {set aktY [expr $fuelle($neuStapel)-2]} \
                    {$aktY >= $fuelle($neuStapel)-$maxTeilStapelAnz-1 &&
                     $aktY >= $teilY($neuStapel)} {incr aktY -1} {
                  set verglKarte [string range $stapel($neuStapel,$aktY) 0 1]
                  if {$andereKarte == $verglKarte} {
                    vorschlagSchieb [expr {$fuelle($neuStapel)-($aktY+1)}]    \
                                    $neuStapel stapel [expr {$aktY+1}]    \
                                    $aktStapel stapel $fuelle($aktStapel) \
                                    $prioritaet(andereFarbePasst)+[stockBonus $andereKarte]
                  }
                }
              }
            }
          }
        }
        if {!$talonAbraeumbar($patArt) && [istGebenAktiv]} {
          vorschlagSchieb 1 hand  talon [expr {$fuelle(hand)-1}] \
                            talon talon $fuelle(talon) 1000
        }
        if {!$mitSchieben || $vorschlaege(anzahl) == 0} {
          if {$streitArt($patArt)} {
            foreach ziel {strafe talon} {
              if {!$exist($patArt,$ziel)} continue
              set zielStapel ${ziel}2
              set zielOben [expr {$fuelle($zielStapel) - 1}]
              if {$zielOben >= 0} {
                set zielKarte $stapel($zielStapel,$zielOben)
                for {set aktStapel 0} {$aktStapel<$stapelAnz($patArt)} {incr aktStapel} {
                  set oben [expr {$fuelle($aktStapel)-1}]
                  if {$oben >= 0 && $oben >= $verdeckt($aktStapel)
                      && [passt $stapel($aktStapel,$oben) $zielKarte $zielStapel]} {
                    vorschlagSchieb 1 $aktStapel stapel $oben \
                                      $zielStapel $ziel $fuelle($zielStapel) \
                                      [stapelBonus $aktStapel $oben]
                  }
                }
                foreach aktStapel {strafe talon} {
                  if {!$exist($patArt,$aktStapel)} continue
                  set oben [expr {$fuelle($aktStapel)-1}]
                  if {$oben >= 0
                      && [passt $stapel($aktStapel,$oben) $zielKarte $zielStapel]} {
                    vorschlagSchieb 1 $aktStapel $aktStapel $oben \
                                      $zielStapel $ziel $fuelle($zielStapel) \
                                      [stapelBonus $aktStapel $oben]
                  }
                }
              }
            }
          }
          foreach sonderStapel {strafe talon} {
            if {$exist($patArt,$sonderStapel)>0 && $fuelle($sonderStapel)>0} {
              set oben [expr $fuelle($sonderStapel)-1]
              set karte $stapel($sonderStapel,$oben)
              set neuStapel 0
              while {42} {
                wohinBewegbar $karte neuStapel ziel
                if {$neuStapel < 0} break
                vorschlagSchieb 1 $sonderStapel $sonderStapel $oben \
                                  $neuStapel $ziel $fuelle($neuStapel) 0
                incr neuStapel
              }
            }
          }
          for {set aktStapel 0} {$aktStapel < $stapelAnz($patArt)} {incr aktStapel} {
            set oben  $teilY($aktStapel)
            if {$oben < $fuelle($aktStapel) && $oben >= $verdeckt($aktStapel)} {
              set neuStapel 0
              while {42} {
                wohinBewegbar $stapel($aktStapel,$oben) neuStapel ziel
                if {$neuStapel < 0} break

                if {$fuelle($aktStapel)-$oben <= $maxTeilStapelAnz} {
                  if {$oben == 0} {
                    set quelle leerStapel
                  } elseif {$oben == $verdeckt($aktStapel)
                            || ![passt $stapel($aktStapel,$oben)            \
                                       $stapel($aktStapel,[expr {$oben-1}]) \
                                       $aktStapel]} {
                    set quelle stapel
                  } else {
                    set quelle fixStapel
                  }
                  vorschlagSchieb [expr {$fuelle($aktStapel)-$oben}]   \
                                  $aktStapel $quelle $oben                     \
                                  $neuStapel $ziel $fuelle($neuStapel) \
                                  [stapelBonus $aktStapel $oben]
                }
                incr neuStapel
              }
            }
          } 
        }
    }
    proc initVorschlaege {{neuZugNr -1}} {
      global vorschlaege prioritaet vorschlagsReihe nurZustand zugNr

      if {[info exists vorschlaege] && $neuZugNr >= 0
          && $vorschlaege(zugNr) > $zugNr} return

      catch {unset vorschlaege}
      set vorschlaege(zugNr)  $neuZugNr
      set vorschlaege(anzahl) 0
      set vorschlaege(index)  0

      if {$neuZugNr >= 0} {catch {unset vorschlagsReihe}}

      if {![info exists prioritaet]} {
        set prioritaet(lohntNicht)         -1200

        set prioritaet(strafe,stock)         100
        set prioritaet(strafe,strafe)         95
        set prioritaet(strafe,talon)          85
        set prioritaet(strafe,stapel)         75
        set prioritaet(strafe,fixStapel)      73
        set prioritaet(strafe,leerStapel)     45
        set prioritaet(stapel,stock)          80
        set prioritaet(stapel,strafe)         75
        set prioritaet(stapel,talon)          65
        set prioritaet(stapel,stapel)         55
        set prioritaet(stapel,fixStapel)      30
        set prioritaet(stapel,leerStapel)     10
        set prioritaet(fixStapel,stapel)      52
        set prioritaet(fixStapel,fixStapel)   $prioritaet(lohntNicht)
        set prioritaet(fixStapel,leerStapel)   7
        set prioritaet(leerStapel,stapel)     55
        set prioritaet(leerStapel,fixStapel)  30
        set prioritaet(leerStapel,leerStapel) $prioritaet(lohntNicht)
        set prioritaet(talon,strafe)          90
        set prioritaet(talon,talon)           80
        set prioritaet(talon,stock)           75
        set prioritaet(talon,stapel)          10
        set prioritaet(talon,fixStapel)        8
        set prioritaet(talon,leerStapel)       5

        set prioritaet(verdeckteWirdFrei)     12
        set prioritaet(stapelWirdFrei)        25
        set prioritaet(grundBonus)            20
        set prioritaet(karteAufStock)         11
        set prioritaet(teilStapelBewegbar)     7
        set prioritaet(stapelGranularitaet)    5
        set prioritaet(andereFarbePasst)     -20
        set prioritaet(stapelNurHoch)        -13
      }
    }
    proc vorschlagDebug {key} {
      global vorschlaegeAnzeigen demoAktiv

      switch $key {
        x - q {set vorschlaegeAnzeigen 1}
        s     {set vorschlaegeAnzeigen 2}
      }
      set demoAktiv 1
    }
    proc wertDiff {wertA wertB} {
      global aktuellerGrenzWert

      if {$wertA < $aktuellerGrenzWert && $wertB > $aktuellerGrenzWert} {
        incr wertA 13
      }
      return [expr $wertA-$wertB]
    }
    proc vorschlagAufStock {quelle quellKlasse vonY karte ziel bonus} {
      global prioritaet

      setzVorschlag $prioritaet($quellKlasse,stock)+$bonus \
          "pfeil $quelle $vonY $ziel 0" "karteAufStock $karte $quelle 1 1"
    }
    proc vorschlagSchieb {kartenAnz quelle quellKlasse quellY \
                                    ziel zielKlasse zielY bonus} {
      global prioritaet teilStapelReihe patArt leerStapelFeld

      if {$teilStapelReihe($patArt) == "garNicht" && $kartenAnz > 1} {
        set pfeilQuellY [expr {$quellY+$kartenAnz-1}]
        set pfeilZielY  0
        set pfeilZiel   [lindex $leerStapelFeld 0]
      } else {
        set pfeilQuellY $quellY
        set pfeilZielY  [expr {$zielY>0 ? $zielY-1 : 0}]
        set pfeilZiel   $ziel
      }
      setzVorschlag $prioritaet($quellKlasse,$zielKlasse)+$bonus \
            "pfeil $quelle $pfeilQuellY $pfeilZiel $pfeilZielY" \
            "schiebStapel $quelle $quellY $ziel $zielY [list $leerStapelFeld]"
    }
    proc wohinBewegbar {orgKarte startStapel zielKlasse} {
      upvar $startStapel aktStapel $zielKlasse ziel
      global stapel fuelle verdeckt stapelAnz patArt \
          leerStapelNurHoch aktuellErste

      set moeglicherLeerStapel -1

      while {$aktStapel < $stapelAnz($patArt)} {
        set aktY [expr $fuelle($aktStapel)-1]

        if {$aktY < 0 && ($leerStapelNurHoch($patArt) == 0 \
            || [aufsteigend $orgKarte $aktuellErste 1])} {
          set ziel leerStapel
          set moeglicherLeerStapel $aktStapel
        }

        if {$aktY >= $verdeckt($aktStapel)} {
          if {[passt $orgKarte $stapel($aktStapel,$aktY) teil]} {
            set ziel stapel
            return
          }
          if {[passt $orgKarte $stapel($aktStapel,$aktY) $aktStapel]} {
            set ziel fixStapel
            return
          }
        }
        incr aktStapel
      }
      set aktStapel $moeglicherLeerStapel
    }
    proc schiebStapel {vonStapel vonY neuStapel nachY leerStapelFeld} {
      global stapel fuelle zugNr teilStapelReihe patArt vorschlagsReihe nurZustand

      set altFuelle $fuelle($vonStapel)
      set neuUnten  $fuelle($neuStapel)
      set kartenAnz [expr {$altFuelle-$vonY}]
      set art       [expr {$kartenAnz > 1 ? "minusStapel" : "minusEins"}]
      set auchBild  [expr {![info exists nurZustand]}]

      if {$teilStapelReihe($patArt) == "garNicht" && $kartenAnz>1 && $auchBild} {
        set zugZaehler $zugNr
        hanoi $vonStapel $neuStapel $leerStapelFeld $vonY $nachY \
                                    $kartenAnz zugZaehler

        eval $vorschlagsReihe($zugNr,schieb)
        return
      }

      switch -glob $vonStapel hand* {
        if {$vonY < 0 && $auchBild} {
          handNachTalon $vonStapel $neuStapel 1
        }
        return [handNachTalon $vonStapel $neuStapel 1]
      }

      if {$auchBild} {
        schiebTeilstapel $vonStapel $vonY $neuStapel
      }
      incr fuelle($vonStapel) -$kartenAnz
      for {set aktY $vonY} {$aktY < $altFuelle} {incr aktY} {
        set aktKarte $stapel($vonStapel,$aktY)
        steckInStapel $neuStapel $aktKarte plusEinsGueltig
      }
      pruefFreieKarte $vonStapel $art

      incr zugNr
      if {$kartenAnz > 1} {
        setzInversZug "zurueckStapel $vonStapel $neuUnten $neuStapel"
      } elseif {$kartenAnz == 1} {
        setzInversZug "zurueckKarte $aktKarte $vonStapel $neuStapel 1"
      }
    }
    proc stapelBonus {aktStapel untenY} {
      global stapel verdeckt prioritaet aktuellerGrenzWert aktuellErste\
          leerStapelNurHoch patArt exist stapelAnz teilY fuelle

      set aufSockel [expr {$untenY > $verdeckt($aktStapel)}]
      
      set wertUnten [kartenWert $stapel($aktStapel,$untenY)]
      if {$aufSockel} {
        set wertOben [kartenWert $stapel($aktStapel,[expr {$untenY-1}])]
        set bonus [wertDiff $wertUnten $wertOben]
      } else {
        switch $untenY {
          0 {
            if {$leerStapelNurHoch($patArt)} {
              set anzHoch 0
              set anzLeer 0
              for {set such 0} {$such < $stapelAnz($patArt)} {incr such} {
                if {$such == $aktStapel || $fuelle($such) == 0} {
                  incr anzLeer
                } else {
                  set hochY $teilY($such)
                  if {$hochY > 0 &&
                      [aufsteigend $stapel($such,$hochY) $aktuellErste 1]} {
                    incr anzHoch
                  }
                }
              }
              foreach sonder {talon strafe} {
                if {$exist($patArt,$sonder) > 0} {
                  set hochY [expr {$fuelle($sonder)-1}]
                  if {$hochY >= 0 && 
                      [aufsteigend $stapel($sonder,$hochY) $aktuellErste 1]} {
                    incr anzHoch
                  }
                }
              }
              if {$anzHoch < $anzLeer} {return $prioritaet(lohntNicht)}
            }
            set bonus $prioritaet(stapelWirdFrei)
          }
          1 {
            set bonus ($prioritaet(verdeckteWirdFrei)+$wertUnten)
          }
          default {
            set bonus $wertUnten
          }
        }
      }
      if {$aufSockel &&
          [kannAufStock $stapel($aktStapel,[expr {$untenY-1}])] != ""} {
        append bonus +$prioritaet(karteAufStock)
      }
      if {$aufSockel} {
        set aktUnten [expr {$untenY-1}]
        while {$aktUnten > $verdeckt($aktStapel) && \
               [passt $stapel($aktStapel,$aktUnten) \
                      $stapel($aktStapel,[expr {$aktUnten-1}]) teil]} {
          incr aktUnten -1
        }
        set neuStapel 0
        wohinBewegbar $stapel($aktStapel,$aktUnten) neuStapel ziel
        if {$neuStapel >= 0 && $ziel == "stapel"} {
          # Der naechste Teilstapel kann auf einen anderen verschoben werden!
          append bonus +$prioritaet(teilStapelBewegbar)
        }
      }
      if {$aufSockel && $verdeckt($aktStapel) == 0} {
        set nurHoch 1
        for {set aktY 0} {$aktY <= $untenY && $nurHoch} {incr aktY} {
          set nurHoch [expr {[wertDiff [kartenWert $stapel($aktStapel,$aktY)] \
                                        $aktuellerGrenzWert] >= 10}]
        }
        if {$nurHoch} {
          append bonus $prioritaet(stapelNurHoch)
        }
      }
      if {$aufSockel} {
        set teilAnzahl 0
        for {set letztY $untenY} {$letztY > $verdeckt($aktStapel)} \
            {incr letztY -1} {
          set aktY [expr {$letztY-1}]
          if {![passt $stapel($aktStapel,$letztY) $stapel($aktStapel,$aktY) teil]} {
            incr teilAnzahl
          }
        }
        # Verdeckte Karten zaehlen als je ein Teilstapel.
        incr teilAnzahl $verdeckt($aktStapel)
        # Da es sowieso nur auf die Unterscheidung "1,2,3,viele" ankommt,
        # wird das jetzt hier auch so gesetzt...
        if {$teilAnzahl > 3} {set teilAnzahl 3}

        append bonus -($teilAnzahl*$prioritaet(stapelGranularitaet))
      }  
      return $bonus
    }
    proc stockBonus {karte} {
      global aktuellerGrenzWert

      return (12-[wertDiff [kartenWert $karte] $aktuellerGrenzWert])
    }
    proc hanoi {start ziel leerStapelFeld vonY nachY kartenAnz zugZaehler} {
      upvar $zugZaehler zug

      if {$kartenAnz == 1} {
        setzVorschlagsReihe $start $vonY 1 $ziel [expr {$nachY-1}] zug
      } elseif {$kartenAnz > 1} {
        set grundAnz [expr {1<<([llength $leerStapelFeld]-1)}]
        if {$grundAnz >= $kartenAnz} {set grundAnz [expr {$kartenAnz - 1}]}
        set tempAnz [expr {$kartenAnz-$grundAnz}]
        set tempY   [expr {$vonY+$grundAnz}]

        set leerIndex [expr {$tempAnz == 1 ? 0 : [llength $leerStapelFeld]-1}]
        set erstLeer  [lindex   $leerStapelFeld $leerIndex]
        set restLeer  [lreplace $leerStapelFeld $leerIndex $leerIndex]

        hanoi $start $erstLeer $restLeer $tempY 0 $tempAnz zug
        hanoi $start $ziel $restLeer $vonY $nachY $grundAnz zug
        if {$vonY == 0} {lappend restLeer $start}
        hanoi $erstLeer $ziel $restLeer 0 [expr {$nachY+$grundAnz}] $tempAnz zug
      }
    }
    proc setzVorschlagsReihe {start aktY anz ziel zielY zugZaehler} {
      global vorschlagsReihe
      upvar $zugZaehler zug

      set vorschlagsReihe($zug,priori)     666
      set vorschlagsReihe($zug,prioriExpr) hanoi
      set vorschlagsReihe($zug,pfeil)      "pfeil $start $aktY $ziel $zielY"
      set vorschlagsReihe($zug,schieb)     "schiebStapel $start $aktY $ziel $zielY {}"
      incr zug
    }
    proc setzVorschlag {prioritaetExpr pfeilScript schiebScript} {
      global vorschlaege
      
      set prioritaet [expr $prioritaetExpr]
      if {$prioritaet < -1000} return

      set aktI $vorschlaege(anzahl)
      while {$aktI > 0 && $vorschlaege([expr $aktI-1],priori) < $prioritaet} {
        set letztI $aktI
        incr aktI -1
        foreach elem {priori prioriExpr pfeil schieb} {
          set vorschlaege($letztI,$elem) $vorschlaege($aktI,$elem)
        }
      }
      set  vorschlaege($aktI,priori)     $prioritaet
      set  vorschlaege($aktI,prioriExpr) $prioritaetExpr
      set  vorschlaege($aktI,pfeil)      $pfeilScript
      set  vorschlaege($aktI,schieb)     $schiebScript
      incr vorschlaege(anzahl)
    }
    proc zurueckGeben {hand} {
        global zugNr stapelAnz patArt stapel fuelle verdeckt \
               bitPath flaeche nurZustand mitMischComic weisseFarbe

        set auchBild [expr {![info exists nurZustand]}]
        set letztStapel [expr $stapelAnz($patArt)-1]
        for {set aktStapel $letztStapel} {$aktStapel >= 0} {incr aktStapel -1} {
          set oben [expr $fuelle($aktStapel)-1]

          # Nach dem anfaenglichen Verteilen kann evtl. keine Karte vom
          # aktuellen Stapel genommen werden.
          if {$oben < 0} {continue}

          set karte $stapel($aktStapel,$oben)
          set stapel($hand,$fuelle($hand)) $karte

          # Nun, wo die Karte verteilt wurde, auf die Anzahl der Hand dazuzaehlen...
          # Das sollte besser schon vorm Comic passieren, da dann die Anzeige
          # der Kartenanzahl plausibler ist.
          if {!$fuelle($hand) && $auchBild} {
            $flaeche itemconf $hand -bitmap @$bitPath/ruecken \
                                    -background $weisseFarbe
          }
          incr fuelle($hand)
          # ... und beim aktuellen Stapel abziehen.
          incr fuelle($aktStapel) -1

          # Den verbliebenen Stapel durchchecken und schauen, ob er expandiert
          # werden kann.
          pruefFreieKarte $aktStapel "minusEins"

          if {$auchBild} {
            # Wegschmeissen der betreffenden Spielkarte.
            $flaeche delete $karte
            if {$mitMischComic} {
              verteilComic $aktStapel $fuelle($aktStapel) $hand 0
            }
            update idletask
          }
        }
        incr zugNr -1
      }
      proc zurueckHandNachTalon {hand talon anzahl} {
        global zugNr stapel fuelle bitPath flaeche nurZustand weisseFarbe

        set auchBild [expr {![info exists nurZustand]}]
        if {$fuelle($talon) == 0} {
          # Falls auf die leere Hand geklickt wurde, aber sich noch Karten auf dem
          # Talon befanden, wurden die Talon-Karten wieder auf die Hand genommen.
          while {$fuelle($hand) > 0} {
            karteVonHandNach $hand $talon
          }
          if {$auchBild} {
            verteilComic $hand 0 $talon 0
          }
        } else {
          for {set aktI 0} {$aktI < $anzahl} {incr aktI} {
            incr fuelle($talon) -1
            set karte $stapel($talon,$fuelle($talon))
            if {$auchBild} {
              $flaeche delete $karte
            }
            set stapel($hand,$fuelle($hand)) $karte

            if {!$fuelle($hand) && $auchBild} {
              $flaeche itemconf $hand -bitmap @$bitPath/ruecken \
                                      -background $weisseFarbe
            }
            incr fuelle($hand)
          }
          if {$auchBild} {
            verteilComic $talon 0 $hand 0
          }
        }
        if {$auchBild} {update idletask}

        incr zugNr -1
      }
      proc zurueckDrehUm {karte aktStapel} {
        global verdeckt teilStapelUnterst nurZustand

        incr verdeckt($aktStapel)
        incr teilStapelUnterst($aktStapel)

        if {![info exists nurZustand]} {
          maleRuecken $karte $aktStapel
          umdrehbar $karte $aktStapel
        }
      }
      proc zurueckKarte {karte neuStapel altStapel incrZugNr} {
        global stapel fuelle zugNr verdeckt nurZustand

        set auchBild [expr {![info exists nurZustand]}]
        incr fuelle($altStapel) -1
        if {[string match ? $altStapel]} {
          # Die Karte kommt von einem Stapel, also die Stapelfuelle vermindern.
          # und ueberpruefen, ob der Stapel expandiert werden kann.
          pruefFreieKarte $altStapel minusEins
        }

        if {$auchBild} {
          karteWeg $karte
          verteilComic $altStapel $fuelle($altStapel) $neuStapel $fuelle($neuStapel)
        }
        if [string match ?,? $neuStapel] {
          steckInStock  $neuStapel $karte 1
        } else {
          # Das Folgende wird am Ende von 'zurueckDrehUm' motiviert...
          if {$auchBild && [string match ? $neuStapel] && $fuelle($neuStapel) > 0
                        && $fuelle($neuStapel) == $verdeckt($neuStapel)} {
            nichtVerschiebbar $stapel($neuStapel,[expr {$fuelle($neuStapel)-1}])
          }

          steckInStapel $neuStapel $karte plusEins
        }
        if {$incrZugNr} {incr zugNr -1}
      }
      proc zurueckStapel {neuStapel altTeilStapelNr altStapel} {
        global stapel fuelle zugNr flaeche verdeckt nurZustand

        set auchBild [expr {![info exists nurZustand]}]

        # Das Folgende wird am Ende von 'zurueckDrehUm' motiviert. Im Gegensatz zu
        # 'zurueckKarte' wissen wir hier, dass die Karten auf einen Stapel kommen.
        if {$auchBild && $fuelle($neuStapel) > 0
            && $fuelle($neuStapel) == $verdeckt($neuStapel)} {
          nichtVerschiebbar $stapel($neuStapel,[expr {$fuelle($neuStapel)-1}])
        }

        set lastI $fuelle($altStapel)
        set neuX [stapelX $neuStapel]
        if {$auchBild} {
          schiebTeilstapel $altStapel $altTeilStapelNr $neuStapel
        }
        for {set aktI $altTeilStapelNr} {$aktI < $lastI} {incr aktI} {
          set bewKarte $stapel($altStapel,$aktI)
          set stapel($neuStapel,$fuelle($neuStapel)) $bewKarte
          if {$auchBild} {
            $flaeche coords $bewKarte $neuX [stapelY $neuStapel $fuelle($neuStapel)]
            $flaeche raise  $bewKarte
          }
          incr fuelle($altStapel) -1
          incr fuelle($neuStapel)
        }
        pruefFreieKarte $altStapel minusStapel
        pruefFreieKarte $neuStapel plusStapel

        incr zugNr -1
      }
      proc zugZurueck {} {
        global zugNr

        if {$zugNr > 0} {zurueckZumZug [expr $zugNr-1]}
      }

      proc zumAnfang {} {
        global zugNr

        if {$zugNr > 0} {zurueckZumZug 0}
      }

      proc merken {} {
        global gemerkt marke zugNr

        set marke $zugNr
        set gemerkt 1
        # Die folgende Zuweisung ist ein indirekter Aufruf von chkZugNr.
        set zugNr $zugNr
      }

      proc zurMarke {} {
        global gemerkt marke zugNr

        if {$marke > 0} {zurueckZumZug $marke}
        if {$marke == $zugNr} {
          # Die Benutzerin hat die Funktion nicht bereits vorher abgebrochen.
          set gemerkt 0
          set marke   0
        }
      }
      proc setzInversZug {aktInversZug} {
        global inversZug

        lappend inversZug $aktInversZug
      }
    proc zurueckZumZug {zielZugNr} {
      global zugNr inversZug demoAktiv nurZustand

      # Kann denn ueberhaupt gerade ein Zug rueckgaengig gemacht werden?
      if {![info exists inversZug] || [llength $inversZug] == 0} {return}

      set auchBild [expr {![info exists nurZustand]}]
      # Ab zwei zurueckzunehmenden Zuegen darf die Benutzerin jederzeit abbrechen.
      set langfristig [expr {$zugNr-$zielZugNr > 1 && $auchBild}]
      if {$langfristig} {
        aktiviereBindings "set demoAktiv 0"
        menueHilfe zurueck
        set demoAktiv 1
      }
      if {$auchBild} {initVorschlaege}
        
      while {$zugNr > $zielZugNr && (!$langfristig || $demoAktiv)} {
        # Das letzte Element aus inversZug ausfuehren und wegschmeissen.
        set letztIndex [expr {[llength $inversZug]-1}]
        eval  [lindex $inversZug $letztIndex]
        set inversZug [lreplace $inversZug $letztIndex $letztIndex]
        if {$langfristig} {
          kurzePause
        }
      }

      if {$langfristig} {
        aktiviereBindings
        menueHilfe aus
      }
    }
    proc regelEdit {{neuAufbau 0}} {
        global regelEditAltPat regelEditBackPat editArt patArt \
                zustSicherungStatus stapelReihe stockReihe strafReihe \
                stockBasis stapelAnz zugNr text

        set w .regelEditor

        if {[winfo exists $w] && !$neuAufbau} {
          # Nanu, es gibt bereits ein Fenster regelEditor!
          # Falls minimiert, vergroessern, und tschuess...
          if {[wm state $w] == "iconic"} {wm deiconify $w}
          raise $w
          return
        }

        if {$neuAufbau} {
          if {![winfo exists $w]} return
          destroy $w.kopf $w.buttons1 $w.buttons2
        } else {
          set regelEditAltPat  $patArt
          set regelEditBackPat "back[pid]"
          kopiereRegeln $regelEditBackPat $regelEditAltPat

          # Die aktuelle Patienceart auf Test setzen, damit der Benutzer so richtig
          # rumprobieren kann, ohne dass es sofort Auswirkungen auf das Spiel hat.
          set editArt ":$patArt"
          kopiereRegeln $editArt $regelEditAltPat

          toplevel    $w
          wm title    $w $text(regelEditor)
          wm iconname $w $text(regelEditor)
        }
        regelnAnzeigen $w 1

        frame $w.buttons1 -relief raised -bd 1
        pack $w.buttons1 -fill both

        button $w.buttons1.neu   -text $text(neu)       -command "regelNeu $w"
        button $w.buttons1.laden -text $text(laden)     -command "regelLaden $w"
        button $w.buttons1.save  -text $text(speichern) -command "regelSichern"
        pack $w.buttons1.neu $w.buttons1.laden $w.buttons1.save \
              -side left -expand 1 -padx 5m -pady 2m

        frame $w.buttons2 -relief raised -bd 1
        pack $w.buttons2 -fill both

        set zustandDateiName "/tmp/ZUST_[pid]"

        button $w.buttons2.quit -text $text(abbruch)   \
              -command "regelAbbruch $w $zustandDateiName"
        button $w.buttons2.anw  -text $text(anwenden)  \
              -command "regelnAnwenden $zustandDateiName"
        pack $w.buttons2.quit $w.buttons2.anw \
              -side left -expand 1 -padx 5m -pady 2m

        button $w.buttons2.ok -text $text(okay) \
              -command "regelOkay $w $zustandDateiName"
        frame $w.buttons2.default -relief sunken -bd 1
        raise $w.buttons2.ok $w.buttons2.default
        pack $w.buttons2.default -side left -expand 1 -padx 5m -pady 2m
        pack $w.buttons2.ok -in $w.buttons2.default -side left \
                -padx 3m -pady 3m -ipadx 2m -pady 1m

        set zustSicherungStatus [expr {$zugNr > 0 ? "IstNoetig" : "NichtNoetig"}]

        # Zum bequemen Bestaetigen des Okay-Buttons.
        bind  $w <Enter> "focus $w.kopf.name.feld"
        bind  $w.kopf.name.feld <Return> "$w.buttons2.ok flash; $w.buttons2.ok invoke"
      }
      proc interneRegelNamen {} {
        global stapelAnz

        set regelList {}
        foreach el [array names stapelAnz] {
          if {![regexp ^(back|:) $el]} {
            lappend regelList $el
          }
        }
        return $regelList
      }
            # Es ist kein von uns selbst intern genutzter Regelname.
    proc regelnAnzeigen {w neu} {
      global editArt stapelAnz kartenSatz streitArt text patiencePath \
             patName sprache untereOffen stapelGrund stapelVerdeckt

      if {$neu} {
        frame $w.kopf -relief raised -bd 1
      }

      if {$neu} {
        frame $w.kopf.patArt -relief raised -bd 1
        label $w.kopf.patArt.fest -text $text(nameIntern)
        label $w.kopf.patArt.feld
        pack  $w.kopf.patArt.fest $w.kopf.patArt.feld -side left
      }
      $w.kopf.patArt.feld configure -text [string range $editArt 1 end]
      set exNameMenue $w.kopf.name.feld.externName
      if {$neu} {
        frame $w.kopf.name -relief raised -bd 1
        label $w.kopf.name.fest -text $text(nameExtern)
        button $w.kopf.name.feld -relief flat \
              -command "editPatNames $w.kopf.name.feld"
        pack  $w.kopf.name.fest $w.kopf.name.feld -side left
      }
      $w.kopf.name.feld configure -text $patName($editArt,$sprache)
      editAuswahl $w.kopf.kartenSatz $neu $text(kartensatz) kartenSatz($editArt) \
              [list $text(einSatz)    1] \
              [list $text(zweiSaetze) 2]
      editAuswahl $w.kopf.streitArt $neu $text(streitArt) streitArt($editArt) \
              [list $text(nein)        0] \
              [list $text(jaGemeinsam) 1] \
              [list $text(jaGetrennt)  2]
      editNummernBereich $w.kopf.talonExist  $neu $text(talonExist)  \
              exist($editArt,talon)  0 30
      editNummernBereich $w.kopf.strafeExist $neu $text(strafeExist) \
              exist($editArt,strafe) 0 30
      if {$neu} {
        frame $w.kopf.stapel -relief raised -bd 1
        frame $w.kopf.stapel.anz
        label $w.kopf.stapel.anz.fest -text $text(stapelAnz)
        scale $w.kopf.stapel.anz.feld -orient horizontal \
                                      -length 200 -from 1 -to 10
        pack  $w.kopf.stapel.anz.fest $w.kopf.stapel.anz.feld -side left
        pack  $w.kopf.stapel.anz -side top -fill x
      }
      bind $w.kopf.stapel.anz.feld <ButtonRelease-1> \
              "+setStapelAnz $w $editArt $w.kopf.stapel.anz.feld"
      $w.kopf.stapel.anz.feld set $stapelAnz($editArt)
      setStapelAnz $w $editArt [expr {$neu ? "" : "$w.kopf.stapel.anz.feld"}]
      editAuswahl $w.kopf.stapelReihe $neu $text(stapelReihe) \
              stapelReihe($editArt)                                   \
              [list "$text(absteigend), $text(echt)"    abst,echt]    \
              [list "$text(absteigend), $text(unecht)"  abst,unecht]  \
              [list "$text(absteigend), $text(egal)"    abst,egal]    \
              [list "$text(aufsteigend), $text(echt)"   aufst,echt]   \
              [list "$text(aufsteigend), $text(unecht)" aufst,unecht] \
              [list "$text(aufsteigend), $text(egal)"   aufst,egal]   \
              [list "$text(aufAb), $text(echt)"         aufAb,echt]   \
              [list "$text(aufAb), $text(unecht)"       aufAb,unecht] \
              [list "$text(aufAb), $text(egal)"         aufAb,egal]
      editAuswahl $w.kopf.teilStapel $neu $text(teilStapel) \
              teilStapelReihe($editArt) \
              [list "$text(absteigend), $text(echt)"    abst,echt]    \
              [list "$text(absteigend), $text(unecht)"  abst,unecht]  \
              [list "$text(absteigend), $text(egal)"    abst,egal]    \
              [list "$text(aufsteigend), $text(echt)"   aufst,echt]   \
              [list "$text(aufsteigend), $text(unecht)" aufst,unecht] \
              [list "$text(aufsteigend), $text(egal)"   aufst,egal]   \
              [list "$text(aufAb), $text(echt)"         aufAb,echt]   \
              [list "$text(aufAb), $text(unecht)"       aufAb,unecht] \
              [list "$text(einzelKarte)"                garNicht]
      editAuswahl $w.kopf.stockReihe $neu $text(stockReihe) stockReihe($editArt) \
              [list "$text(absteigend), $text(echt)"      abst,echt]  \
              [list "$text(aufsteigend), $text(echt)"     aufst,echt] \
              [list "$text(absteigend), $text(komplett)"  abst,kompl] \
              [list "$text(aufsteigend), $text(komplett)" aufst,kompl]
      editAuswahl $w.kopf.strafReihe $neu $text(strafReihe) strafReihe($editArt) \
              [list "$text(absteigend), $text(echt)"    abst,echt]    \
              [list "$text(absteigend), $text(unecht)"  abst,unecht]  \
              [list "$text(aufsteigend), $text(echt)"   aufst,echt]   \
              [list "$text(aufsteigend), $text(unecht)" aufst,unecht] \
              [list "$text(aufAb), $text(echt)"         aufAb,echt]   \
              [list "$text(aufAb), $text(unecht)"       aufAb,unecht]
      editAuswahl $w.kopf.stockBasis $neu $text(stockBasis) stockBasis($editArt) \
              [list 2           2]       [list 3             3] \
              [list 4           4]       [list 5             5] \
              [list 6           6]       [list 7             7] \
              [list 8           8]       [list 9             9] \
              [list 10          0]       [list $text(bauer)  b] \
              [list $text(dame) d]       [list $text(koenig) k] \
              [list $text(as)   a]       "--"                   \
              [list $text(ersteKarte) erste]
      editAuswahl $w.kopf.leerStapel $neu $text(stapelBasis) \
              leerStapelNurHoch($editArt) \
              [list $text(jedeKarte)   0] \
              [list $text(nurHoechste) 1]
      editAuswahl $w.kopf.talonAb $neu $text(talonAb) \
              talonAbraeumbar($editArt) \
              [list $text(ja)   1] \
              [list $text(nein) 0]

      pack $w.kopf.patArt      $w.kopf.name        $w.kopf.kartenSatz  \
          $w.kopf.streitArt    $w.kopf.talonExist  $w.kopf.strafeExist \
          $w.kopf.stapel       $w.kopf.stapelReihe $w.kopf.teilStapel  \
          $w.kopf.stockReihe   $w.kopf.strafReihe  $w.kopf.stockBasis  \
          $w.kopf.leerStapel   $w.kopf.talonAb     -fill x

      pack $w.kopf -side top
    }
    proc editPatNames {w} {
      global patiencePath editArt text patName sprache

      toplevel $w.patNames
      wm transient $w.patNames $w
      set x [winfo rootx $w]
      set y [expr {[winfo rooty $w] +[winfo height $w]}]
      wm geometry $w.patNames +$x+$y

      foreach bekannteSprache [glob $patiencePath/text/*] {
        set aktSprache [file tail $bekannteSprache]
        frame $w.patNames.$aktSprache -bd 1m
        pack  $w.patNames.$aktSprache -fill x
        entry $w.patNames.$aktSprache.name -relief sunken -width 20 \
                            -textvariable patName($editArt,$aktSprache)
        bind  $w.patNames.$aktSprache.name <Return> "destroy $w.patNames"
        label $w.patNames.$aktSprache.sprache -text "$aktSprache:"
        pack  $w.patNames.$aktSprache.name    -side right
        pack  $w.patNames.$aktSprache.sprache -side left
      }
      button $w.patNames.ok -text $text(okay) -command "destroy $w.patNames"
      pack $w.patNames.ok -fill x

      set oldFocus [focus]
      grab set $w.patNames
      focus $w.patNames
      tkwait window $w.patNames
      focus $oldFocus

      $w configure -text $patName($editArt,$sprache)
    }
    proc regelNeu {w} {
      global editArt regelEditAltPat

      if {![regelnPatArt]} return
      kopiereRegeln $editArt $regelEditAltPat
      regelnAnzeigen $w 0
    }
    proc regelLaden {w} {
      global editArt patArt regelEditAltPat text
      global patArt patName kartenSatz streitArt exist stapelAnz \
             stapelGrund stapelVerdeckt stapelReihe stockBasis   \
             stockReihe teilStapelReihe strafReihe               \
             leerStapelNurHoch talonAbraeumbar

      if {![holDateiName $text(ladeAuswahl) regelDateiName "*" \
          "*.spr" "spiel.spr"]} return
     
      upvar 0 local patArt

      source $regelDateiName
      set editArt :$patArt
      kopiereRegeln $editArt $patArt

      regelnAnzeigen $w 0
    }
    proc regelAbbruch {w zustandName} {
      global regelEditAltPat zustSicherungStatus stapelAnz editArt

      # Zuerst das Regelfenster schliessen, damit es vom Bildschirm verschwindet.
      destroy $w
      unset stapelAnz($editArt)

      switch $zustSicherungStatus {
        IstGemacht {
          # Hier wird auf den gesicherten Spielstand wieder aufgesetzt.
          liesZustand $zustandName
          # In diesem Fall ist Aufraeumen angesagt...
          catch [exec rm $zustandName]
        }
        NichtGemacht {
          starteSpiel 0 $regelEditAltPat
        }
      }
    }
    proc regelOkay {w zustDateiName} {
      global editArt zustSicherungStatus

      if {![regelSichern]} return
      set pat [string range $editArt 1 end]
      kopiereRegeln $pat $editArt

      # Zunaechst mal das Fenster und die temporaeren Dateien aufraeumen.
      destroy $w
      if {$zustSicherungStatus == "IstGemacht"} {
        catch [exec rm $zustDateiName]
      }

      # Nun ein Spiel nach den neuen Regeln starten.
      starteSpiel 0 $pat
    }
    proc regelSichern {} {
      global regelDateiName editArt text

      global stapelVerdeckt stapelGrund exist

      foreach index [array names stapelVerdeckt] {
        set stapelGrund($index) [expr {$stapelVerdeckt($index)+1}]
      }
      set exist($editArt,arbeit) 0
      if {[holDateiName $text(speicherAuswahl) regelDateiName "" \
          "*.spr" "[string trimleft $editArt :].spr"]} {
        schrRegeln $regelDateiName $editArt
        return 1
      } else {
        return 0
      }
    } 
    proc setStapelAnz {w patArt scale} {
      global stapelAnz stapelVerdeckt

      if {$scale == ""} {
        # Die Funktion wird aufgerufen fuer einen Neuaufbau des Bildes.
        set altAnz 0
        set neuAnz $stapelAnz($patArt)
      } else {
        # Die Funktion soll nur die geaenderten Stapel-Eintraege aktualisieren.
        set altAnz $stapelAnz($patArt)
        set neuAnz [$scale get]
        set stapelAnz($patArt) $neuAnz
      }

      for {set aktStapel 0} {$aktStapel < $neuAnz} {incr aktStapel} {
        set aktFrame $w.kopf.stapel.grund$aktStapel
        if {![winfo exists $aktFrame]} {
          frame $aktFrame
          label $aktFrame.fest -text "$aktStapel"
          scale $aktFrame.feld -from 10 -to 0
          pack  $aktFrame.fest $aktFrame.feld -side top -fill both
          pack  $aktFrame -side left
        }
        $aktFrame.feld configure -com "set stapelVerdeckt($patArt,$aktStapel)"

        # Falls die Variable noch nicht existiert, initialisieren.
        if {![info exists stapelVerdeckt($patArt,$aktStapel)]} {
          set stapelVerdeckt($patArt,$aktStapel) 0
        }
        # Den Schieber auf den Wert der Variable setzen.
        $aktFrame.feld set $stapelVerdeckt($patArt,$aktStapel)
      }

      for {set aktStapel $neuAnz} {$aktStapel < 10} {incr aktStapel} {
        if {[winfo exists $w.kopf.stapel.grund$aktStapel]} {
          destroy $w.kopf.stapel.grund$aktStapel
        }
      }
    }
    proc editAuswahl {w neu text var args} {
      global textVal($w)

      setzVar $w textVal($w) $var $args 0
      if {$neu} {
        frame $w -relief raised -bd 1
        label $w.fest -text $text
        menubutton $w.feld -textvariable textVal($w) -menu $w.feld.m
        pack $w.fest $w.feld -side left
        menu $w.feld.m
      }
      foreach textValPaar $args {
        if {$textValPaar == "--"} {
          if {$neu} {
            $w.feld.m add separator
          }
        } else {
          if {$neu} {
            $w.feld.m add radiobutton -variable textVal($w) \
                -label [lindex $textValPaar 0] -value [lindex $textValPaar 0] 
          }
          $w.feld.m entryconfigure [lindex $textValPaar 0] \
              -command "setzVar $w \"$var\" textVal($w) [list $args] 1"
        }
      }
    }
    proc setzVar {w destVar srcVar textValListe invers} {
      upvar #0 $destVar dest
      upvar #0 $srcVar  src

      foreach textValPaar $textValListe {
        if {$src == [lindex $textValPaar [expr 1-$invers]]} {
          set dest [lindex $textValPaar [expr 0+$invers]]

          # Hiermit gewaehleisten wir, dass die unsinnigen Kombinationen von
          # kartenSatz und streitArt nicht eingestellt werden koennen:
          switch -glob $destVar {
            streitArt* - kartenSatz* {
              checkStreitSatz $w $destVar $dest
            }
          }
          return
        }
      }
    }
    proc checkStreitSatz {w varName wert} {
      switch -glob $varName {
        streitArt* {
          regsub streitArt $w kartenSatz entry
          $entry.feld.m entryconfigure 0 \
              -state [expr {$wert == 1 ? "disabled" : "normal"}]
        }
        kartenSatz* {
          regsub kartenSatz $w streitArt entry
          $entry.feld.m entryconfigure 1 \
              -state [expr {$wert == 1 ? "disabled" : "normal"}]
        }
      }
    }
    proc editNummernBereich {w neu text var min max} {
      upvar #0 $var auswahlVar

      if {$neu} {
        frame $w -relief raised -bd 1
        frame $w.anz
        label $w.anz.fest -text $text
        scale $w.anz.feld -orient horizontal -length 200 -from $min -to $max
        pack  $w.anz.fest $w.anz.feld -side left
        pack        $w.anz -side top -fill x
      }
      $w.anz.feld configure -command "setzGlobal \"$var\""
      $w.anz.feld set $auswahlVar
    }
    proc setzGlobal {var wert} {
      upvar #0 $var x
      set x $wert
    }
    proc regelnAnwenden {zustandName} {
      global editArt zugNr zustSicherungStatus

      if {$zugNr > 0} {
        if {![neuesSpiel]} return

        if {$zustSicherungStatus == "IstNoetig"} {
          set zustSicherungStatus "IstGemacht"
          schrZustand $zustandName
        }
      }
      if {$zustSicherungStatus != "IstGemacht"} {
        set zustSicherungStatus "NichtGemacht"
      }
      starteSpiel 0 $editArt
    }
    proc regelnPatArt {} {
      global neuEditArt editArt regelnPatArtOkay stapelAnz text

      set w .neuPat
      toplevel $w
      wm title $w $text(neuerSpielregeln)

      set neuEditArt ""
      message  $w.msg -width 6c -text $text(nameAufforderung)
      entry  $w.ent -textvariable neuEditArt -relief sunken -width 20

      set msg2Text $text(bisherVergeben)
      set comma ""
      foreach regelName [lsort [interneRegelNamen]] {
        append msg2Text $comma $regelName
        set comma ", "
      }
      append msg2Text $text(nurErlaubt)
      message  $w.msg2 -width 6c -text $msg2Text

      frame  $w.buttons -relief raised -bd 1
      button $w.buttons.abbruch -text $text(abbruch) -com "set regelnPatArtOkay 0"
      button $w.buttons.okay    -text $text(okay)    -com "set regelnPatArtOkay 1"
      frame  $w.buttons.default -relief sunken -bd 1
      raise  $w.buttons.okay
      pack   $w.buttons.abbruch -side left -expand 1 \
                                -padx 3m -pady 3m -ipadx 2m -ipady 1m
      pack   $w.buttons.default -side left -expand 1 -padx 3m -pady 2m
      pack   $w.buttons.okay -in $w.buttons.default \
                                -padx 2m -pady 2m -ipadx 2m -ipady 1m

      pack  $w.msg $w.ent $w.msg2
      pack  $w.buttons -expand 1 -fill x

      set altFokus [focus]
      grab set $w
      focus $w.ent
      bind $w.ent <Return> "$w.buttons.okay flash; $w.buttons.okay invoke"

      while {$neuEditArt == "" || [regexp {[^a-zA-Z0-9_-]} $neuEditArt]} {
        set regelnPatArtOkay -1
        tkwait variable regelnPatArtOkay
        if {!$regelnPatArtOkay} {
          # Die Benutzerin hat es sich jetzt doch anders ueberlegt.
          break
        }
      }
      if {$regelnPatArtOkay} {
        set editArt :$neuEditArt
      }

      destroy $w
      focus $altFokus
      return $regelnPatArtOkay
    }
    proc fileSelect {w ueberschrift datei dir match} {
        global fileSelect_dateiName fileSelect_dirName \
               fileSelect_match fileSelect_okay text

        catch {destroy $w}
        toplevel $w -class Dialog
        wm title $w $ueberschrift
        wm iconname $w $ueberschrift

        set fileSelect_dirName   $dir
        set fileSelect_dateiName $datei
        set fileSelect_match     $match
        set fileSelect_okay      1

        label $w.textOben   -text $ueberschrift
        pack  $w.textOben   -fill x

        frame $w.kopf -relief raised -bd 1

        frame $w.kopf.fest
        label $w.kopf.fest.dir   -text $text(fs,ordner)
        label $w.kopf.fest.datei -text $text(fs,datei)
        label $w.kopf.fest.match -text $text(fs,maske)
        pack $w.kopf.fest.dir $w.kopf.fest.datei $w.kopf.fest.match -anchor w

        frame $w.kopf.feld
        entry $w.kopf.feld.dir   -textvariable fileSelect_dirName   -width 40
        entry $w.kopf.feld.datei -textvariable fileSelect_dateiName -width 40
        entry $w.kopf.feld.match -textvariable fileSelect_match     -width 40
        pack $w.kopf.feld.dir $w.kopf.feld.datei $w.kopf.feld.match -anchor w

        pack $w.kopf.fest $w.kopf.feld -side left
        pack $w.kopf

        frame $w.box -relief raised -bd 1
        scrollbar $w.scroll -command "$w.list yview"
        pack $w.scroll -in $w.box -side right -fill y
        listbox $w.list -yscroll "$w.scroll set" -relief raised -geometry 30x20 \
              -setgrid yes
        pack $w.list -in $w.box -side left  -fill both -expand yes
        pack $w.box 
        tk_listboxSingleSelect $w.list
        bind $w.list <ButtonRelease-1> "+uebernimm $w.list"
        bind $w.list <Double-1>        "destroy $w"
        fillDirList $w.list $dir

        frame $w.bot -relief raised -bd 1
        pack  $w.bot -side bottom -fill both

        button $w.okay -text $text(okay) -command "destroy $w"
        frame $w.default -relief sunken -bd 1
        raise $w.okay $w.default
        pack $w.default -in $w.bot -side right -expand 1 -padx 3m -pady 2m
        pack $w.okay -in $w.default -padx 2m -pady 2m -ipadx 2m -ipady 1m

        foreach i "$w $w.kopf.feld.dir $w.kopf.feld.datei $w.kopf.feld.match" {
          bind $i <Return> "$w.okay flash; destroy $w"
        }

        button $w.abbruch -text $text(abbruch) \
          -command "set fileSelect_okay 0; destroy $w"
        pack $w.abbruch -in $w.bot -side left -expand 1 \
                          -padx 3m -pady 3m -ipadx 2m -ipady 1m

        set oldFocus [focus]
        grab $w
        focus $w
        tkwait window $w
        focus $oldFocus

        if {$fileSelect_okay} {
          if {$fileSelect_dirName != "/"} {
            return $fileSelect_dirName/$fileSelect_dateiName
          } else {
            return /$fileSelect_dateiName
          }
        } else {
          return ""
        }
      }
    proc fillDirList {list dir} {
      global fileSelect_match

      set dirList [exec ls -a $dir]

      # Evtl. vorhandener alter Schrott wird geloescht.
      $list delete 0 end

      # In der ersten Runde alle Directories aufsammeln,
      foreach i $dirList {
        if {[file isdirectory $dir/$i]} {
          $list insert end $i
        }
      }

      # dann alle sonstigen Dateien, die zu dem gegebenen Muster passen.
      foreach i $dirList {
        if {[string match $fileSelect_match $i] && ![file isdirectory $dir/$i]} {
          $list insert end $i
        }
      }
    }
    proc uebernimm {fs} {
      global fileSelect_dateiName fileSelect_dirName

      if [catch {set datei [selection get]}] {return}

      if [file isdirectory $fileSelect_dirName/$datei] {
        if {$datei == ".." && [regsub {/[^/]*$} $fileSelect_dirName "" neuDir]} {
          set fileSelect_dirName [expr {$neuDir == "" ? "/" : $neuDir}]
        } elseif {$datei != "."} {
          set fileSelect_dirName [expr {$fileSelect_dirName == "/" ? "/$datei" :
                                    "$fileSelect_dirName/$datei"}]
        }
        fillDirList $fs $fileSelect_dirName
      } else {
        set fileSelect_dateiName $datei
      }
    }
    proc erstelltVon {} {
        global patienceVersion bitPath text

        set ausgabe    "$text(patience) / $text(version) $patienceVersion\n\n"
        append ausgabe "$text(patienceFuerX11)\n$text(erstelltVonCK)\n\n"
        append ausgabe "krischan@cs.tu-berlin.de"

        tk_dialog .t1 $text(erstelltVon) $ausgabe @$bitPath/kk 0 $text(okay)
      }
      proc beenden {} {
        global text

        set ausgabe    "$text(hoffeSpielWarGut)\n\n$text(wirklichBeenden)"
        tk_dialog .t1 $text(wirklichBeenden) $ausgabe "" \
                      1 $text(abbruch) $text(spielende)
      }
      proc neuesSpiel {} {
        global text

        tk_dialog .t1 $text(neuesSpiel) $text(wirklichNeu) \
                  "" 1 $text(abbruch) $text(neuesSpiel)
      }
      proc glueckwunsch {zugNr vorschlagZaehler} {
        global bitPath text

        switch $vorschlagZaehler {
          0       { set vorschlaege "" }
          1       { set vorschlaege $text(undEsGab)$text(einVorschlag) }
          default { set vorschlaege $text(undEsGab)$vorschlagZaehler$text(vorschlaege) }
        }

        set ausgabe    "$text(gratuliere)\n\n$text(patienceGeloest)\n"
        append ausgabe "$text(dazuBenoetigt)$zugNr$text(zuege)\n$vorschlaege"
        tk_dialog .t1 $text(glueckwunsch) $ausgabe "@$bitPath/dp" 0 $text(super)
      }
      proc streitGlueckwunsch {restKarten} {
        global bitPath text

        set ausgabe    "$text(gratuliere)\n\n$text(sieHabenGewonnen)"
        append ausgabe "$text(undGegnerHat)$restKarten"
        append ausgabe [expr {$restKarten>1?$text(restKarten1):$text(restKarte1)}]"
        tk_dialog .t1 $text(glueckwunsch) $ausgabe @$bitPath/dp 0 $text(super)
      }
      proc streitBeileid {restKarten} {
        global bitPath text

        set ausgabe    "$text(schade)\n\n$text(sieHabenVerloren)"
        append ausgabe "$text(undSieHatten)$restKarten"
        append ausgabe [expr {$restKarten>1?$text(restKarten2):$text(restKarte2)}]
        tk_dialog .t1 $text(beileid) $ausgabe @$bitPath/dp 0 $text(naechstesMal)
      }
      proc tadel {zugNr mogelZaehler} {
        global bitPath text

        set ausgabe    "$text(spielAufgegangen)\n\n$text(dazuBenoetigt)"
        append ausgabe "$zugNr$text(zuege)\n$text(aberSieHaben)$mogelZaehler"
        append ausgabe "$text(malGeschummelt)\n$text(vielleichtBesser)"
        tk_dialog .t1 $text(glueckwunsch) $ausgabe @$bitPath/bk 0 $text(probieren)
      }
      proc nichtLesbar {dateiName} {
        global text

        tk_dialog .t1 $text(nichtLesbar) \
                      $text(dieDatei)$dateiName$text(istNichtLesbar) \
                      question 0 $text(dannNicht)
      }
      proc nichtSchreibbar {dateiName} {
        global text

        tk_dialog .t1 $text(nichtSchreibbar) \
                      $text(dieDatei)$dateiName$text(istNichtSchreibbar) \
                      question 0 $text(dannNicht)
      }
  
    proc startEinzelKarte {karte x y stapel} {
        global lastX lastY flaeche

        global spezialKommando
        if {$spezialKommando != ""} {
          if {[string index $spezialKommando 0] == "+"} {
            uplevel #0 [string range $spezialKommando 1 end]
          } else {
            uplevel #0 $spezialKommando
            return
          }
        }
        $flaeche raise $karte
        spielXY lastX lastY $x $y
        $flaeche bind $karte <B1-Motion> "schiebKarte $karte %x %y"
        $flaeche bind $karte <Any-ButtonRelease-1> \
                "endEinzelKarte $karte $stapel %x %y"
      }
      proc drehUm {karte stapel} {
        global verdeckt teilStapelUnterst fuelle

        maleKarte $karte alt $stapel [expr {$fuelle($stapel)-1}]
        incr verdeckt($stapel) -1
        incr teilStapelUnterst($stapel) -1

        checkTeilStapel $stapel plusEins
        setzInversZug "zurueckDrehUm $karte $stapel"
      }
      proc pruefFreieKarte {aktStapel art} {
        global fuelle stapel verdeckt streitArt patArt

        if {[info exists nurZustand] && [string match ? $aktStapel]} {
          checkTeilStapel $aktStapel $art
          return
        }

        switch -glob $aktStapel {
          ? {
            if {$fuelle($aktStapel) > 0} {
              set oberste $stapel($aktStapel,[expr $fuelle($aktStapel)-1])
              if {$fuelle($aktStapel) <= $verdeckt($aktStapel)} {
                umdrehbar $oberste $aktStapel
              } else {
                verschiebbar $oberste $aktStapel
                checkTeilStapel $aktStapel $art
                pruefStapelFuelle $aktStapel
              }
            }
          }
          talon* {
            if {$streitArt($patArt)} {
              aktiviereGeben [expr {$aktStapel=="talon2"?"hand2":"hand"}] ein
            }
            autoStock $aktStapel
          }
          strafe* {
            autoStock $aktStapel
          }
        }
      }
      proc steckInStapel {neuStapel neuKarte art} {
        global stapel fuelle nurZustand

        set auchBild [expr {![info exists nurZustand]}]
        set stapel($neuStapel,$fuelle($neuStapel)) $neuKarte
        if {$auchBild} {
          maleKarte $neuKarte alt $neuStapel $fuelle($neuStapel)
        }
        incr fuelle($neuStapel)

        if {[string match ? $neuStapel]} {
          # Passt die neue Karte auf den Stapel gut rauf?
          checkTeilStapel $neuStapel $art

          if {$auchBild} {
            # Ueberpruefen, ob der Stapel komprimiert werden muss.
            pruefStapelFuelle $neuStapel
          }
        }
      }
      proc steckInStock {neuStock neuKarte neu} {
        global stapel fuelle flaeche nurZustand

        if {$neu} {
          # Die Karte wird gerade neu auf den Stock gelegt.
          set stapel($neuStock,$fuelle($neuStock)) $neuKarte
          incr fuelle($neuStock)
        }

        if {![info exists nurZustand]} {
          maleKarte $neuKarte alt $neuStock
          switch -glob $neuStock {
            ?,c {$flaeche lower $neuKarte sh[string index $neuStock 0] }
            ?,h {$flaeche lower $neuKarte sp[string index $neuStock 0] }
            ?,p {$flaeche lower $neuKarte sk[string index $neuStock 0] }
          }
        }
      }
      proc startTeilStapel {karte x y} {
        global stapel fuelle teilStapelUnterst lastX lastY flaeche

        global spezialKommando
        if {$spezialKommando != ""} {
          if {[string index $spezialKommando 0] == "+"} {
            uplevel #0 [string range $spezialKommando 1 end]
          } else {
            uplevel #0 $spezialKommando
            return
          }
        }

        # Bildschirmbezogene Koordinaten auf Spielflaechen-bezogene umrechnen.
        spielXY lastX lastY $x $y

        set anwStapel [findeStapel $x $y]
        set maxI $fuelle($anwStapel)
        set gefunden 0
        for {set aktI $teilStapelUnterst($anwStapel)} {$aktI < $maxI} {incr aktI} {
          set verglKarte $stapel($anwStapel,$aktI)
          if {!$gefunden && $verglKarte == $karte} {
            set gefunden 1
            set anwTeilStapelNr $aktI
          }
          if {$gefunden} {
            $flaeche raise $verglKarte
            $flaeche itemconfigure $verglKarte -tags "$verglKarte teilStapel"

            # Hier werden jetzt alle (evtl. sogar aus aelteren Spielen vorhandenen
            # Bindungen geloescht, damit sie uns nicht mehr in die Quere kommen.
            nichtBewegbar $karte
          }
        }
        if {!$gefunden} return

        # Das Bewegen und Loslassen der Maus mit den entspr. Funktionen belegen.
        $flaeche bind teilStapel <B1-Motion> "schiebKarte teilStapel %x %y"
        $flaeche bind teilStapel <Any-ButtonRelease-1> \
                "endTeilStapel $karte $anwStapel $anwTeilStapelNr %x %y"
      }
      proc ablegen {} {
        global stapelAnz stockReihe patArt stapel fuelle exist teilStapelUnterst

        set gefunden 1
        set kompletteFamilie [string match *,kompl $stockReihe($patArt)]

        while {$gefunden} {
          set gefunden 0
          if {!$kompletteFamilie} {
            foreach sonderStapel {talon strafe} {
              if {$exist($patArt,$sonderStapel) > 0 && $fuelle($sonderStapel) > 0} {
                switch -- [karteAufStock \
                              $stapel($sonderStapel,[expr $fuelle($sonderStapel)-1]) \
                              $sonderStapel 0 1] {
                   1 {set gefunden 1}
                  -1 {return}
                }
              }
            }
          }
          for {set aktStapel 0} {$aktStapel<$stapelAnz($patArt)} {incr aktStapel} {
            set oberst [expr {$fuelle($aktStapel)-($kompletteFamilie?13:1)}]
            if {$oberst < $teilStapelUnterst($aktStapel)} continue

            switch -- [karteAufStock $stapel($aktStapel,$oberst) $aktStapel 0 1] {
               1 {set gefunden 1}
              -1 {return}
            }
          }
        }
      }
      proc tuWasGutes {x y} {
        global tutGeradeWasGutes

        global spezialKommando
        if {$spezialKommando != ""} {
          if {[string index $spezialKommando 0] == "+"} {
            uplevel #0 [string range $spezialKommando 1 end]
          } else {
            uplevel #0 $spezialKommando
            return
          }
        }

        if {[info exists tutGeradeWasGutes]} return
        set tutGeradeWasGutes 1

        machsBesteDraus $x $y

        unset tutGeradeWasGutes
      }
      proc machsBesteDraus {x y} {
        global verdeckt stapel fuelle teilStapelUnterst \
               streitArt stockReihe stapelAnz talonAbraeumbar patArt

        set anwStapel [findeStapel $x $y]
        if {$anwStapel == ""} return

        set oberstI   [expr $fuelle($anwStapel)-1]
        set gefunden  0
        switch -glob $anwStapel {
          ? {
            if {$oberstI < $verdeckt($anwStapel)} return
            if {[string match *,kompl $stockReihe($patArt)]} {
              set oberstI [expr $fuelle($anwStapel)-13]
            }
            if {$oberstI < $teilStapelUnterst($anwStapel)} {
              set oberstI -1
            }
            set vonY $teilStapelUnterst($anwStapel)
          }
          talon* {
            if {$oberstI < $verdeckt($anwStapel) ||
                $streitArt($patArt) && $anwStapel == "talon"} return
            set vonY $oberstI
          }
          strafe* {
            if {$oberstI < 0 ||
                $streitArt($patArt) && $anwStapel == "strafe"} return
            set vonY $oberstI
          }
          hand* {
            if {[istGebenAktiv]} {geben $anwStapel}
            return
          }
          default return
        }
        if {$oberstI >= $vonY} {
          if {[karteAufStock $stapel($anwStapel,$oberstI) $anwStapel 0 1]} {
            set gefunden 1
            set neuStapel x,x
          }
        }

        if {!$gefunden} {
          set miesesZiel ""
          if {[string match ? $anwStapel]} {
            set neuStapel [expr {$anwStapel+1}]
            if {$neuStapel<$stapelAnz($patArt)} {
              while {42} {
                wohinBewegbar $stapel($anwStapel,$vonY) neuStapel ziel
                if {$neuStapel < 0} break
                if {$ziel == "stapel"} {
                  schiebStapel $anwStapel $vonY $neuStapel $fuelle($neuStapel) {}
                  set gefunden 1
                  break
                }
                if {$miesesZiel == ""
                    || ($miesesZiel == "leerStapel" && $ziel != "leerStapel")} {
                  set miesesZiel   $ziel
                  set mieserStapel $neuStapel
                }
                incr neuStapel
              }
            }
          }
          if {!$gefunden} {
            set neuStapel 0
            while {42} {
              wohinBewegbar $stapel($anwStapel,$vonY) neuStapel ziel
              if {$neuStapel < 0} break
              if {$ziel == "stapel"} {
                schiebStapel $anwStapel $vonY $neuStapel $fuelle($neuStapel) {}
                set gefunden 1
                break
              }
              if {$miesesZiel == ""
                  || ($miesesZiel == "leerStapel" && $ziel != "leerStapel")} {
                set miesesZiel   $ziel
                set mieserStapel $neuStapel
              }
              incr neuStapel
            }
          }
        }

        if {!$gefunden && $miesesZiel != ""} {
          schiebStapel $anwStapel $vonY $mieserStapel $fuelle($mieserStapel) {}
          set gefunden 1
        }

        if {!$gefunden} {
          bell
        } else {
          if {[string match ?,? $neuStapel] || $streitArt($patArt) || !$fuelle(hand)} {
            if {[checkSpielEnde 0]} return
          }
          switch -glob $anwStapel {
            ? {
              if {$fuelle($anwStapel) == $verdeckt($anwStapel)
                  && $fuelle($anwStapel) > 0} {
                drehUm $stapel($anwStapel,[expr {$fuelle($anwStapel)-1}]) $anwStapel
              }
            }
            talon* {
              if {!$talonAbraeumbar($patArt)
                  && $fuelle($anwStapel) == $verdeckt($anwStapel) } {
                handNachTalon [expr {$anwStapel == "talon" ? "hand" : "hand2"}] $anwStapel 1
              }
            }
          }
        }
      }
      proc karteAufStock {anwKarte anwStapel inDemo incrZugNr} {
        global fuelle zugNr flaeche stockReihe patArt nurZustand streitArt

        set neuStock [kannAufStock $anwKarte]
        if {$neuStock == ""} {return 0}

        if {$incrZugNr} {incr zugNr}

        switch -glob $stockReihe($patArt) {
          *,kompl {
            set vonY [expr {$fuelle($anwStapel)-13}]
            schiebTeilstapel $anwStapel $vonY $neuStock
            plaziereTeilstapel $anwStapel $neuStock $vonY
            setzInversZug "zurueckStapel $anwStapel 0 $neuStock"
            set art minusStapel
          }
          default {
            incr fuelle($anwStapel) -1
            setzInversZug "zurueckKarte $anwKarte $anwStapel $neuStock $incrZugNr"
            if {![info exists nurZustand]} {
              karteWeg $anwKarte
              verteilComic $anwStapel $fuelle($anwStapel) $neuStock 0
            }
            steckInStock $neuStock $anwKarte 1
            set art minusEins
          }
        }
        if {![info exists nurZustand]} {
          pruefFreieKarte $anwStapel $art; update
          if {!$streitArt($patArt) && [checkSpielEnde $inDemo]} {return -1}
        }
        return 1
      }
      proc kannAufStock {altKarte} {
        global kartenSatz patArt

        set aktFarbe [string index $altKarte 1]
        for {set aktSatz 0} {$aktSatz < $kartenSatz($patArt)} {incr aktSatz} {
          set aktStock $aktSatz,$aktFarbe
          if [passt $altKarte [getStock $aktStock] $aktStock] {
            return $aktStock
          }
        }
        return ""
      }
      proc geben {hand} {
        global zugNr stapelAnz exist streitArt patArt stapel fuelle graueFarbe \
               verdeckt bitPath flaeche mitMischComic kartenFont aktFont

        if {$hand == ""} {
          set neu  1
          set hand hand
        } else {
          if {$streitArt($patArt)} {
            global aktiverSpieler text

            if {$aktiverSpieler == $text(mensch)  && $hand != "hand2"} {return 0}
            if {$aktiverSpieler == $text(mensch2) && $hand != "hand"}  {return 0}
          }
          set neu  0
          if {$exist($patArt,talon) > 0} {
            set talon [expr {$hand == "hand" ? "talon" : "talon2"}]
            return [handNachTalon $hand $talon 1]
          }
        }

        for {set aktStapel 0} {$aktStapel<$stapelAnz($patArt)} {incr aktStapel} {
          # Es werden nur Karten verteilt, wenn noch welche da sind. Das muss in
          # jedem Durchgang zugesichert werden, da nicht bei allen Patiencen
          # fuer jeden Stapel immer noch eine Karte in der Hand ist.
          if {$fuelle($hand) == 0} {return 0}

          set aktHoehe $fuelle($aktStapel)

          # Beim anfaenglichen Verteilen braucht evtl. keine Karte auf den
          # aktuellen Stapel gelegt werden.
          if {$neu && $aktHoehe > $verdeckt($aktStapel)} {
            continue
          }

          if {$mitMischComic} {
            verteilComic $hand 0 $aktStapel $fuelle($aktStapel)
          }

          # Oberste Karte vom Stapel nehmen und in den Zielstapel stecken.
          set karte $stapel($hand,[incr fuelle($hand) -1])
          set stapel($aktStapel,$aktHoehe) $karte

          if {!$fuelle($hand)} {
            $flaeche itemconfigure $hand -bitmap @$bitPath/h
            if {![info exists kartenFont($aktFont,sw)]} {
              $flaeche itemconfigure $hand -background $graueFarbe
            }
          }

          # Auf dem Bildschirm darstellen (evtl. auf dem Ruecken).
          if {$fuelle($aktStapel) < $verdeckt($aktStapel)} {
            maleRuecken $karte $aktStapel $fuelle($aktStapel)
            incr fuelle($aktStapel)
          } else {
            # Die Karte muss aufgedeckt werden.
            maleKarte $karte neu $aktStapel $fuelle($aktStapel)
            incr fuelle($aktStapel)
            pruefFreieKarte $aktStapel plusEins

            # Evtl. werden Karten automatisch auf den Stock geschoben.
            autoStock $aktStapel
          }
          update idletask

          # Hiermit wird erreicht, das die Karten immer abwechselnd von den
          # Haenden der beiden Spielparteien genommen wird.
          if {$neu && $streitArt($patArt)} {
            set hand [expr {$hand == "hand" ? "hand2" : "hand"}]
          }
        }

        if {!$neu} {
          incr zugNr
          setzInversZug "zurueckGeben $hand"
        }
        return 0
      }
      proc handNachTalon {hand talon mitZurueck} {
        global zugNr stapelAnz exist patArt stapel fuelle bitPath \
               flaeche streitArt talonAbraeumbar nurZustand verdeckt weisseFarbe

        set auchBild [expr {![info exists nurZustand]}]
        if {$fuelle($hand) == 0} {
          if {$fuelle($talon) == 0} {return 0}
          set anzahl 0
          while {$fuelle($talon) > 0} {
            incr fuelle($talon) -1
            set karte $stapel($talon,$fuelle($talon))
            if {$auchBild} {$flaeche delete $karte}
            set stapel($hand,$fuelle($hand)) $karte
            incr fuelle($hand)
          }
          if {$auchBild} {
            $flaeche itemconfigure $hand -bitmap @$bitPath/ruecken \
                                         -background $weisseFarbe
            verteilComic $talon 0 $hand 0
          }
          set verdeckt($talon) 0
        } else {
          set anzahl $exist($patArt,talon)
          if {!$talonAbraeumbar($patArt) && $fuelle($talon) > 0 && $auchBild} {
            set verdeckt($talon) $fuelle($talon)
            nichtVerschiebbar $stapel($talon,[expr {$fuelle($talon)-1}])
          }
          if {$auchBild} {verteilComic $hand 0 $talon 0}
          if {$fuelle($hand) < $anzahl} {set anzahl $fuelle($hand)}
          for {set aktI 0} {$aktI < $anzahl} {incr aktI} {
            karteVonHandNach $hand $talon
          }
          if {$streitArt($patArt)} {
            aktiviereGeben $hand aus
          }
        }
        if {$auchBild} {update idletask}

        if {$mitZurueck} {
          incr zugNr
          setzInversZug "zurueckHandNachTalon $hand $talon $anzahl"
        }
        if {$anzahl > 0 && $auchBild} {
          return [autoStock $talon]
        } else {
          return 0
        }
      }
      proc karteVonHandNach {hand dest} {
        global fuelle stapel bitPath flaeche nurZustand kartenFont aktFont \
               graueFarbe

        set auchBild [expr {![info exists nurZustand]}]
        set karte $stapel($hand,[incr fuelle($hand) -1])
        set stapel($dest,$fuelle($dest)) $karte

        # Nun, wo die Karte verteilt wurde, von der Anzahl der Hand abziehen...
        # Das sollte besser schon vorm Comic passieren, da dann die Anzeige
        # der Kartenanzahl plausibler ist.
        
        if {!$fuelle($hand) && $auchBild} {
          $flaeche itemconfigure $hand -bitmap @$bitPath/h
          if {![info exists kartenFont($aktFont,sw)]} {
            $flaeche itemconfigure $hand -background $graueFarbe
          }
        }
        # ... und beim Ziel (Talon, Strafstapel oder dergl.) wieder daraufaddieren.
        incr fuelle($dest)

        # Anlegen und Aufdecken der Spielkarte an der gewuenschten Stelle.
        if {$auchBild} {maleKarte $karte neu $dest}
      }
      proc schluss {} {
        if [beenden] {global demoAktiv; set demoAktiv 0; destroy .}
      }
      proc starteSpiel {rueckfrage {anderePat ""}} {
        global neuPat streitArt kartenSatz patArt bitPath zugNr flaeche aktFont

        if {$rueckfrage} {
          if {$zugNr > 0 && ![neuesSpiel]} {
            set neuPat $patArt; return
          }
          global demoAktiv; set demoAktiv 0
        }
        if {$anderePat != ""} {
          set neuPat $anderePat
        }
        set patArt $neuPat

        # Solange wir das Bild aufbauen, darf keine Aufforderung zur Demo stoeren.
        aktiviereKritischeKommandos aus

        if {$zugNr >= 0} {
          # Alle Items der Spielflaeche wegschmeissen und leere Flaeche malen.
          $flaeche delete all
          update
        }
        initZustand

        # Um sicherzustellen, dass alles gemaess der evtl. neuen Regeln auf
        # den Bildschirm passt.
        setBitPath <>

        maleLeereStoecke

        # Zunaechst den oder die Kartenstapel beim Mischen zeichnen, dann das
        # tatsaechliche Mischen der Karten in die Haende anstossen.
        mischComic hand
        if {$streitArt($patArt)} {
          mischComic hand2
        }
        mischen

        # Das kleine Fensterchen mit der Anzahl der Karten.
        maleKartenAnz

        bildeHand

        if {$streitArt($patArt)} {
          maleZugbestaetigungsknopf
          global flaeche aktiverSpieler text talonAbraeumbar patArt stapel \
                 fuelle verdeckt roteFarbe

          set aktiverSpieler $text(mensch)
          $flaeche.schachUhr configure -state normal
          $flaeche itemconfigure links  -fill $roteFarbe
          $flaeche itemconfigure rechts -fill ""
          aktiviereGeben hand2 ein
          foreach sonderStapel {talon strafe} {
            if {[info exists fuelle($sonderStapel)] && $fuelle($sonderStapel) > 0} {
              nichtVerschiebbar $stapel($sonderStapel,[expr {$fuelle($sonderStapel)-1}])
            }
          }

          if {!$talonAbraeumbar($patArt)} {
            foreach talon {talon talon2} {
              if {[info exists fuelle($talon)] && $fuelle($talon) > 0} {
                set verdeckt($talon) $fuelle($talon)
                nichtVerschiebbar $stapel($talon,[expr {$fuelle($talon)-1}])
              }
            }
          }
        }

        set SpielFertig 1

        aktiviereKritischeKommandos ein
        aktiviereBindings
      }
    proc schiebKarte {karte x y} {
      global lastX lastY flaeche

      spielXY neuX neuY $x $y
      $flaeche move $karte [expr $neuX-$lastX] [expr $neuY-$lastY]
      set lastX $neuX
      set lastY $neuY
    }
    proc endEinzelKarte {karte anwStapel x y} {
      global fuelle zugNr veraendern mogelZaehler streitArt stockReihe patArt

      set neuStapel [findeStapel $x $y]
      switch -glob $neuStapel {
        ? - talon* - strafe* {
          set treffer [passtKarteAufStapel $anwStapel $neuStapel $karte]
          if {$veraendern && !$treffer && $anwStapel != $neuStapel} {
            set treffer 1
            incr mogelZaehler
          }
          if {$treffer} {
            steckInStapel $neuStapel $karte plusEinsGueltig
          }
        }
        ?,? {
          set treffer [expr {![string match *,kompl $stockReihe($patArt)]
                             && [passt $karte [getStock $neuStapel] $neuStapel]
                             && $anwStapel != $neuStapel}]
          if {$treffer} {
            steckInStock $neuStapel $karte 1
          }
        }
        default {
          set treffer 0
        }
      }
      if {$treffer} {
        incr fuelle($anwStapel) -1
        incr zugNr
        setzInversZug "zurueckKarte $karte $anwStapel $neuStapel 1"

        pruefFreieKarte $anwStapel minusEins
        if {[string match ?,? $neuStapel] || $streitArt($patArt) || !$fuelle(hand)} {
          if {[checkSpielEnde 0]} return
        }
      } else {
        switch -glob $anwStapel {
          ?,? {
            steckInStock $anwStapel $karte 0
          }
          default {
            maleKarte $karte alt $anwStapel [expr {$fuelle($anwStapel)-1}]
          }
        }
      }
      nichtBewegbar $karte
    }
    proc passtKarteAufStapel {anwStapel neuStapel karte} {
      global patArt stapel fuelle verdeckt leerStapelNurHoch aktuellErste

      if {$anwStapel == $neuStapel} {return 0}

      switch -glob $neuStapel {
        talon*  {set umgedreht 0}
        default {set umgedreht $verdeckt($neuStapel)}
      }
      if {$fuelle($neuStapel) <= $umgedreht} {
        if {$fuelle($neuStapel) == 0} {
          if {![string match ? $neuStapel]} {return 0}
          if {$leerStapelNurHoch($patArt)} {
            return [aufsteigend $karte $aktuellErste 1]
          } else {
            return 1
          }
        } else {
          return 0
        }
      }

      set neuKarte $stapel($neuStapel,[expr $fuelle($neuStapel)-1])
      return [passt $karte $neuKarte $neuStapel]
    }
    proc checkTeilStapel {neuStapel aenderung} {
      global stapel verdeckt fuelle teilStapelUnterst patArt \
             stapelReihe teilStapelReihe

      set ungueltigSetzen 1
      set neuStapelX      [stapelX $neuStapel]
      set oben            [expr $fuelle($neuStapel)-1]
      switch $aenderung {
        plusEins - plusStapel {
          set unten $teilStapelUnterst($neuStapel)
        }
        minusEins - minusStapel {
          set unten $verdeckt($neuStapel)
        }
        plusStapelGueltig {
          set unten $teilStapelUnterst($neuStapel)
          if {$stapelReihe($patArt) == $teilStapelReihe($patArt)} {
            set ungueltigSetzen 0
          }
        }
        plusEinsGueltig {
          set unten [expr $oben-1]
          if {$unten < 0} {return}
          if {$stapelReihe($patArt) == $teilStapelReihe($patArt)} {
            set ungueltigSetzen 0
          } elseif {$unten > $teilStapelUnterst($neuStapel)} {
            set unten $teilStapelUnterst($neuStapel)
          }
        }
        default {return}
      }

      set passtNoch 1
      set verglI    $oben
      while {$verglI > $unten} {
        set verglKarte $stapel($neuStapel,$verglI)
        incr verglI -1
        set unterKarte $stapel($neuStapel,$verglI)
        if {$passtNoch && ![passt $verglKarte $unterKarte teil]} {
          if {!$ungueltigSetzen} {return}
          set passtNoch 0
          set teilStapelUnterst($neuStapel) [expr $verglI+1]
        }
        if {![info exists nurZustand]} {
          if {$passtNoch} {
            teilStapelBar $unterKarte
          } else {
            nichtVerschiebbar $unterKarte
          }
        }
      }
      if {$passtNoch && $ungueltigSetzen} {
        set teilStapelUnterst($neuStapel) $unten
      }
    }
    proc endTeilStapel {karte anwStapel anwTeilStapelNr x y} {
      global stapel fuelle zugNr flaeche patArt streitArt

      set neuStapel [findeStapel $x $y]
      switch -glob $neuStapel {
        ?   {set treffer [passtKarteAufStapel $anwStapel $neuStapel $karte]}
        ?,? {set treffer [expr {$fuelle($anwStapel)==$anwTeilStapelNr+13 &&
                                [passt $karte [getStock $neuStapel] $neuStapel]}]}
        default {set treffer 0}
      }
      if {$treffer} {
        # Der Stapel wurde an einen gueltigen Ort verschoben.
        set neuTeilStapelNr $fuelle($neuStapel)
        plaziereTeilstapel $anwStapel $neuStapel $anwTeilStapelNr
        # Wurde eine bisher verdeckte Karte nun freigelegt oder verdeckt, und
        # muss der Stapel expandiert oder komprimiert werden?
        pruefFreieKarte $anwStapel minusStapel
        pruefFreieKarte $neuStapel plusStapelGueltig

        incr zugNr
        setzInversZug "zurueckStapel $anwStapel $neuTeilStapelNr $neuStapel"
        if {[string match ?,? $neuStapel] || $streitArt($patArt) || !$fuelle(hand)} {
          if {[checkSpielEnde 0]} return
        }
      } else {
        set lastI $fuelle($anwStapel)
        for {set aktI $anwTeilStapelNr} {$aktI < $lastI} {incr aktI} {
          $flaeche coords $stapel($anwStapel,$aktI) [stapelX $anwStapel] \
                                                    [stapelY $anwStapel $aktI]
          }
        verschiebbar $stapel($anwStapel,[expr $fuelle($anwStapel)-1]) $anwStapel
      }
      $flaeche dtag teilStapel teilStapel
    }
    proc schiebTeilstapel {vonStapel vonY neuStapel} {
      global stapel fuelle mitBewegComic

      if {$mitBewegComic} {
        set kartenAnz 0
        for {set aktY $vonY} {$aktY < $fuelle($vonStapel)} {incr aktY} {
          incr kartenAnz
          karteWeg $stapel($vonStapel,$aktY)
        }
        update
        verteilComic $vonStapel [expr {$fuelle($vonStapel)-$kartenAnz}] \
                     $neuStapel $fuelle($neuStapel) $kartenAnz
      }
    }
    proc plaziereTeilstapel {anwStapel neuStapel anwTeilStapelNr} {
      global stapel fuelle flaeche nurZustand

      set lastI $fuelle($anwStapel)
      set neuX [stapelX $neuStapel]
      for {set aktI $anwTeilStapelNr} {$aktI < $lastI} {incr aktI} {
        set bewKarte $stapel($anwStapel,$aktI)
        set stapel($neuStapel,$fuelle($neuStapel)) $bewKarte
        incr fuelle($anwStapel) -1
        switch -glob $neuStapel {
          ?,? {
            steckInStock $neuStapel $bewKarte 1
            if {![info exists nurZustand]} {
              nichtVerschiebbar $bewKarte
            }
          }
          default {
            if {![info exists nurZustand]} {
              $flaeche coords $bewKarte $neuX \
                    [stapelY $neuStapel $fuelle($neuStapel)]
            }
            incr fuelle($neuStapel)
          }
        }
      }
    }
    proc getStock {stock} {
      global stapel fuelle

      set oberst [expr $fuelle($stock)-1]
      return [expr {$oberst < 0 ? "" : $stapel($stock,$oberst)}]
    }
    proc checkSpielEnde {inDemo} {
      global fuelle kartenSatz streitArt stockReihe patArt
      
      if {$streitArt($patArt)} {
        set computerAnz 0
        set menschAnz   0
        foreach sonderStapel {hand talon strafe} {
          incr computerAnz $fuelle($sonderStapel)
          incr menschAnz   $fuelle(${sonderStapel}2)
        }
        if {!$computerAnz} {
          streitBeileid $menschAnz
        } elseif {!$menschAnz} {
          streitGlueckwunsch $computerAnz
        } else {
          return 0
        }
      } else {
        if {$fuelle(hand) > 0} {return 0}
        if {[string match *,kompl $stockReihe($patArt)]} {
          global teilStapelUnterst stapelAnz

          set komplettAnz 0
          for {set aktStapel 0} {$aktStapel < $stapelAnz($patArt)} {incr aktStapel} {
            if {$fuelle($aktStapel) == 13 && !$teilStapelUnterst($aktStapel)} {
              incr komplettAnz
            } elseif {($fuelle($aktStapel))} {
              return 0
            }
          }
          if {$komplettAnz && $komplettAnz != 4*$kartenSatz($patArt)} {return 0}
        } else {
          for {set aktSatz 0} {$aktSatz < $kartenSatz($patArt)} {incr aktSatz} {
            foreach aktFarbe {c h p k} {
              if {$fuelle($aktSatz,$aktFarbe) < 13} {return 0}
            }
          }
        }
        if {!$inDemo} {
          global zugNr vorschlagZaehler mogelZaehler
          if {$mogelZaehler > 0} {
            tadel $zugNr $mogelZaehler
          } else {
            glueckwunsch $zugNr $vorschlagZaehler
          }
        }
      }
      starteSpiel 0
      return 1
    }
    proc autoStock {aktStapel} {
      global stockBasis patArt stapel fuelle verdeckt aktuellErste
      
      # Werden denn ueberhaupt Karten automatisch auf den Stock geschoben?
      if {$stockBasis($patArt) != "erste"} {return 0}

      set gefunden 0
      while {42} {
        set aktFuelle $fuelle($aktStapel)
        if {$aktFuelle <= $verdeckt($aktStapel)} {return $gefunden}
        
        set oberste $stapel($aktStapel,[expr $aktFuelle-1])
        if {$aktuellErste != [string index $oberste 0]} {return $gefunden}
        
        if {[karteAufStock $oberste $aktStapel 0 0] != 1} {return $gefunden}
        
        set gefunden 1
      }
    }
    proc bildeHand {} {
      global kartenSatz stapelVerdeckt stapelAnz patArt aktuellErste streitArt \
             stapel verdeckt fuelle teilStapelUnterst fuelle                \
             exist stockBasis flaeche aktuellerGrenzWert talonAbraeumbar

      update idletask

      set maxGrund 0
      for {set aktStapel 0} {$aktStapel < $stapelAnz($patArt)} {incr aktStapel} {
        set fuelle($aktStapel) 0

        set verdeckt($aktStapel)          $stapelVerdeckt($patArt,$aktStapel)
        set teilStapelUnterst($aktStapel) $stapelVerdeckt($patArt,$aktStapel)
        if {$maxGrund < $verdeckt($aktStapel)} {
          set maxGrund $verdeckt($aktStapel)
        }
      }

      for {set aktSatz 0} {$aktSatz < $kartenSatz($patArt)} {incr aktSatz} {
        foreach aktFarbe {c h p k} {
          set fuelle($aktSatz,$aktFarbe) 0
        }
      }
      if {$stockBasis($patArt) == "erste"} {
        set karte $stapel(hand,[incr fuelle(hand) -1])
        set aktStock 0,[string index $karte 1]

        # Verteilen, Anlegen und Aufdecken der Karte an der gewuenschten Stelle.
        verteilComic hand 0 $aktStock 0
        maleKarte    $karte neu $aktStock
        steckInStock $aktStock $karte 1
        set aktuellErste       [string index $karte 0]
        set aktuellerGrenzWert [kartenWert $karte]
      } else {
        set aktuellErste $stockBasis($patArt)
        set aktuellerGrenzWert [kartenWert $stockBasis($patArt)]
      }

      if {$exist($patArt,talon) > 0} {
        set fuelle(talon)    0
        set fuelle(talon2)   0
        set verdeckt(talon)  0
        set verdeckt(talon2) 0
      }

      if {$exist($patArt,strafe) > 0} {
        # Aufbau des Strafstapels.
        set fuelle(strafe)    0
        set fuelle(strafe2)   0
        set verdeckt(strafe)  0
        set verdeckt(strafe2) 0

        verteilComic hand 0 strafe 0
        for {set aktI 0} {$aktI < $exist($patArt,strafe)} {incr aktI} {
          karteVonHandNach hand strafe
        }
        if {$streitArt($patArt)} {
          verteilComic hand2 0 strafe2 0
          for {set aktI 0} {$aktI < $exist($patArt,strafe)} {incr aktI} {
            karteVonHandNach hand2 strafe2
          }
        }
        # Evtl. werden Karten automatisch auf den Stock geschoben.
        autoStock strafe
      }

      for {set aktStapel 0} {$aktStapel <= $maxGrund} {incr aktStapel} {  
        geben ""
      }

      if {$exist($patArt,talon) > 0 && $talonAbraeumbar($patArt)} {
        handNachTalon hand talon 0
        if {$streitArt($patArt)} {
          handNachTalon hand2 talon2 0
        }
      }
    }
    proc initPatience {} {
      global auto_path patiencePath \
             veraendern gemerkt marke zugNr fuelle streitGegner

      set auto_path "$patiencePath $auto_path"

      set veraendern    0
      set gemerkt       0
      set marke         0
      set zugNr        -1
      set streitGegner computer

      # fuelle(hand) wird hier tricksigerweise mit 1 initialisiert, damit die Hand
      # nicht beim erstenmal kurzfristig leer dargestellt wird.
      set fuelle(hand) 1

      # Den Zufallszahlengenerator warmlaufen lassen.
      initr [pid]

      # Die Spielregeln in der entsprechenden Directory einlesen.
      liesSpiel
    }
    # 0. Die nicht ganz unwichtigen Vorarbeiten...
    initPatience
    # 1. ...baue die Spielflaeche auf...
    mkFlaeche
    mkMenue
    fuellFlaeche
    # 2. ...und gib das erste Mal
    starteSpiel 0
