/*
 * tkTkwm.h --
 *
 *	This file defines the data structures for tkTkwm.c.
 *
 * Copyright (c) 1993 Eric Schenk.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL ERIC SCHENK BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ERIC
 * SCHENK HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ERIC SCHENK SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND ERIC SCHENK HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * $Header: /usr/src/local/tcl/tkwm/RCS/tkTkwm.h,v 1.19 1994/12/20 17:05:22 schenk Exp schenk $"
 */

/*
 * Information necessary to track changes in colormaps on watched windows
 * Very stripped down version of ctwm code.
 */

typedef struct TkwmColormap
{
    Colormap c;                 /* Colormap id */
    int state;                  /* install(ability) state */
    unsigned long install_req;  /* request number which installed it */
    Window w;                   /* window causing load of color table */
    int refcnt;
} TkwmColormap;

#define CM_INSTALLABLE          1
#define CM_INSTALLED            2
#define CM_INSTALL              4

typedef struct ColormapWindow
{
    Window w;                    /* Window id */
    TkwmColormap *colormap;      /* Colormap for this window */
    struct plug *plug;	         /* Last leader to install this window */
    int visibility;              /* Visibility of this window */
    int refcnt;                  /* Number of lists it appears in */
} ColormapWindow;

typedef struct Colormaps
{
    ColormapWindow **cwins;     /* current list of colormap windows */
    int number_cwins;           /* number of elements in current list */
    char *scoreboard;           /* conflicts between installable colortables */
} Colormaps;

#define ColormapsScoreboardLength(cm) (((cm)->number_cwins * ((cm)->number_cwins - 1) / 2)+1)

/*
 * A data structure of the following type is kept for each plug widget:
 */

typedef struct plug {
  Tk_Window tkwin;
  Display *display;	/* X's token for the window's display. */
  Tcl_Interp *interp;	/* Interpreter associated with widget. */
  Tk_3DBorder background; /* Background color (used for shaped widgets). */
  
  /*
   * Information used when displaying widget:
   */
  
  int updatePending;    /* Non-zero means a call to DisplayPlug
	 		 * has already been scheduled. */
  int sendconfigPending;
  
  Tk_Window frame;      /* TK widget to be used as location of outer frame of decoration for client */
  
  Window root;          /* The root window for this client */
  
  Window window;        /* client window plug is managing */
  char reparented;	/* true iff the client window is reparented */
  char destroyed;	/* true iff the client window is destroyed */
  char ismapped;        /* true iff the client window is mapped */
  int setGrid;		/* boolean to turn on gridded geometry */
  int isgridded;	/* true iff the clint window currently gridded */
  char *state;          /* current state of the window:
                         * normal, iconic, or withdrawn
                         */
  int iconwin;		/* Icon window */

  char *name;           /* Client name */
  char *icon_name;      /* Client icon name */
  char geometry[50];	/* Client's current geometry as a string */
  int fx, fy;		/* final x and y locations */
  XClassHint class;     /* Client class specifiers */
  Window transient_for; /* Window client is a transient for */
  char **argv;           /* Command to restart client */
  int argc;
  XTextProperty client_machine;
  char **client_machine_l;
  int num_client_machine;
  Atom *protocols;      /* WM_PROTOCOLS list */
  int num_protocols;
  Colormaps cmaps;
  
  XWindowAttributes winatts;
  XWMHints WMhints;
  long supplied_return;
  XSizeHints normalhints;
  XSizeHints old_normalhints;
} Plug;

struct TkwmOutline {
  int x;
  int y;
  int w;
  int h;
};

/*
 * External and global variables
 */

XContext plugContext;
XContext plugWinContext;
XContext colormapContext;
extern XContext tkWindowContext;

/*
 * Some useful to know global bits of information.
 */

Window rootWindow;	/* the root window id */
Display *dpy;		/* the display we manage */
int screenHeight;	/* the height of the screen */
int screenWidth;	/* the width of the screen */
GC DrawGC;		/* GC for drawing resize and move borders */

