#
# Copyright (c) 1993 Eric Schenk.
# All rights reserved.
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
# 
# IN NO EVENT SHALL ERIC SCHENK BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ERIC
# SCHENK HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ERIC SCHENK SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND ERIC SCHENK HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

# Create the top part of the heirarchy for an internal window with decorations
# to look like a client. This returns the internal frame within which the
# client should be completed and packed.

proc create_iwindow {tkwin resource class} {
    global window_list
    # this is the array that will hold this windows private information
    upvar "#0" $tkwin data

    toplevel $tkwin -class Client

    # don't display the window yet!
    wm withdraw $tkwin

    lappend window_list $tkwin

    # build a dummy frame (never mapped) that we use to access application
    # specific resources
    set data(res_name) $tkwin.$resource
    client $data(res_name) $class
    pack $data(res_name) -fill both -expand yes
    set data(decoration) $data(res_name).decoration
    set data(root) $tkwin

    # catch the destruction of the client and get rid of related data structures.
    bind $tkwin <Destroy> "deregister $tkwin; \
	global window_list $tkwin; \
	set_remove window_list $tkwin; unset $tkwin"

    # do the decorations
    handleError {
	set inside [tkwm_client_frame $data(decoration) \
			-title [wm title $tkwin]]
    } {
	# The users decoration command screwed up.
	# Do a very quick and dirty packing.
	catch {destroy $data(decoration)}
        set inside [frame $data(decoration) \
			-relief ridge \
			-border 5 \
			-cursor top_left_arrow]
        tkerror "User decoration code failed"
    }
    pack $data(decoration) -expand 1 -fill both

    # bind the events for the frame. 
    # Must do this before the inside part of the frame is created, otherwise
    # events will be caught on internal parts of frame as well.
    noisyCatch {frame_bindings $tkwin}

    # return the place to finish the construction of this internal client
    return $inside
}

# request a mapping of an internal window created with create_iwindow
proc imap_request {tkwin iconic} {
    global tkwm_priv
    global $tkwin
    
    # if the window was destroyed before we got here, just skip everything.
    if ![winfo exists $tkwin] {return}
    set ${tkwin}(state) "withdrawn"

    # Internal windows are assumed to never be transient have no grouping.
    # We also assume it should apear in the global room.
    register transient 0 $tkwin
    register group None $tkwin
    register room global $tkwin

    if {[wm state $tkwin] == "iconic"} {
	# transition from iconified to normal
	deiconify $tkwin
    } else {
	# transition from withdrawn to normal
	if !$iconic {
            # transition from withdrawn to normal
	    # WARNING: the window can disappear during this next procedure
	    # make sure geometry computations complete
 	    update idletasks
	    if [winfo exists $tkwin] {deiconify $tkwin}
	} else {
            # transition from withdrawn to iconic
	    # windows that are iconic on startup better be sure to specify
	    # their location, or they end up at +0+0
#	    wm geometry $tkwin [$tkwin.plug geometry]
	    # make sure geometry computations complete
 	    update idletasks
	    if [winfo exists $tkwin] {iconify $tkwin}
	}
    }

    # Make the changes display right now
    update
}
