proc tkwm_restart {} {
    global window_list
    
    # delete any existing windows
    if {[info exists window_list]} {
	foreach w $window_list {
		# just in case the window list is corrupted.
		noisyCatch { destroy $w }
	}
    }
    
    # make sure the deletions take effect before we redecorate
    update
    update idletasks
    
    # Read the option databases for changes
    #    initialize_prefs
    
    # decorate all the windows
    set window_list {}
    create_rooms
    update
    update idletasks
    foreach w [tkwm unmanaged] {
	map_request startup $w
    }
}

proc display_client {win} {
    global tkwm_priv
    upvar "#0" $win data

    if {[wm state $win]!="normal"} {
	# map the client if it should currently be visible and it's not.
	$data(res_name) map
	restack $data(res_name) Above None
	# this may not be a client formatted widget
	catch {$win.plug sendconfig}
	update idletasks
    }
    # this may not be a client formatted widget
    catch {$win.plug configure -state normal}
}

proc display_icon {win} {
    global tkwm_priv
    upvar "#0" $win data

    # create the icon window if we need it
    if ![winfo exists $data(res_name).icon] {create_icon_window $win}

    # map the icon window if it should currently be visible.
    if {[wm state $data(icon)]!="normal"} {
	restack $data(icon) Above None
        $data(icon) map
    }
    # this may not be a client formatted widget
    catch {$win.plug configure -state iconic}
}


# These no longer differ from the distributed code...

#proc compute_size_and_position {startup win} {
#    if {!$startup && ![$win.plug info USPosition] && ![$win.plug info transient_for]} {
#	# user positioned windows always end up in the global room.
#	# Compute the users requested position.
#	# WARNING: The window can disappear during this procedure.
#	set pos [user_pos $win]
#	# Check if the window is still around and display it the requested position
#        if [winfo exists $win] {wm geometry $win $pos}
#    }
#}
#
#proc deregister {win} {
#    global tkwm_registry $win tkwm_priv
#    
#    if {[info exists tkwm_registry($win)]} {
#	foreach t $tkwm_registry($win) {
#	    set i $t,$tkwm_registry($win:$t)
#	    set_remove tkwm_registry($i) $win
#	    unset tkwm_registry($win:$t)
#	}
#	unset tkwm_registry($win)
#	catch {unset $win}
#    }
#}


proc iconify {win} {
    upvar "#0" $win data
    wset_withdraw iconic [followers_list [immediate_followers_list $win]]
    # unmap the client window
    catch {
	if {[wm state $win]=="normal"} {
	    # ask the manager to unmap this window
	    $data(res_name) unmap
	}
	$win.plug configure -state iconic
    }
    # map the icon window
    # we only change the leader to an iconified state marker
    # since we want to be able to restore windows correctly on deiconify
    set data(state) iconified
    display_icon $win
}

proc wset_withdraw {state wins} {
    foreach i $wins {
        upvar "#0" $i data
	# this may not be a client formatted widget
        catch {
	    if {[wm state $i]=="normal"} {
		# ask the manager to unmap this window
		$data(res_name) unmap
	    }
            $i.plug configure -state $state
        }
	# this may not be a client formatted widget
        catch {
	    if {[wm state $data(icon)]=="normal"} {
		# ask the manager to unmap this window
		$data(icon) unmap
	    }
        }
	# add on a "withdrawn" tag to the state
#BB: changed ${i} to $data
#BB: added check to see if window is already withdrawn
	if {![string match w_* $data(state)]} {
	    set data(state) "w_[set data(state)]"
	}
    }
}

# These functions used restack, raise, or lower, so they had to be changed

# This code is so complicated because it needs to deal with the
# gravity of the configured window correctly.
# I could have put this in the core, but that would have precluded
# this code eventually paying attention to maximum and minimum window
# sizes and such things.
proc configureClient {W w h X Y d S} {
    if {"$w" != "??" && "$h" != "??" && $w>="0" && $h>="0"} {set size 
"${w}x$h"}
    if {"$X" != "??" && "$Y" != "??"} {set x $X; set y $Y}
    set frame [lindex [$W config -frame] 4]
    # instead of doing an update this code should compute the
    # size from the plug information. This avoids resizing before
    # moving, and also resizing only to resize smaller/larger to
    # meet max/min thresholds.
    if [info exists size] {wm geometry $frame $size; update idletasks}
    set w [winfo width $frame.plug]
    set h [winfo height $frame.plug]
    if {[info exists x] && [info exists y]} {
	switch [$W info win_gravity] {
	    "1" {
	       set x "+$x"
	       set y "+$y"
	    }
	    "3" {
	       set x "-[expr [winfo screenwidth $frame]-($x+$w)]"
	       set y "+$y"
	    }
	    "7" {
	       set x "+$x"
	       set y "-[expr [winfo screenheight $frame]-($y+$h)]"
	    }
	    "9" {
	       set x "-[expr [winfo screenwidth $frame]-($x+$w)]"
	       set y "-[expr [winfo screenheight $frame]-($y+$h)]"
	    }
	}
	wm geometry $frame $x$y
    }
    if {"$d" != "??" && "$S" != "??"} {
      update idletasks
      restack $frame $d $S
    }
    $W sendconfig
    update idletasks
}

proc guarded_raise {w event} {
    global tkwm_priv
    
    set tkwm_priv(guard) 0
    bind all $event {global tkwm_priv; set tkwm_priv(guard) 1}
    restack $w Above None
    # force the raise redraws to finish
    update
    update idletasks
    bind all $event {}
    
    return $tkwm_priv(guard)
}

proc simpleManager {name} {
    global tkwm_priv
    if {[lsearch -exact $tkwm_priv(managers) $name] == -1} {
	lappend tkwm_priv(managers) $name
    }
    proc $name {command win} {
	switch $command {
	    map {restack $win Above None; wm deiconify $win}
            unmap {wm withdraw $win}
            remove {}
	    refresh {}
	}
    }
}

proc cursor::popup {button varindex} {
    global tkwm_priv use_default
    if !$use_default($varindex) {
        if [string match [wm state .cursor] normal] {
	    wm withdraw .cursor
        } else {
            set tkwm_priv(varindex) $varindex
            wm geometry .cursor +[winfo rootx $button]+[expr {[winfo rooty 
$button]+[winfo height $button]}]
            restack .cursor Above None
            wm deiconify .cursor
       }
   }
}


simpleManager tkwmDefaultSimpleManager


tkwm_widget::setdefaults frame client {
    {-manager manager Manager tkwmDefaultClientManager}
    {-opaqueMove opaqueMove OpaqueMove 0}
    {-opaqueResize opaqueResize OpaqueResize 0}
    {-constrained constrained Constrained 0}
    {-use_WM_STATE use_WM_STATE Use_WM_STATE 1}
    {-popup popup Popup 0}
}


proc client::config-popup {var option} {}


proc compute_size_and_position {startup win} {
    if {!$startup && ![$win.plug info USPosition] && ![$win.plug info transient_for]} {
	# user positioned windows always end up in the global room.
#	register room global $win
	# Compute the users requested position.
	# WARNING: The window can disappear during this procedure.
#	if {[option get $win popup Popup]} {
#	    set pos [popPos $win]
#	} {
	    set pos [user_pos $win]
#	}
	# Check if the window is still around and display it the requested position
        if [winfo exists $win] {wm geometry $win $pos}
    }
}

proc popPos {win} {
    return +[expr {[winfo . screen width] - ([winfo $win width] / 2)}]+[expr 
{[winfo . screen height] - ([winfo $win height] / 2)}]
}
