##
## Help.tcl
##
## This file contains the help commands of the tkined editor.
##
## Copyright (c) 1993, 1994
##
## J. Schoenwaelder
## TU Braunschweig, Germany
## Institute for Operating Systems and Computer Networks
##
## Permission to use, copy, modify, and distribute this
## software and its documentation for any purpose and without
## fee is hereby granted, provided that this copyright
## notice appears in all copies.  The University of Braunschweig
## makes no representations about the suitability of this
## software for any purpose.  It is provided "as is" without
## express or implied warranty.
##

proc Help::general { editor } {
    set w [$editor toplevel]
    Dialog::acknowledge $w.canvas \
	"This is the tkined -- a tk based interactive network editor." \
	"" \
	"This version has been written based on the original ined version" \
	"that was build on top of the Unidraw/Interviews framework. Many" \
	"thanks to the developers of the original version, Thomas Birke" \
	"and Hinnerk Ruemenapf."\
	"" \
	"Also many thanks to Guntram Hueske (hueske@ibr.cs.tu-bs.de) who" \
	"wrote the stripchart and barchart code in C to make it faster." \
	"And of course, many thanks to Erik Schoenfelder for his support" \
	"and ideas that improved tkined (and scotty) a lot. Frank Dippel" \
	"(dippel@ibr.cs.tu-bs.de) has taken over the job of running into" \
	"all the obscure bugs while he uses tkined as a front end to a" \
	"network simulator." \
	"" \
	"And I would also like to thanks all those people that have spend" \
	"some of their time to play with tkined. I really appreciate all" \
	"the bug reports and suggestions I have received." \
	"" \
	"There is a mailing list you might join to report bugs or suggestions"\
	"or to get the latest news about tkined. To join, send a message to:" \
	"" \
	"          tkined-request@ibr.cs.tu-bs.de" \
	"" \
	"The archive of the mailing list and much more is available on the" \
	"World Wide Web:" \
	"" \
	"          http://www.cs.tu-bs.de/ibr/projects/nm/tkined/welcome" \
	"" \
	"Juergen Schoenwaelder (schoenw@ibr.cs.tu-bs.de)"
}

proc Help::status { editor } {
    global tkined_version
    global tkined_debug
    global auto_path

    set w [$editor toplevel]
    set text ""
    set total 0
    set cmds [info commands]

    foreach id [$editor retrieve] {
	set type [$id type]
	if {![info exists count($type)]} { set count($type) 0}
	incr count($type)
	incr total
    }
    if {[info exists count]} {
        foreach t [lsort [array names count]] {
	    append text "\n# of $t objects: $count($t)"
        }
    }
    if {$tkined_debug} {
	append text "\n\ndebugging mode is switched on.\n"
	append text "\nauto_path: $auto_path"
    }
    Dialog::acknowledge $w.canvas \
	"Status information for tkined version $tkined_version:" \
	"" \
	"file: [$editor filename]" \
	"directory: [$editor dirname]" \
	"" \
	"total # of open views: [llength [winfo children .]]" \
	"total # of objects: $total" \
	$text
}

proc Help::key_bindings { editor } {
    set w [$editor toplevel]
    Dialog::browse $w.canvas \
	"Inside of the canvas, the following key bindings apply:" { 
	"middle mouse button : move selected objects"  
	"shift middle mouse button : move the whole canvas"  
	"right mouse button : select objects (deletes current selection)"  
	"shift right mouse button : add objects to the current selection"  
	""  
	"The following tool specific bindings exist:"  
	""  
	"Select"  
	""  
	"left mouse button : select nearest object (deletes current selection)"  
	"shift left mouse button : add nearest object to the current selection"  
	""  
	"Move"  
	""  
	"left mouse button : move selected objects"  
	""  
	"Text"  
	""  
	"left mouse button : place the input cursor on the canvas"  
	""  
	"Alter"  
	""  
	"left mouse button on icon:  popup a menu to select the label type"  
	"left mouse button on label: alter the label contents"  
	"left mouse button on chart corner: resize stripcharts and barcharts"  
	"left mouse button on text:  alter text objects"  
	"left mouse button on network:  alter network length"  
	""  
	"Node"  
	""  
	"left mouse button : put a new node object on the canvas"  
	""  
	"Network"  
	""  
	"left mouse button : define startpoint and endpoint of a network object"  
	"shift left mouse button : mark intermediate points of a network object"  
	""  
	"Link"  
	""  
	"left mouse button : define startpoint and endpoint of a link object"  
	"shift left mouse button : mark intermediate points of a link object"  
	""  
	"Group"  
	""  
	"left mouse button : put a new group object on the canvas"
    }
}

proc Help::manpage { editor title } {
    set w [$editor toplevel]

    set txt ""
    if {[catch {
	set f [open "| man $title"]
    } err]} {
	Dialog::acknowledge $w.canvas "Can not load man page for $title."
	return
    }

    while {![eof $f]} {
	gets $f line
	regsub -all {_} $line "" line
	regsub -all {.} $line "" line
	lappend txt "$line  "
    }
    catch {close $f} 

    Dialog::browse $w.canvas $txt 
}
