/*
 * xvipc_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `xvipc.G'.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/font.h>
#include <xview/notify.h>
#include "xvipc_ui.h"

/* External function */
extern int xvipcInit(/* char *appName */);
extern int xvipcAddSender( /* int index, char *senderName */);
extern char *xvipcSend( /* int index, char *command */);
extern void xvipcQuit( /* void */);

/* In file functions */
static Notify_value destroy_proc(Frame frame, Destroy_status status);

/*
 * Global object definitions.
 */
xvipc_main_objects	*Xvipc_main;
Display *curdpy;                /* Current display */

/* Static file data */
static char cmdbuffer[2048];           /* Used for displaying messages */

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

main(argc, argv)
int argc;
char **argv;
{
  Xv_Font termfont;
  /*
   * Initialize XView.
   */
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
  INSTANCE = xv_unique_key();
  if (argc != 2) {
    fprintf(stderr, "Usage: xvipc receiverName\n");
    exit(-1);
  }

  /*
   * Initialize user interface components.
   * Do NOT edit the object initializations by hand.
   */
  Xvipc_main = xvipc_main_objects_initialize(NULL, NULL);

  /* fetch the current display */
  curdpy = (Display *)xv_get(Xvipc_main->main, XV_DISPLAY);
  /* Call the xview tclipc initialization */
  if (xvipcInit(argv[1]) != 0) {
    fprintf(stderr, "tclipc initialization failed.\n");
    exit(-1);
  }
  /* Set the text font to fixed */
  termfont = (Xv_Font)xv_find(Xvipc_main->textout,
			      FONT, FONT_NAME, "fixed", NULL);
  xv_set(Xvipc_main->textout, TEXTSW_FONT, termfont, NULL);
  /* Set the receiver name label */
  xv_set(Xvipc_main->receiverName, PANEL_LABEL_STRING, argv[1], NULL);
  notify_interpose_destroy_func(Xvipc_main->main, destroy_proc);
  /* Turn on RPC in notifier */
  notify_enable_rpc_svc(TRUE);
	
	/*
	 * Turn control over to XView.
	 */
	xv_main_loop(Xvipc_main->main);
	exit(0);
}

#endif

/************************************************************************/
static Notify_value destroy_proc(frame, status)
Frame frame;
Destroy_status status;
{
  if (status == DESTROY_CHECKING) {
    textsw_reset(Xvipc_main->textout, 0, 0);
    return(NOTIFY_DONE);
  }
  else
    return(notify_next_destroy_func(frame, status));
}

/************************************************************************/
/* Show a string in the output area */
void xviewShowString(cmd, result)
char *cmd;
char *result;
{
  Textsw_index charsinserted;

  if (cmd == NULL || result == NULL) 
    return;

  sprintf(cmdbuffer, "%s\n%s\n", cmd, result);
  charsinserted = textsw_insert(Xvipc_main->textout, 
				cmdbuffer, strlen(cmdbuffer));
}

/************************************************************************/
/*
 * Notify callback function for `screate'.
 * Create a new sender.
 */
void
screate(item, event)
Panel_item item;
Event *event;
{
  xvipc_main_objects *ip = 
    (xvipc_main_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  char senderName[64];
  int nrows;
	
  strcpy(senderName, (char *)xv_get(ip->sname, PANEL_VALUE));
  if (strlen(senderName) == 0) {
    fprintf(stderr, "No sender name.\n");
    return;
  }
  /* Last item */
  nrows =(int)xv_get(ip->sendset, PANEL_NCHOICES, NULL);
  if (xvipcAddSender(nrows, senderName) != 0) {
    return;
  }

  xv_set(ip->sendset, 
	 PANEL_CHOICE_STRING, nrows, senderName, NULL);
  xv_set(ip->sendset, PANEL_VALUE, nrows, NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */
	/* gxv_end_connections */

}

/************************************************************************/
/*
 * Notify callback function for `test'.
 */
void
do_beep(item, event)
Panel_item item;
Event *event;
{
  xvipc_main_objects *ip = 
    (xvipc_main_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
  XBell(curdpy, 50);	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */
	/* gxv_end_connections */
}

/************************************************************************/
/*
 * Notify callback function for `sendbutton'.
 */
void
send(item, event)
Panel_item item;
Event *event;
{
  xvipc_main_objects *ip = 
    (xvipc_main_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  int index;
  int charsinserted;
  char *result;
  char command[128];

  index = (int)xv_get(ip->sendset, PANEL_VALUE, NULL);

  strcpy(command, (char *)xv_get(ip->sendtext, PANEL_VALUE, NULL));
  result = xvipcSend(index, command);
  xviewShowString(command, result);
	/* gxv_start_connections DO NOT EDIT THIS SECTION */
	/* gxv_end_connections */

}

/*
 * Notify callback function for `quitbutton'.
 */
void
doQuit(item, event)
Panel_item item;
Event *event;
{
	xvipc_main_objects *ip = (xvipc_main_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	xvipcQuit();
	/* gxv_start_connections DO NOT EDIT THIS SECTION */
	/* gxv_end_connections */

}
