# Tk IPC demo script
global smenu
global demoName
set smenu .frame7.menubutton1.m
set demoName "tktest"
# an array of sender/handle pairs
global senderhandles

proc ipcDemoInit {demoName} {
  global receivername senderhandles

  setsender "none"
# make a new receiver
  if { [catch {set newhandle [receiver new $demoName]} error] != 0} {
    ipcError $error
    return
  }
# store the new handle
  set senderhandles($demoName) $newhandle

# set the label on the screen
  set receivername $demoName
}

# Create a new sender.  Called when the create button is pushed.
proc createsender {} {
  global smenu senderhandles

  set sendername [.frame4.entry7 get]
  if { [catch {set newhandle [sender new $sendername]} error] != 0} {
    ipcError $error
    return
  }
  $smenu add command -label $sendername -command "setsender $sendername"
  set senderhandles($sendername) $newhandle
  setsender $sendername
}

#This causes the sender menu button to update.
proc setsender {sendername} {
  global currentsender

  set currentsender $sendername  
}

# send command
proc doSend {} {
  global senderhandles currentsender

  set command [.frame1.entry4 get]
  ipcResult [isend $senderhandles($currentsender) $command]
}

#An error message
proc ipcError {errormsg} {
  .frame3.message6 configure -text $errormsg
}

#Show response
proc ipcResult {msg} {
  .frame3.message6 configure -text $msg
}

#initialize the world
ipcDemoInit $demoName