/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <rpc/rpc.h>
#include <tclIPC.h>

bool_t xdr_cmdType(XDR *xdrs, cmdType *objp)
{
  if (!xdr_string(xdrs, objp, EVAL_SIZE)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t xdr_evalcmd_res(XDR *xdrs, evalcmd_res *objp)
{
  if (!xdr_int(xdrs, &objp->errno)) {
    return (FALSE);
  }
  if (!xdr_cmdType(xdrs, &objp->cmd)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t	xdr_Port(XDR* xdrs, Port *objp)
{
  if (!xdr_string(xdrs, &objp->hostName, ~0))
  {
    return (FALSE);
  }
  if (!xdr_string(xdrs, &objp->appName, ~0))
  {
    return (FALSE);
  }
  if (!xdr_int(xdrs, &objp->portNumber))
  {
    return (FALSE);
  }
  return (TRUE);
}

bool_t xdr_PortArray(XDR *xdrs, PortArray *objp)
{
  if (!xdr_array(xdrs, (char **)&objp->portArray,
		 (u_int *)&objp->numberOfPorts, ~0,
		 sizeof(Port), xdr_Port))
  {
    return (FALSE);
  }
  if (!xdr_int(xdrs, &objp->numberOfPorts))
  {
    return (FALSE);
  }
  return (TRUE);
}


void DestroyPortArray(PortArray* thePortArray)
{
  int	arrayElement = 0;
  Port*	thePort = (Port*) NULL;
  
  if (thePortArray == (PortArray*)NULL)
    return;
  for (arrayElement = 0;		      /* Traverse list of Ports in array, freeing space one by one */
       arrayElement < thePortArray->numberOfPorts;
       arrayElement++)
  {
    thePort = &(thePortArray->portArray[arrayElement]);		    /* Point to the current Port in the array */
    if (thePort != (Port*)NULL)					    /* Is this a valid Port*? */
    {								    /* Yes, free space taken by each element of the Port* */
      if (thePort->appName)
	free(thePort->appName);
      if (thePort->hostName)
	free(thePort->hostName);
    }
  }								    /* end for... */
  if (thePortArray->portArray != (Port*)NULL)
  {
    free(thePortArray->portArray);				    /* Now that each Port's fields have been freed, free Port's */
    thePortArray->portArray = (Port*)NULL;			    /* Re-initialize the PortArray passed in as argument */
    thePortArray->numberOfPorts = 0;
  }
  return;
}								    /* end function DestroyPortArray */


void DestroyPort(Port* thePort)
{
  if (thePort != (Port*)NULL)	       /* Make sure a non-NULL Port* was passed in */
  {
    if (thePort->hostName != (char*)NULL)
      free(thePort->hostName);
    if (thePort->appName != (char*)NULL)
      free(thePort->appName);
    free(thePort);
  }
  return;	                      /* end function DestroyPort */
}
