/*
 * winmain.c
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include <windows.h>
#include "wndproc.h"
#include "util.h"


extern "C" int __argc;
extern "C" char **__argv; 


#ifdef __cplusplus
#   define EXTERN extern "C"
#else
#   define EXTERN extern
#endif
EXTERN HWND __far __pascal CreateTerminal(HANDLE);
EXTERN unsigned int FAR PASCAL TkMain(int, char **);

int PASCAL 
WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lll, int nCmdShow)
{
    HWND hTerm;
    WPARAM result;
    HINSTANCE hLib;
    HHOOK hHook;

   if(hPrevInstance) return 1;
    SetAppInstance(hInstance);
    SetMessageQueue(64);
#ifdef KANJI
    hLib = LoadLibrary("kxlib.dll");
#else
    hLib = LoadLibrary("lxlib.dll");
#endif
    hHook = SetWindowsHookEx(WH_MOUSE, 
    	    (HOOKPROC)GetProcAddress(hLib, (LPCSTR)"DeliverEnterLeave"), 
    	    hInstance, (HTASK)NULL); 
    SetHookDeliverEL(hHook);
    FreeLibrary(hLib);
    
    if (!hPrevInstance) {
	RegisterWidgetClass(hInstance);	
	RegisterTopLevelClass(hInstance);
	RegisterTerminalClass(hInstance);
    } 

    hTerm = CreateTerminal(hInstance);  
    SetTbWindow(hTerm);
    ShowWindow(hTerm, SW_MINIMIZE);
    UpdateWindow(hTerm);
    result = TkMain(__argc, __argv);
    return result;
}

