/*-
 * Copyright (c) 1993, 1994 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef MIDIDEVICE_H
#define MIDIDEVICE_H

#include "Song.h"
#include "SMPTE.h"

typedef void (*MidiDeviceCallback)(const Event *e);
typedef enum {SMFTIME, SMPTETIME} TimeType;

class MidiDevice {
public:
	MidiDevice();
	MidiDevice(const char *dev);
	MidiDevice(const MidiDevice &md);
	virtual ~MidiDevice();

	virtual int Play(Song *s, int r = 0) = 0;
	virtual int Record(Song *rec_song, Song *play_song = 0,
	    int r = 0) = 0;
	virtual int Stop(void) = 0;
	virtual int Wait(void) = 0;
	virtual int GetTime(TimeType tt, void *time) = 0;

	void SetPlayCallback(MidiDeviceCallback pcb) {play_callback = pcb;}
	void SetRecordCallback(MidiDeviceCallback rcb) {record_callback = rcb;}
	void SetRepeat(int r) {repeat = r;}
	void SetMidiThru(int mt) {midithru = (mt != 0);}
	const char *GetName(void) const {return (name);}
	const char *GetError(void) const {return (error);}
	int GetRepeat(void) const {return (repeat);}
	int GetMidiThru(void) const {return (midithru);}
	MidiDeviceCallback GetPlayCallback(void) const {return (play_callback);}
	MidiDeviceCallback GetRecordCallback(void) const
	    {return (record_callback);}

	void SetName(const char *dev);
	void SetError(const char *err);
private:
	char *name;
	char *error;
	MidiDeviceCallback play_callback;
	MidiDeviceCallback record_callback;
	int repeat;
	int midithru;
};
#endif
