/*-
 * Copyright (c) 1993, 1994 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef MPU401THREAD_H
#define MPU401THREAD_H

#ifndef USE_PTHREADS
You must define USE_PTHREADS if you are using the MPU401Thread device interface
#else
#include <pthread.h>
#endif

#include "MidiDev.h"


const int MaxEventSize = 256;

class MPU401Thread : public MidiDevice {
	friend ostream &operator<<(ostream &os, const MPU401Thread &mpu);
	friend void *PlayThread(void *);
	friend void *RecordThread(void *);
public:
	MPU401Thread();
	MPU401Thread(const char *dev);
	virtual ~MPU401Thread();

	virtual int Play(Song *s, int r = 0);
	virtual int Record(Song *rec_song, Song *play_song = 0, int r = 0);
	virtual int Stop(void);
	virtual int Wait(void);
private:
	void *PlayLoop(void);
	int WriteEvents(void);
	void RecordLoop(void);

	pthread_t thread;
	pthread_cond_t finished_cond;
	pthread_mutex_t finished_mutex;
	unsigned long last_play_time, last_rec_time;
	Event **curr_event;
	Song *play_song;
	Song *rec_song;
	int fd, finished;
	unsigned char last_record_rs;
};
#endif
