%token REAL
%token INTEGER
%token OPENPAREN
%token CLOSEPAREN
%token OPENCURLY
%token CLOSECURLY
%token NL

%left PLUS SUBTRACT
%left TIMES DIVIDE
%left UMINUS

%start lines
%%

lines:
	| lines line { printresult $2 }
	;

line:	NL
	| iexpr NL   {set $$ $1}
	| error NL
	;

iexpr:	INTEGER { set $$ [strip $1]}
	| iexpr PLUS iexpr { set $$ [evaluate $1 + $3] }
	| iexpr SUBTRACT iexpr { set $$ [evaluate $1 - $3] }
	| iexpr TIMES iexpr { set $$ [evaluate $1 * $3] }
	| iexpr DIVIDE iexpr { set $$ [evaluate $1 / $3] }
	| OPENPAREN iexpr CLOSEPAREN { set $$ $2 }
	;

%%


proc evaluate {x op y} {
	expr "$x $op $y"
}

proc printresult {x} {
	puts stderr "The value of the expression is $x"
}
	
proc strip {a} {
	string trimleft [string trimright $a \"] \"
}