%{
#include "y.tab.h"
%}

integer	[0-9]+
real	([0-9]*"."[0-9]+)
nl	\n

%%
"+"	{ yylval.string = yytext ; 
	  return PLUS; }
"-"	{ yylval.string = yytext ; 
	  return SUBTRACT; }
"*"	{ yylval.string = yytext ; 
	  return TIMES; }
"/"	{ yylval.string = yytext ; 
	  return DIVIDE; }
"("	{ yylval.string = yytext ; 
	  return OPENPAREN; }
")"	{ yylval.string = yytext ; 
	  return CLOSEPAREN; }
"{"	{ yylval.string = yytext ; 
	  return OPENCURLY; }
"}"	{ yylval.string = yytext ; 
	  return CLOSECURLY; }
{nl} 	{ yylval.string = yytext ; 
	  return NL; }
{real}	{ yylval.string = yytext ;
	  return INTEGER; }
{integer} { yylval.string = yytext;
            return INTEGER; }
%%
/* ----------------------------------------------------------------------------- */
/* Program to create a Tcl List of the lexical elements are their type IDs       */
/* This routine causes the lexer to generate a Tcl list of pairs                 */
/*       {lexical_element lexical_element_type}		                         */
/* Since curlys are list delimiters in Tcl, use names "opencurly" and "opencurly"*/
/* instead.                                                                      */

main () {
	int TokenType;

        while (TokenType = yylex()) {
	    switch(TokenType) {
	    case OPENCURLY:
	        printf("{\"opencurly\"  %d }\n",TokenType);
		break;
	    case CLOSECURLY:
                printf("{\"closecurly\" %d }\n",TokenType);
		break;
	    default:
	        printf("{\"%s\" %d }\n",yytext,TokenType);
		break;
	    }
	}
	return (0);
}







