/* ----------------------------------------------------------------------------- */
/* Program to create a Tcl List of the lexical elements are their type IDs       */
/* This routine causes the lexer to generate a Tcl list of pairs                 */
/*       {lexical_element lexical_element_type}		                         */
/* Since curlys are list delimiters in Tcl, use names "opencurly" and "opencurly"*/
/* instead.                                                                      */

main () {
	int TokenType;

        while (TokenType = yylex()) {
	    switch(TokenType) {
	    case OPENCURLY:
	        printf("{\"opencurly\"  %d }\n",TokenType);
		break;
	    case CLOSECURLY:
                printf("{\"closecurly\" %d }\n",TokenType);
		break;
	    default:
	        printf("{\"%s\" %d }\n",yytext,TokenType);
		break;
	    }
	}
	return (0);
}







