'\" t
.\"	%W%	%R% (Berkeley) %E%
.\"
.TH BYACC 1 "January\ 18,\ 1993"
.UC 6
.SH NAME
byacc \- an LALR(1) parser generator
.SH SYNOPSIS
.B byacc [ -CPcdlrtv ] [ -b
.I file_prefix
.B ] [ -p
.I symbol_prefix
.B ]
.I filename
.SH DESCRIPTION
.I byacc
reads the grammar specification in the file
.I filename
and generates an LR(1) parser for it.
The parsers consist of a set of LALR(1) parsing tables and a driver routine
written in the C or Perl programming languages.
.I byacc
normally writes the parse tables and the driver routine to the file
.IR y.tab.c ,
using the C programming language.
.PP
The following options are available:
.RS
.TP
\fB-b \fIfile_prefix\fP
The
.B -b
option changes the prefix prepended to the output file names to
the string denoted by
.IR file_prefix .
The default prefix is the character
.IR y.
.TP
.BR -C " or " -c
Use the C programming language (default).
.TP
.B -d
The \fB-d\fP option causes the header file
.IR y.tab.h
to be written (or
.IR y.tab.ph ,
for Perl).
.TP
.B -l
If the
.B -l
option is not specified,
.I byacc
will insert \#line directives in the generated code.
The \#line directives let the C compiler relate errors in the
generated code to the user's original code.
If the \fB-l\fP option is specified,
.I byacc
will not insert the \#line directives.
\&\#line directives specified by the user will be retained.
.TP
\fB-p \fIsymbol_prefix\fP
Change the prefix in symbols in the generated code to the string 
denoted by \fIsymbol_prefix\fP rather than the default of "\fIyy\fP".
Only symbols generated by \fIbyacc\fP are affected. Symbols in the
definition and user subroutine sections are not changed.
.IP
The \fIsymbol_prefix\fP can contain upper or lower case letters, 
digits, or _ (underline or underscore). It must start with either
an underline or a letter and must contain at least one lower case 
letter.
.IP
All lower case letters in the symbol prefix will be converted to 
upper case letters when defined values or typedefs are generated.
.IP
For example, if '\fB-p\fP ftp_' is specifed on the \fIbyacc\fP command
line:
.in +.5i
.TS
tab (/) box;
a | a .
old symbol/new symbol
=
YYABORT/FTP_ABORT
YYACCEPT/FTP_ACCEPT
YYBYACC/FTP_BYACC
YYDEBUG/FTP_DEBUG
YYSTYPE/FTP_STYPE
yyabort/ftp_abort
yyerrok/ftp_errok
yylex/ftp_lex
yylval/ftp_lval
yyparse/ftp_parse
.TE
.in -.5i
Note: The above list is not complete.
.TP
.B -P
Use the Perl programming language.  The output files have extensions
.I .tab.pl
and
.IR .tab.ph .
.TP
.B -r
The
.B -r
option causes
.I byacc
to produce separate files for code and tables.  The code file
is named
.IR y.code.c,
and the tables file is named
.IR y.tab.c.
In Perl mode, the file name extension is
.IR .pl ,
but the use of this option is not recommended.
.TP
.B -t
The
.B -t
option changes the preprocessor directives generated by \fIbyacc\fP
so that debugging statements will be incorporated in the compiled code.
.TP
.B -v
The
.B -v
option causes a human-readable description of the generated parser to
be written to the file
.IR y.output .
.RE
.PP
If the environment variable TMPDIR is set, the string denoted by
TMPDIR will be used as the name of the directory where the temporary
files are created.
.PP
In C mode, the user's code at the end of the
.SM BYACC
file is inserted before the
.I yyparse
subroutine,
but in Perl mode, it is appended to
.I yyparse
so it can contain the main program.
In Perl mode, there is no library, so the user must
supply the
.I yyerror
and
.I yylex
subroutines and a main program that calls
.IR yyparse .
For example:
.sp
.RS
.nf
%%
.I ...grammar...
%%
sub yyerror { print STDERR "$.: $@\en"; }
sub yylex { ... }
exit &yyparse;
.fi
.RE
.SH FILES
.PD 0
.TP 12
.B y.code.c
output parser code in C
.TP
.B y.tab.c
output parser code and tables in C or, if
.I \-r
switch specified, output parser tables in C
.TP
.B y.tab.h
defines for token names and, if
.I %union
used in grammar, the union definition for C parsers
.TP
.B y.code.pl
output parser code in PERL
.TP
.B y.tab.pl
output parser code and tables in PERL or, if
.I -r
switch specified, output parser tables in PERL
.TP
.B y.tab.ph
PERL assignment statements for token names
.TP
.B y.output
description of parser states, state transitions, and conflicts
.TP
.BR /tmp/byacc.aXXXXXX ",\ " /tmp/byacc.tXXXXXX ",\ " /tmp/byacc.uXXXXXX
temporary files
.TP
.B ./lib/libby.a
library containing simple versions of
.I main(\|)
(calls 
.I yyparse(\|)
then exits) and
.I yyerror(\|)
(prints message to
.B stderr
then returns)
.PD
.SH "SEE ALSO"
.BR flex "(1),\ " lex (1)
.LP
.I "Yacc: Yet Another Compiler-Compiler"
.br
Stephen C. Johnson
.br
Originally (?) published as Comp. Sci. Tech. Rep. No. 32. Bell 
Laboratories, July 1975. Reprinted in many different places.
.LP
.I "Introduction to Compiler Construction with UNIX"
.br
Axel T. Schreiner and H. George Friedman, Jr.
.br
Prentice Hall, 1985.
.LP
.I "lex & yacc, Second Edition"
.br
John R. Levine, Tony Mason, and Doug Brown
.br
O'Reilly & Associates, Inc., 1992.
.in +.5i
Possibly the best book yet on lex and yacc. (My opinion only. Others 
may disagree. - Rick Ohnemus)
.in -.5i
.LP
.I "comp.compilers monthly message and Frequently Asked Questions"
.br
Posted monthly in comp.compilers and news.answers USENET newsgroups.
.SH DIAGNOSTICS
If there are rules that are never reduced, the number of such rules is
reported on standard error.
.LP
If there are any LALR(1) conflicts, the number of conflicts is reported
on standard error.
.SH RESTRICTIONS
A symbol prefix specified using the \fB-p\fP switch must contain at least
one lower case character. This is to allow a distinction between variables,
defined values, and typedefs.
.SH BUGS
