/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwUtil.c,v 1.2 1994/11/11 22:35:59 aajackso Exp $" ;

/**
 ** $Log: vwUtil.c,v $
 * Revision 1.2  1994/11/11  22:35:59  aajackso
 * *** empty log message ***
 *
 * Revision 1.1  1994/11/11  21:37:15  aajackso
 * Initial revision
 *
 **/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

/************************************************************************
 ** static void Shift_Left( char*    data,
 **                         int      width,
 **                         int      size,
 **                         int      offset,
 **                         int      shifts,
 **                         char*    defval )
 **
 ** Shifts the data left
 ************************************************************************/

#ifdef __STDC__
static void
Shift_Left( char*                   data,
            int                     width,
            int                     size,
            int                     offset,
            int                     shifts,
            char*                   defval )
#else /** __STDC__ **/
static void
Shift_Left( data, width, size, offset, shifts, defval )
    char*                   data ;
    int                     width ;
    int                     size ;
    int                     offset ;
    int                     shifts ;
    char*                   defval ;
#endif /** __STDC__ **/
{
  register char* l_ptr ;
  register char* r_ptr ;
  register int   n_bytes ;

  /** Copy from left to right **/

  int l_item = offset + shifts ;
  int r_item = offset ;

  if (l_item < 0)
    {
      r_item -= l_item ;
      l_item  = 0 ;
    }

  /**
   ** Note: memcpy() is not guaranteed to work on overlapping
   **       memory
   **/

  l_ptr = data + l_item * size ;
  r_ptr = data + r_item * size ;

  n_bytes = (width - r_item) * size ;

  for ( ; n_bytes ; --n_bytes, l_ptr++, r_ptr++ )
    l_ptr[0] = r_ptr[0] ;

  for ( n_bytes = r_item - l_item ; n_bytes ; --n_bytes, l_ptr += size )
    memcpy( l_ptr, defval, size ) ;
}

/************************************************************************
 ** static void Shift_Right( char*    data,
 **                          int      width,
 **                          int      size,
 **                          int      offset,
 **                          int      shifts,
 **                          char*    defval )
 **
 ** Shifts the data right
 ************************************************************************/

#ifdef __STDC__
static void
Shift_Right( char*                   data,
             int                     width,
             int                     size,
             int                     offset,
             int                     shifts,
             char*                   defval )
#else /** __STDC__ **/
static void
Shift_Right( data, width, size, offset, shifts, defval )
    char*                   data ;
    int                     width ;
    int                     size ;
    int                     offset ;
    int                     shifts ;
    char*                   defval ;
#endif /** __STDC__ **/
{
  register char* l_ptr ;
  register char* r_ptr ;
  register int   n_bytes ;

  /** Copy from right to left **/

  int l_item = width - shifts ;
  int r_item = width ;

  /**
   ** Note: memcpy() is not guaranteed to work on overlapping
   **       memory
   **/

  l_ptr = data + l_item * size - 1 ;
  r_ptr = data + r_item * size - 1 ;

  n_bytes = (l_item - offset) * size ;

  for ( ; n_bytes ; n_bytes--, l_ptr--, r_ptr-- )
    {
      r_ptr[0] = l_ptr[0] ;
    }

  data += offset * size ;
  for ( n_bytes = r_item - l_item ; n_bytes ; --n_bytes, data += size )
    memcpy( data, defval, size ) ;
}

/************************************************************************
 ** void VWUtil_Shift( char*    data,
 **                    int      elements,
 **                    int      elemsize,
 **                    int      offset,
 **                    int      shifts,
 **                    char*    defval )
 **
 ** Shifts arbitrary size elements
 ************************************************************************/

#ifdef __STDC__
void
VWUtil_Shift( char*                   data,
              int                     elements,
              int                     elemsize,
              int                     offset,
              int                     shifts,
              char*                   defval )
#else /** __STDC__ **/
void
VWUtil_Shift( data, elements, elemsize, offset, shifts, defval )
    char*                   data ;
    int                     elements ;
    int                     elemsize ;
    int                     offset ;
    int                     shifts ;
    char*                   defval ;
#endif /** __STDC__ **/
{
    if ((! data) || (! shifts))
	return ;

    if (shifts > 0)
	Shift_Right(data, elements, elemsize, offset, shifts, defval) ;
    else
	Shift_Left(data, elements, elemsize, offset, shifts, defval) ;
}

/************************************************************************
 ** char* VWUtil_Allocate( char*    data,
 **                        int      elements,
 **                        int      elemsize )
 **
 ** Reallocates the data and returns a valid pointer for data.  There is
 ** guarantee that the data which has been newly allocated will be clean.
 ** This is not a memory manager, simply a convenience.
 ************************************************************************/

#ifdef __STDC__
char*
VWUtil_Allocate( char*          data,
                 int            elements,
                 int            elemsize )
#else /** __STDC__ **/
char*
VWUtil_Allocate( data, elements, elemsize )
    char*          data ;
    int            elements ;
    int            elemsize ;
#endif /** __STDC__ **/
{
    return ((data == NULL) ?
	    (malloc(elements * elemsize)) : 
	    (realloc(data, elements * elemsize))) ;
}

#include <vwMatrix.h>

/************************************************************************
 ** void VWUtil_DumpMatrix(char *label, VWMatrix* matrix)
 **
 ** Strictly for debugging purposes
 ************************************************************************/

#ifdef __STDC__
void
VWUtil_DumpMatrix( char*        label,
                   VWMatrix*    matrix )
#else /** __STDC__ **/
void
VWUtil_DumpMatrix( label, matrix )
    char*        label ;
    VWMatrix*    matrix ;
#endif /** __STDC__ **/
{
  int x ;
  int y ;

  fprintf(stderr, "%s:\n", label);
  for ( y = 0 ; y < matrix->height ; y++  )
    {
      fprintf(stderr, "     %2d", y);
      for ( x = 0 ; x < matrix->width ; x++ )
	fprintf(stderr, "[ (%1d) %5x %5x ]", x, VWMatrixIndex(*matrix, void*, x, y, 0), *VWMatrixIndex(*matrix, void*, x, y, 0)) ;
      fprintf(stderr, "\n");
    }

  fprintf(stderr, "\n");
}
