/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableWhere.c,v 1.1.1.1 1994/10/21 13:35:27 aajackso Exp $" ;

/**
 ** $Log: vwTableWhere.c,v $
 * Revision 1.1.1.1  1994/10/21  13:35:27  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0.0.1  1994/08/18  00:05:48  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 **/

#include <stdlib.h>

#include <tk.h>
#include <tcl.h>

#include <vwTable.h>

/************************************************************************
 ** int
 ** VWT_HandleWhere( VWTable     *vwptr,
 **                  Tcl_Interp  *interp,
 **                  int          argc,
 **                  char        *argv[] )
 **
 ** Given an x and a y, determine cell which this is in, if there is
 ** no row or no column, it returns the index -1.-1, otherwise it
 ** will return row.column
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleWhere( VWTable*             vwptr,
                 Tcl_Interp*          interp,
                 int                  argc,
                 char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleWhere( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int row = -1 ;
  int row_offset = -1 ;
  int row_height = -1 ;

  int column = -1 ;
  int column_offset = -1 ;
  int column_width = -1 ;

  int xOffset ;
  int yOffset ;

  VWTableImageElement   *object_x ;
  VWTableImageElement   *object_y ;

  if (argc != 4)
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " x y\"",
		       (char *) NULL);
      return TCL_ERROR ;
    }

  if ((Tcl_GetInt(interp, argv[2], &xOffset) != TCL_OK) ||
      (Tcl_GetInt(interp, argv[3], &yOffset) != TCL_OK))
    return TCL_ERROR ;

  row = row_offset = column = column_offset = -1 ;

  /** Find the column first **/

  object_y = VWT_FindElementAtPixel(vwptr->image.elements[VWT_Vertical], yOffset) ;
  object_x = VWT_FindElementAtPixel(vwptr->image.elements[VWT_Horizontal], xOffset) ;

  if (object_x)
    {
      column = object_x->position ;
      column_offset = object_x->pixel ;
      column_width = object_x->size ;
    }

  if (object_y)
    {
      row = object_y->position ;
      row_offset = object_y->pixel ;
      row_height = object_y->size ;
    }

  /** Return the index **/

  sprintf(interp->result, "%d %d %d %d %d %d", column, row, column_offset, row_offset, column_width, row_height) ;
  return TCL_OK ;
}

/************************************************************************
 ** VWT_HandleInfo( VWTable     *vwptr,
 **                 Tcl_Interp  *interp,
 **                 int          argc,
 **                 char        *argv[] )
 **
 ** Returns special information about the position x y
 **
 ** Usage:
 **    <pathname> info x y
 **
 ** Returns:
 **    none           -- Nothing special
 **    space          -- Empty space not occupied w/ cell
 **    focus          -- A cell w/ focus
 **    bd-left
 **    bd-right
 **    bd-top
 **    bd-bottom
 **    bd-top-left
 **    bd-top-right
 **    bd-bottom-left
 **    bd-bottom-right
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleInfo( VWTable*             vwptr,
                Tcl_Interp*          interp,
                int                  argc,
                char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleInfo( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int x ;
  int y ;

  unsigned short bd_flags = 0 ;

  VWTableImageElement   *object_x ;
  VWTableImageElement   *object_y ;

  static char* bd_modes[] =
  {
    "",                              /** 0 **/
    "bd-left",                       /** 1 **/
    "bd-right",                      /** 2 **/
    "bd-right-left",                 /** 2, 1 **/
    "bd-top",                        /** 4 **/
    "bd-top-left",                   /** 4, 1 **/
    "bd-top-right",                  /** 4, 2 **/
    "bd-top-right-left",             /** 4, 2, 1 **/
    "bd-bottom",                     /** 8 **/
    "bd-bottom-left",                /** 8, 1 **/
    "bd-bottom-right",               /** 8, 2 **/
    "bd-bottom-right-left",          /** 8, 2, 1 **/
    "bd-bottom-top",                 /** 8, 4 **/
    "bd-bottom-top-left",            /** 8, 4, 1 **/
    "bd-bottom-top-right",           /** 8, 4, 2 **/
    "bd-bottom-top-right-left",      /** 8, 4, 2, 1 **/
  };

  int padx = 0 ;
  int pady = 0 ;
  int swargc ;

  /**
   ** Parse possible switches
   **/

  for ( swargc = 2 ; swargc < argc ; swargc++ )
    {
      if ((argv[swargc][0] != '-') || (! strcmp(argv[swargc], "--")))
	  break ;
      else if (! strcmp(argv[swargc], "-padx"))
	{
	  if (++swargc >= argc)
	    {
	      Tcl_AppendResult(interp, "extra option \"-padx\" (option with no value?)", NULL) ;
	      return TCL_ERROR ;
	    }
	  
	  if (Tcl_GetInt(interp, argv[swargc], &padx) != TCL_OK)
	    return TCL_ERROR ;
	}
      else if (! strcmp(argv[swargc], "-pady"))
	{
	  if (++swargc >= argc)
	    {
	      Tcl_AppendResult(interp, "extra option \"-pady\" (option with no value?)", NULL) ;
	      return TCL_ERROR ;
	    }
	  
	  if (Tcl_GetInt(interp, argv[swargc], &pady) != TCL_OK)
	    return TCL_ERROR ;
	}
      else
	{
	  Tcl_AppendResult(interp, "bad switch \"", argv[swargc],
			   "\": must be -padx, -pady or --",
			   NULL) ;
	  return TCL_ERROR ;
	}
    }

  /**
   ** See if they left enough arguments
   **/

  if ((argc - swargc) < 2)
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ? switches ? x y\"",
		       (char *) NULL);
      return TCL_ERROR ;
    }

  if ((Tcl_GetInt(interp, argv[swargc], &x) != TCL_OK) ||
      (Tcl_GetInt(interp, argv[swargc+1], &y) != TCL_OK))
    return TCL_ERROR ;

  /**
   ** Get information from the image
   **/

  if (((object_y = VWT_FindElementAtPixel(vwptr->image.elements[VWT_Vertical], y)) == NULL) ||
      ((object_x = VWT_FindElementAtPixel(vwptr->image.elements[VWT_Horizontal], x)) == NULL))
    {
      Tcl_SetResult(interp, "space", TCL_STATIC) ;
      return TCL_OK ;
    }

  bd_flags |= ((x >= object_x->pixel) && (x < (object_x->pixel + vwptr->cellBorderWidth + padx))) ;
  bd_flags |= ((x < (object_x->pixel + object_x->size)) &&
	       (x >= (object_x->pixel + object_x->size - vwptr->cellBorderWidth - padx))) << 1 ;
  bd_flags |= ((y >= object_y->pixel) && (y < (object_y->pixel + vwptr->cellBorderWidth + pady))) << 2 ;
  bd_flags |= ((y < (object_y->pixel + object_y->size)) &&
	       (y >= (object_y->pixel + object_y->size - vwptr->cellBorderWidth - pady))) << 3 ;

  if (bd_flags)
    {
      Tcl_SetResult(interp, bd_modes[bd_flags], TCL_STATIC) ;
      return TCL_OK ;
    }

  if ((object_x->position == vwptr->focus.col) &&
      (object_y->position == vwptr->focus.row))
    {
      Tcl_SetResult(interp, "focus", TCL_STATIC) ;
      return TCL_OK ;
    }

  Tcl_SetResult(interp, "none", TCL_STATIC) ;
  return TCL_OK ;
}
