/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableView.c,v 1.2 1994/11/11 21:37:14 aajackso Exp $" ;

/**
 ** $Log: vwTableView.c,v $
 * Revision 1.2  1994/11/11  21:37:14  aajackso
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1994/10/21  13:35:23  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0.0.1  1994/08/18  00:05:48  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 **/

#include <stdlib.h>

#include <tk.h>
#include <tcl.h>

#include <vwTable.h>

/************************************************************************
 ** int
 ** VWT_HandleYView( VWTable     *vwptr,
 **                  Tcl_Interp  *interp,
 **                  int          argc,
 **                  char        *argv[] )
 **
 ** Adjusts the Y visible view
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleYView( VWTable*             vwptr,
                 Tcl_Interp*          interp,
                 int                  argc,
                 char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleYView( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int  newRow ;

  if (( argc != 2 ) && ( argc != 3 ))
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ? index ?\"",
		       (char *) NULL);
      return TCL_ERROR ;
    }

  if ( argc == 2 )
    {
      sprintf(interp->result, "%d", vwptr->vrow) ;
      return TCL_OK ;
    }

  if (VWT_GetBoundingPoint(interp, argv[2], &newRow, vwptr->rows, FALSE) != TCL_OK)
    return TCL_OK ;

  vwptr->vrow = newRow ;
  vwptr->scrollOccurred = TRUE ;
  
  VWT_UpdateYScroll(interp, vwptr) ;
  return TCL_OK ;
}

/************************************************************************
 ** int
 ** VWT_HandleXView( VWTable     *vwptr,
 **                  Tcl_Interp  *interp,
 **                  int          argc,
 **                  char        *argv[] )
 **
 ** Adjusts the X visible view
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleXView( VWTable*             vwptr,
                 Tcl_Interp*          interp,
                 int                  argc,
                 char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleXView( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int  newColumn ;

  if (( argc != 2 ) && ( argc != 3 ))
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ? index ?\"",
		       (char *) NULL);
      return TCL_ERROR ;
    }

  if ( argc == 2 )
    {
      sprintf(interp->result, "%d", vwptr->vcolumn) ;
      return TCL_OK ;
    }

  if (VWT_GetBoundingPoint(interp, argv[2], &newColumn, vwptr->columns, FALSE) != TCL_OK)
    return TCL_OK ;
  
  vwptr->vcolumn = newColumn ;
  vwptr->scrollOccurred = TRUE ;

  VWT_UpdateXScroll(interp, vwptr) ;
  return TCL_OK ;
}
