/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableUpdate.c,v 1.2 1994/11/11 22:35:56 aajackso Exp $" ;

/**
 ** $Log: vwTableUpdate.c,v $
 * Revision 1.2  1994/11/11  22:35:56  aajackso
 * *** empty log message ***
 *
 * Revision 1.1  1994/11/11  21:37:12  aajackso
 * Initial revision
 *
 **/

#include <vwTable.h>

/************************************************************************
 ** int VWT_UpdateXScroll( Tcl_Interp*    interp,
 **                        VWTable*       vwptr )
 **
 ** Uh, take a guess
 ************************************************************************/

#ifdef __STDC__
int
VWT_UpdateXScroll( Tcl_Interp*       interp,
                   VWTable*          vwptr )
#else /** __STDC__ **/
int
VWT_UpdateXScroll( interp, vwptr )
    Tcl_Interp*       interp ;
    VWTable*          vwptr ;
#endif /** __STDC__ **/
{
  int  cols ;
  char string[60] ;

  if ((! vwptr) || (! vwptr->xScrollCmd))
    return TCL_OK ;

  cols = VWT_VisibleColumns( vwptr );
  sprintf(string, " %d %d %d %d", vwptr->columns, cols, vwptr->vcolumn, vwptr->vcolumn + cols);
  return Tcl_VarEval( vwptr->interp, vwptr->xScrollCmd, string, NULL );
}

/************************************************************************
 ** int VWT_UpdateYScroll( Tcl_Interp*    interp,
 **                        VWTable*       vwptr )
 **
 ** Uh, take a guess
 ************************************************************************/

#ifdef __STDC__
int
VWT_UpdateYScroll( Tcl_Interp*       interp,
                   VWTable*          vwptr )
#else /** __STDC__ **/
int
VWT_UpdateYScroll( interp, vwptr )
    Tcl_Interp*       interp ;
    VWTable*          vwptr ;
#endif /** __STDC__ **/
{
  int  rows ;
  char string[60] ;

  if ((! vwptr) || (! vwptr->xScrollCmd))
    return TCL_OK ;

  rows = VWT_VisibleRows( vwptr );
  sprintf(string, " %d %d %d %d", vwptr->rows, rows, vwptr->vrow, vwptr->vrow + rows);
  return Tcl_VarEval( vwptr->interp, vwptr->yScrollCmd, string, NULL );
}
