/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableSize.c,v 1.1.1.1 1994/10/21 13:35:24 aajackso Exp $" ;

/**
 ** $Log: vwTableSize.c,v $
 * Revision 1.1.1.1  1994/10/21  13:35:24  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 **/

#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include <malloc.h>

#include <tk.h>
#include <tcl.h>

#include <vwTable.h>

/************************************************************************
 ** int
 ** VWT_HandleSize( VWTable     *vwptr,
 **                 Tcl_Interp  *interp,
 **                 int          argc,
 **                 char        *argv[] )
 **
 ** Attempts to set members of the table
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleSize( VWTable*             vwptr,
                Tcl_Interp*          interp,
                int                  argc,
                char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleSize( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int    x ;
  int    y ;
  int    w ;
  int    h ;

  if (( argc < 4 ) || ( argc == 5 ))
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1],
		       " x y ? w h ?\"",
		       NULL);
      return TCL_ERROR ;
    }

  if ((VWT_GetBoundingPoint(interp, argv[2], &x, vwptr->columns, TRUE) != TCL_OK) ||
      (VWT_GetBoundingPoint(interp, argv[3], &y, vwptr->rows, TRUE) != TCL_OK))
    return TCL_ERROR ;

  if (argc == 4)
    {
      sprintf(interp->result, "%d %d", vwptr->columnWidth[x], vwptr->rowHeight[y]);
      return TCL_OK ;
    }

  if ((VWT_GetBoundingDimension(interp, argv[4], &w, vwptr->columnWidth[x]) != TCL_OK) ||
      (VWT_GetBoundingDimension(interp, argv[5], &h, vwptr->rowHeight[y]) != TCL_OK))
    return TCL_ERROR ;

  if ( w < 0 ) w = 0 ;
  if ( h < 0 ) h = 0 ;

  if (vwptr->rowHeight[y] != h)
    {
      vwptr->redrawOutline = TRUE ;
      vwptr->rowHeight[y] = h ;
    }

  if (vwptr->columnWidth[x] != w)
    {
      vwptr->redrawOutline = TRUE ;
      vwptr->columnWidth[x] = w ;
    }

  return TCL_OK ;
}
