/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableRefer.c,v 1.3 1994/11/11 21:37:08 aajackso Exp $" ;

/**
 ** $Log: vwTableRefer.c,v $
 * Revision 1.3  1994/11/11  21:37:08  aajackso
 * *** empty log message ***
 *
 * Revision 1.2  1994/10/25  21:10:09  aajackso
 * Oops, added __STDC__ code for most source code and changed the Makefile
 * so that it was consistent w/ the new files
 *
 **/

#include <stdlib.h>
#include <stddef.h>
#include <vwHash.h>
#include <vwTableRefer.h>

typedef struct PointerEntry PointerEntry ;
struct         PointerEntry
{
  void*            ptr ;
  int              references ;
  VWTR_Destructor  destructor ;
} ;

static VWHashTable pTable ;

#ifndef TRUE
#define TRUE (1)
#endif

#ifndef FALSE
#define FALSE (0)
#endif

/************************************************************************
 ** static int
 ** PTable_Comp( PointerEntry*  ptr1,
 **              PointerEntry*  ptr2,
 **              unsigned long  size )
 **
 ** Compares two pointers
 ************************************************************************/

#ifdef __STDC__
static int
PTable_Comp( PointerEntry*          ptr1,
             PointerEntry*          ptr2,
             unsigned long          size )
#else /** __STDC__ **/
static int
PTable_Comp( ptr1, ptr2, size )
    PointerEntry*          ptr1 ;
    PointerEntry*          ptr2 ;
    unsigned long          size ;
#endif /** __STDC__ **/
{
  return (ptr1->ptr != ptr2->ptr) ;
}

/************************************************************************
 ** static unsigned long
 ** PTable_Hash( PointerEntry*  ptr,
 **              unsigned long  size )
 **
 ** Hash a pointer
 ************************************************************************/

#ifdef __STDC__
static unsigned long
PTable_Hash( PointerEntry*       ptr,
             unsigned long       size )
#else /** __STDC__ **/
static unsigned long
PTable_Hash( ptr, size )
    PointerEntry*       ptr ;
    unsigned long       size ;
#endif /** __STDC__ **/
{
  return ((unsigned long) ptr->ptr) ;
}

/************************************************************************
 ** static void
 ** PTable_Hash( PointerEntry*  ptr,
 **              unsigned long  size )
 **
 ** Free the pointer?
 ************************************************************************/

#ifdef __STDC__
static void
PTable_Free( PointerEntry*       ptr,
             unsigned long       size )
#else /** __STDC__ **/
static void
PTable_Free( ptr, size )
    PointerEntry*       ptr ;
    unsigned long       size ;
#endif /** __STDC__ **/
{
  if (ptr->destructor)
    ptr->destructor(ptr->ptr) ;
}

/************************************************************************
 ** void
 ** VWT_InitializeReferences()
 **
 ** Initialized the reference table
 ************************************************************************/

#ifdef __STDC__
void
VWT_InitializeReferences( )
#else /** __STDC__ **/
void
VWT_InitializeReferences(  )
#endif /** __STDC__ **/
{
  VWHashTable_Alloc(&pTable, 513) ;

  pTable.comp = (VWHashProc_Comp) PTable_Comp ;
  pTable.free = (VWHashProc_Free) PTable_Free ;
  pTable.hash = (VWHashProc_Hash) PTable_Hash ;
}

/************************************************************************
 ** int
 ** VWT_IncrReferences( void*    ptr,
 **                     int      incr )
 **
 ** Increments the number of references to a pointer.  If the references
 ** fall below zero, a callback occurs and the pointer is subsequently
 ** destroyed
 ************************************************************************/

#ifdef __STDC__
int
VWT_IncrReferences( void*       ptr,
                    int         incr )
#else /** __STDC__ **/
int
VWT_IncrReferences( ptr, incr )
    void*       ptr ;
    int         incr ;
#endif /** __STDC__ **/
{
  PointerEntry  locate ;
  PointerEntry* entry ;

  locate.ptr = ptr ;

  if (! VWHashTable_Find(&pTable, &locate, sizeof(void*), (void **) &entry, NULL, NULL))
    return FALSE ;

  entry->references += incr ;
  if (entry->references <= 0)
    entry->destructor(entry->ptr) ;

  return TRUE ;
}

/************************************************************************
 ** int
 ** VWT_CreateReference( void*            ptr,
 **                      VWTR_Destructor  destructor )
 **
 ** Add an entry for this pointer
 ************************************************************************/

#ifdef __STDC__
int
VWT_CreateReference( void*             ptr,
		     VWTR_Destructor   destructor )
#else /** __STDC__ **/
int
VWT_CreateReference( ptr, destructor )
     void*             ptr ;
     VWTR_Destructor   destructor ;
#endif /** __STDC__ **/
{
  PointerEntry  locate ;
  PointerEntry* allocated ;

  locate.ptr = ptr ;

  if (VWHashTable_Find(&pTable, &locate, sizeof(void*), NULL, NULL, NULL))
    return FALSE ;

  allocated = (PointerEntry *) malloc(sizeof(PointerEntry)) ;

  allocated->ptr = ptr ;
  allocated->destructor = destructor ;

  VWHashTable_Insert(&pTable, allocated, sizeof(void*), NULL, 0) ;

  return TRUE ;
}
