/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTablePost.c,v 1.2 1994/10/25 21:10:08 aajackso Exp $" ;

/**
 ** $Log: vwTablePost.c,v $
 * Revision 1.2  1994/10/25  21:10:08  aajackso
 * Oops, added __STDC__ code for most source code and changed the Makefile
 * so that it was consistent w/ the new files
 *
 * Revision 1.1.1.1  1994/10/21  13:35:26  aajackso
 * Table Widget
 *
 **/

#include <vwTable.h>
#include <vwTableImage.h>

/************************************************************************
 ** int
 ** VWT_HandlePostRow( VWTable     *vwptr,
 **                    Tcl_Interp  *interp,
 **                    int          argc,
 **                    char        *argv[] )
 **
 ** Post a row on screen
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandlePostRow( VWTable*             vwptr,
                   Tcl_Interp*          interp,
                   int                  argc,
                   char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandlePostRow( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  VWTableImageElement *element[2] ;

  int          error ;
  int          row ;
  int          y ;
  int          height ;

  if (argc !=  5)
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ", argv[2],
		       " row y\"",
		       NULL);
      return TCL_ERROR ;
    }

  if (((error = Tcl_GetInt(interp, argv[3], &row)) != TCL_OK) ||
      ((error = Tcl_GetInt(interp, argv[4], &y)) != TCL_OK))
    return error ;

  element[0] = VWT_FindElementByPixel(vwptr->image.elements[VWT_Vertical], y) ;
  element[1] = VWT_FindElementByPosition(vwptr->image.elements[VWT_Vertical], row) ;

  if (( element[0] != NULL ) && ( element[0] != element[1] ))
    {
      Tcl_AppendResult(interp, "cannot place \"", argv[3], 
		       "\" at \"", argv[4],
		       "\", object already in place",
		       NULL) ;

      return TCL_OK ;
    }

  if (( element[1] ) && ( element[0] == element[1] ))
    return TCL_OK ;

  if (element[1] != NULL)
    VWT_RemoveElement(&vwptr->image.elements[VWT_Vertical], element[1]) ;

  element[1] = VWT_AllocElement() ;
  element[1]->pixel = y ;
  element[1]->position = row ;
  element[1]->rsize = vwptr->rowHeight[row] ;
  element[1]->posted = TRUE ;

  height = ((! Tk_IsMapped(vwptr->tkWin)) ? (-1) : (Tk_Height(vwptr->tkWin))) ;

  VWBit_Set(&vwptr->image.posts[VWT_Vertical], row) ;

  VWT_InsertElement(&vwptr->image.elements[VWT_Vertical], element[1], height) ;
  return TCL_OK ;
}

/************************************************************************
 ** int
 ** VWT_HandlePostColumn( VWTable     *vwptr,
 **                       Tcl_Interp  *interp,
 **                       int          argc,
 **                       char        *argv[] )
 **
 ** Post a column on screen
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandlePostColumn( VWTable*             vwptr,
                      Tcl_Interp*          interp,
                      int                  argc,
                      char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandlePostColumn( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  VWTableImageElement *element[2] ;

  int          error ;
  int          col ;
  int          x ;
  int          width ;

  if (argc !=  5)
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ", argv[2],
		       " col x\"",
		       NULL);
      return TCL_ERROR ;
    }

  if (((error = Tcl_GetInt(interp, argv[3], &col)) != TCL_OK) ||
      ((error = Tcl_GetInt(interp, argv[4], &x)) != TCL_OK))
    return error ;

  element[0] = VWT_FindElementByPixel(vwptr->image.elements[VWT_Horizontal], x) ;
  element[1] = VWT_FindElementByPosition(vwptr->image.elements[VWT_Horizontal], col) ;

  if (( element[0] != NULL ) && ( element[0] != element[1] ))
    {
      Tcl_AppendResult(interp, "cannot place \"", argv[3], 
		       "\" at \"", argv[4],
		       "\", object already in place",
		       NULL) ;

      return TCL_OK ;
    }

  if (( element[1] ) && ( element[0] == element[1] ))
    return TCL_OK ;

  if (element[1] != NULL)
    VWT_RemoveElement(&vwptr->image.elements[VWT_Horizontal], element[1]) ;

  element[1] = VWT_AllocElement() ;
  element[1]->pixel = x ;
  element[1]->position = col ;
  element[1]->rsize = vwptr->columnWidth[col] ;
  element[1]->posted = TRUE ;

  width = ((! Tk_IsMapped(vwptr->tkWin)) ? (-1) : (Tk_Width(vwptr->tkWin))) ;

  VWBit_Set(&vwptr->image.posts[VWT_Horizontal], col) ;

  VWT_InsertElement(&vwptr->image.elements[VWT_Horizontal], element[1], width) ;
  return TCL_OK ;
}
