/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableMap.c,v 1.1.1.1 1994/10/21 13:35:26 aajackso Exp $" ;

/**
 ** $Log: vwTableMap.c,v $
 * Revision 1.1.1.1  1994/10/21  13:35:26  aajackso
 * Table Widget
 *
 **/

#include <stddef.h>
#include <memory.h>
#include <vwHash.h>
#include <vwTableMap.h>

static VWHashTable pTable ;

#ifndef TRUE
#define TRUE (1)
#endif

#ifndef FALSE
#define FALSE (0)
#endif

/************************************************************************
 ** static unsigned long
 ** PTable_Hash( void*          ptr,
 **              unsigned long  size )
 **
 ** Hash a pointer
 ************************************************************************/

#ifdef __STDC__
static unsigned long
PTable_Hash( char*            ptr,
             unsigned long    size )
#else /** __STDC__ **/
static unsigned long
PTable_Hash( ptr, size )
    char*            ptr ;
    unsigned long    size ;
#endif /** __STDC__ **/
{
  /**
   ** This is a stupid hashing function replace it immediately
   **/

  register int i ;
  register int shift = 0 ;
  unsigned long hash = 0 ;

  for ( i = 0 ; i < size ; i++, ptr++ )
    {
      hash ^= (ptr[0] << (shift % 32)) ;
      shift += 8 ;
    }

  return hash ;
}

/************************************************************************
 ** void
 ** VWT_InitMappings()
 **
 ** Initialized the mapping table
 ************************************************************************/

#ifdef __STDC__
void
VWT_InitMappings( )
#else /** __STDC__ **/
void
VWT_InitMappings(  )
#endif /** __STDC__ **/
{
  VWHashTable_Alloc(&pTable, 513) ;

  pTable.comp = (VWHashProc_Comp) memcpy ;
  pTable.free = (VWHashProc_Free) 0 ;
  pTable.hash = (VWHashProc_Hash) PTable_Hash ;
}

/************************************************************************
 ** int
 ** VWT_RemoveMapping( void*           key,
 **                    unsigned long   keysize,
 **                    void**          data )
 **
 **
 ** Removes a mapping from the hash table
 ************************************************************************/

#ifdef __STDC__
int
VWT_RemoveMapping( void*               key,
                   unsigned long       keysize,
                   void**              data )
#else /** __STDC__ **/
int
VWT_RemoveMapping( key, keysize, data )
    void*               key ;
    unsigned long       keysize ;
    void**              data ;
#endif /** __STDC__ **/
{
  return VWHashTable_Remove(&pTable, key, keysize, NULL, data, NULL) ;
}

/************************************************************************
 ** int
 ** VWT_FindMapping( void*           key,
 **                  unsigned long   keysize,
 **                  void**          data )
 **
 ** Find a key/data mapping and returns TRUE if the mapping is found.
 ** If found, the data is backfillled
 ************************************************************************/

#ifdef __STDC__
int
VWT_FindMapping( void*               key,
                 unsigned long       keysize,
                 void**              data )
#else /** __STDC__ **/
int
VWT_FindMapping( key, keysize, data )
    void*               key ;
    unsigned long       keysize ;
    void**              data ;
#endif /** __STDC__ **/
{
  return VWHashTable_Find(&pTable, key, keysize, NULL, data, NULL) ;
}

/************************************************************************
 ** int
 ** VWT_InsertMapping( void*          key,
 **                    unsigned long  keysize,
 **                    void*          data )
 **
 ** Insert a key/data mapping.  Returns TRUE if the mapping was created,
 ** otherwise the hashtable found a duplicate and returned FALSE
 ************************************************************************/

#ifdef __STDC__
int
VWT_InsertMapping( void*               key,
                   unsigned long       keysize,
                   void*               data )
#else /** __STDC__ **/
int
VWT_InsertMapping( key, keysize, data )
    void*               key ;
    unsigned long       keysize ;
    void*               data ;
#endif /** __STDC__ **/
{
  return VWHashTable_Insert(&pTable, key, keysize, data, sizeof(void*)) ;
}
