/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableInit.c,v 1.2 1994/11/11 21:37:05 aajackso Exp $" ;

/**
 ** $Log: vwTableInit.c,v $
 * Revision 1.2  1994/11/11  21:37:05  aajackso
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1994/10/21  13:35:23  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0.0.1  1994/08/18  00:05:48  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 **/

#include <tcl.h>
#include <tk.h>
#include <vwTable.h>
#include <vwTableMap.h>

/************************************************************************
 ** int VWT_Init( Tcl_Interp *interp )
 **
 ** Initializes stuff for the table widget
 ************************************************************************/

#ifdef __STDC__
int
VWT_Init( Tcl_Interp*    interp )
#else /** __STDC__ **/
int
VWT_Init( interp )
    Tcl_Interp*    interp ;
#endif /** __STDC__ **/
{
  Tk_Window tkWin = Tk_MainWindow( interp );

  VWT_InitMappings();
  VWT_InitBitmaps();

  Tcl_CreateCommand(interp, "vwtable", VWT_Create, (ClientData) tkWin, NULL);
  return TCL_OK ;
}
  
