/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableGet.c,v 1.2 1994/11/11 21:36:59 aajackso Exp $" ;

/**
 ** $Log: vwTableGet.c,v $
 * Revision 1.2  1994/11/11  21:36:59  aajackso
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1994/10/21  13:35:23  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0.0.1  1994/08/18  00:05:48  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 **/

#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include <malloc.h>

#include <tk.h>
#include <tcl.h>

#include <vwTable.h>
#include <vwTableCell.h>

static char *anchor[]    = { "n ", "ne ", "e ", "se ", "s ", "sw ", "w ", "nw ", "center " };
static int   anchorlen[] = { 2, 3, 2, 3, 2, 3, 2, 3, 7 };

/************************************************************************
 ** static int
 ** Handle_GetInfo( VWTableCell *vwcell,
 **                 char        *memory )
 **
 ** Places the representation for this cell into "memory"
 ************************************************************************/

#ifdef __STDC__
static int
Handle_GetInfo( VWTableCell*       vwcell,
                char*              memory )
#else /** __STDC__ **/
static int
Handle_GetInfo( vwcell, memory )
    VWTableCell*       vwcell ;
    char*              memory ;
#endif /** __STDC__ **/
{
  if ( vwcell == NULL )
    {
      /** {} **/
      
      memcpy(memory, "{}", 2) ;
      return 2 ;
    }

  switch( vwcell->dataType )
    {
    case VWTableTextType:
      /** {TEXT ...} **/
      
      memcpy(memory, "{TEXT ", 6) ;
      memory += 6 ;
      memcpy(memory, anchor[vwcell->data.text.anchor], anchorlen[vwcell->data.text.anchor]) ;
      memory += anchorlen[vwcell->data.text.anchor] ;
      memcpy(memory, vwcell->data.text.data, vwcell->data.text.datalen) ;
      memory += vwcell->data.text.datalen ;
      memcpy(memory, "}", 1);
      
      return vwcell->data.text.datalen + anchorlen[vwcell->data.text.anchor] + 7 ;

    case VWTableBitmapType:
      /** {BITMAP ...} **/

      memcpy(memory, "{BITMAP ", 8) ;
      memory += 8 ;
      memcpy(memory, anchor[vwcell->data.bitmap.anchor], anchorlen[vwcell->data.bitmap.anchor]) ;
      memory += anchorlen[vwcell->data.bitmap.anchor] ;
      memcpy(memory, vwcell->data.bitmap.name, vwcell->data.bitmap.namelen) ;
      memory += vwcell->data.bitmap.namelen ;
      memcpy(memory, "}", 1);

      return vwcell->data.bitmap.namelen + anchorlen[vwcell->data.bitmap.anchor] + 9 ;
    }

  memcpy(memory, "{}", 2) ;
  return 2 ;
}

/************************************************************************
 ** static int
 ** Handle_GetLength( VWTableCell *vwcell )
 **
 ** Determines the amount of space required to hold the data for this
 ** cell
 ************************************************************************/

#ifdef __STDC__
static int
Handle_GetLength( VWTableCell*    vwcell )
#else /** __STDC__ **/
static int
Handle_GetLength( vwcell )
    VWTableCell*    vwcell ;
#endif /** __STDC__ **/
{
  if ( vwcell == NULL )
    /** {} **/
    return 2 ;

  switch( vwcell->dataType )
    {
    case VWTableTextType:
      /** {TEXT <ANCHOR> ...} **/
      return vwcell->data.text.datalen + anchorlen[vwcell->data.text.anchor] + 7 ;

    case VWTableBitmapType:
      /** {BITMAP ...} **/
      return vwcell->data.bitmap.namelen + anchorlen[vwcell->data.bitmap.anchor] + 9 ;
    }

  return 2 ;
}

/************************************************************************
 ** static int
 ** Handle_GetSingle( VWTable       *vwptr,
 **                   Tcl_Interp    *interp,
 **                   int            argc,
 **                   char          *argv[] )
 **
 ** Gets a single cell.  One might wish to think of it as a subset of
 ** a range, but the arguments are different and this is not the
 ** function which deals with dismantling and such.
 ************************************************************************/

#ifdef __STDC__
static int
Handle_GetSingle( VWTable*             vwptr,
                  Tcl_Interp*          interp,
                  int                  argc,
                  char*                argv[] )
#else /** __STDC__ **/
static int
Handle_GetSingle( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int             x ;
  int             y ;
  int             length ;
  VWTableCell*    vwcell ;
  char*           result ;

  if ((VWT_GetBoundingPoint(interp, argv[0], &x, vwptr->columns, TRUE) != TCL_OK) ||
      (VWT_GetBoundingPoint(interp, argv[1], &y, vwptr->rows, TRUE) != TCL_OK))
    return TCL_ERROR ;

  vwcell = *VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0) ;

  length = Handle_GetLength(vwcell) ;
  result = (char *) malloc(length + 1) ;
  result[length] = 0x0 ;

  Handle_GetInfo(vwcell, result) ;
  Tcl_SetResult(interp, result, TCL_DYNAMIC) ;
  return TCL_OK ;
}

/************************************************************************
 ** static int
 ** Handle_GetRange( VWTable       *vwptr,
 **                  Tcl_Interp    *interp,
 **                  int            argc,
 **                  char          *argv[] )
 **
 ** Handles getting ranges.  The process is more complicated when
 ** dealing with a range than when dealing with a single cell
 ************************************************************************/

#ifdef __STDC__
static int
Handle_GetRange( VWTable*             vwptr,
                 Tcl_Interp*          interp,
                 int                  argc,
                 char*                argv[] )
#else /** __STDC__ **/
static int
Handle_GetRange( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int             x, x1, x2 ;
  int             y, y1, y2 ;
  VWTableCell*    vwcell ;

  int             length = 0 ;

  char*           result ;
  char*           orig ;

  /**
   ** Get the bounding region (x1, y1, x2, y2) to
   ** apply the highlight to
   **/

  if (VWT_GetBoundingBox( interp,
			      vwptr,
			      &x1, &y1,
			      &x2, &y2,
			      &argv[0],
			      TRUE ) != TCL_OK )
    {
      return TCL_ERROR ;
    }

  /** Find out how much memory we will need to hold all the data **/

  for ( y = y1 ; y <= y2 ; y++ )
    {
      length += 3 ;
      for ( x = x1 ; x <= x2 ; x++ )
	{
	  vwcell = *VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0) ;
	  length += Handle_GetLength(vwcell) + 1 ;
	}
    }

  orig = result = (char *) malloc(length + 1) ;
  orig[length] = 0x0 ;

  for ( y = y1 ; y <= y2 ; y++ )
    {
      result[0] = '{' ;
      result++ ;

      for ( x = x1 ; x <= x2 ; x++ )
	{
	  vwcell = *VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0) ;
	  result += Handle_GetInfo(vwcell, result) ;
	  result[0] = ' ' ;
	  result++ ;
	}

      result[0] = '}' ;
      result[1] = ' ' ;
      result += 2 ;
    }
  
  Tcl_SetResult(interp, orig, TCL_DYNAMIC) ;
  return TCL_OK ;
}

/************************************************************************
 ** int
 ** VWT_HandleGet( VWTable     *vwptr,
 **                    Tcl_Interp  *interp,
 **                    int          argc,
 **                    char        *argv[] )
 **
 ** Retrieve data from cells...
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleGet( VWTable*             vwptr,
               Tcl_Interp*          interp,
               int                  argc,
               char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleGet( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  if ((argc < 4) || (argc == 5))
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1],
		       " x1 y1 ? x2 y2 ?\"",
		       NULL);
      return TCL_ERROR ;
    }

  return (( argc != 4 ) ?
	  ( Handle_GetRange ( vwptr, interp, argc - 2, argv + 2 )) :
	  ( Handle_GetSingle( vwptr, interp, argc - 2, argv + 2 ))) ;
}

/************************************************************************
 ** void
 ** VWT_GetData( VWTable         *vwptr,
 **              VWTableCell     *vwcell,
 **              char           **data,
 **              unsigned long   *alloc )
 **
 ** Allocates memory for data and puts the representation of the cell in
 ** it.  The caller is responsible for destruction of said memory.  The
 ** variable alloc will inform the user of how much memory has been used
 ** and may be used when calling this function in repetition, hence,
 ** memory reuse.
 ************************************************************************/
 
#ifdef __STDC__
void
VWT_GetData( VWTable*             vwptr,
	     VWTableCell*         vwcell,
	     char**               data,
	     unsigned long*       alloc )
#else /** __STDC__ **/
void
VWT_GetData( vwptr, vwcell, data, alloc )
    VWTable*             vwptr ;
    VWTableCell*         vwcell ;
    char**               data ;
    unsigned long*       alloc ;
#endif /** __STDC__ **/
{
  int length ;

  length = Handle_GetLength(vwcell) ;
  if (alloc[0] < (length + 1))
    {
      data[0] = (( data[0] == NULL ) ?
		 ( malloc(length + 1) ) :
		 ( realloc(data[0], length + 1) )) ;

      alloc[0] = length + 1 ;
    }

  data[0][length] = 0x0 ;
  Handle_GetInfo(vwcell, data[0]) ;
}
