/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableEvent.c,v 1.2 1994/11/11 21:36:55 aajackso Exp $" ;

/**
 ** $Log: vwTableEvent.c,v $
 * Revision 1.2  1994/11/11  21:36:55  aajackso
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1994/10/21  13:35:23  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 **/

#include <malloc.h>

#include <tk.h>
#include <tcl.h>

#include <vwTable.h>

/************************************************************************
 ** void
 ** VWT_Destroy( ClientData clientData )
 **
 ** Clean up the widget once it has received some form of "destroy"
 ************************************************************************/

#ifdef __STDC__
static void
VWT_Destroy( ClientData    clientData )
#else /** __STDC__ **/
static void
VWT_Destroy( clientData )
    ClientData    clientData ;
#endif /** __STDC__ **/
{
  VWTable *vwptr = (VWTable *) clientData ;
  register int           n_ptrs ;
  register VWTableCell** ptr ;

  /**
   ** Free all Tk related entities and all X related
   ** entities.  This include GCs, pixmaps, etc.
   **/

  Tk_FreeOptions(configSpecs, (char *) vwptr, vwptr->display, 0);
  if ( vwptr->gc != None )
    Tk_FreeGC(vwptr->display, vwptr->gc);

  if (vwptr->image.pixmap)
    XFreePixmap(vwptr->display, vwptr->image.pixmap);

  /**
   ** Free all data in the matrix
   **/

  n_ptrs = vwptr->matrix.width * vwptr->matrix.height * vwptr->matrix.depth ;
  for (ptr = (VWTableCell**) vwptr->matrix.memory ; n_ptrs ; ptr++, n_ptrs--)
    {
      while(VWT_PopFont(*ptr)) ;
      while(VWT_PopColor(*ptr)) ;
      VWT_FreeData(vwptr, *ptr) ;

      if (*ptr) free((char *) *ptr) ;
    }

  VWMatrix_Free(&vwptr->matrix) ;

  /**
   ** Free the bitmasks
   **/

  VWBitset_Free(&vwptr->flux[VWT_Horizontal]) ;
  VWBitset_Free(&vwptr->hide[VWT_Horizontal]) ;
  VWBitset_Free(&vwptr->image.posts[VWT_Horizontal]) ;

  VWBitset_Free(&vwptr->flux[VWT_Vertical]) ;
  VWBitset_Free(&vwptr->hide[VWT_Vertical]) ;
  VWBitset_Free(&vwptr->image.posts[VWT_Vertical]) ;

  /**
   ** Free posted element list
   **/

  VWT_FreeElementList(vwptr->image.elements[VWT_Vertical]) ;
  VWT_FreeElementList(vwptr->image.elements[VWT_Horizontal]) ;

  if (vwptr->rowHeight)     free((char *) vwptr->rowHeight) ;
  if (vwptr->columnWidth)   free((char *) vwptr->columnWidth) ;
  if (vwptr->varName)       free((char *) vwptr->varName) ;

  free((char *) vwptr);
}

/************************************************************************
 ** void VWT_HandleEvent( ClientData   clientData,
 **                           XEvent      *eventPtr )
 **
 ** Handles all events for the table
 ************************************************************************/

#ifdef __STDC__
void
VWT_HandleEvent( ClientData       clientData,
                 XEvent*          eventPtr )
#else /** __STDC__ **/
void
VWT_HandleEvent( clientData, eventPtr )
    ClientData       clientData ;
    XEvent*          eventPtr ;
#endif /** __STDC__ **/
{
  VWTable *vwptr = (VWTable *) clientData ;

  switch(eventPtr->type)
    {
    case Expose:
      if (eventPtr->xexpose.count == 0)
	Tk_DoWhenIdle(VWT_Display, clientData);
      break ;

    case DestroyNotify:
      Tcl_DeleteCommand(vwptr->interp, Tk_PathName(vwptr->tkWin));
      vwptr->tkWin = NULL ;
      if (vwptr->updatePending)
	Tk_CancelIdleCall(VWT_Display, clientData) ;
      
      Tk_EventuallyFree(clientData, VWT_Destroy);
      break ;

    case FocusIn:
      vwptr->flags |= VWT_FocusOn ;
      if (vwptr->focus.focusing)
	VWT_SetFocus(vwptr, vwptr->interp) ;

      Tk_DoWhenIdle(VWT_Display, clientData);
      break ;

    case FocusOut:
      vwptr->flags &= ~VWT_FocusOn ;
      VWT_UnsetFocus(vwptr, vwptr->interp) ;
      break ;

    case ConfigureNotify:
      if ((! vwptr->image.pixmap) ||
	  (Tk_Width(vwptr->tkWin) > vwptr->image.width) ||
	  (Tk_Height(vwptr->tkWin) > vwptr->image.height))
	{
	  if (vwptr->image.pixmap)
	    XFreePixmap(vwptr->display, vwptr->image.pixmap);

	  /**
	   ** Create a pixmap so that we can draw on the pixmap and then copy
	   ** the pixmap to the window when we are ready, this should eliminate
	   ** annoying flicker.  Anyone who's done work with a windowing system
	   ** before has probably done graphic buffers before
	   **/

	  vwptr->image.pixmap = XCreatePixmap( Tk_Display (vwptr->tkWin),
					       Tk_WindowId(vwptr->tkWin),
					       Tk_Width   (vwptr->tkWin),
					       Tk_Height  (vwptr->tkWin),
					       Tk_Depth   (vwptr->tkWin) );

	  vwptr->image.width = Tk_Width(vwptr->tkWin) ;
	  vwptr->image.height = Tk_Height(vwptr->tkWin) ;
	}

      VWT_UpdateXScroll(vwptr->interp, vwptr) ;
      VWT_UpdateYScroll(vwptr->interp, vwptr) ;

      vwptr->redrawBackground = TRUE ;
      vwptr->scrollOccurred = TRUE ;
    }
}



