/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableDelete.c,v 1.2 1994/11/11 22:35:49 aajackso Exp $" ;

/**
 ** $Log: vwTableDelete.c,v $
 * Revision 1.2  1994/11/11  22:35:49  aajackso
 * *** empty log message ***
 *
 * Revision 1.1  1994/11/11  21:36:52  aajackso
 * Initial revision
 *
 **/

#include <vwUtil.h>
#include <vwTable.h>
#include <vwTableDefs.h>

/************************************************************************
 ** int VWT_HandleDeleteColumn( VWTable*       vwptr,
 **                             Tcl_Interp*    interp,
 **                             int            argc,
 **                             char*[]        argv )
 **
 ** Deletes a column.  Deletion occurs BEFORE the named column.  To
 ** delete column at the end use "end"
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleDeleteColumn( VWTable*             vwptr,
                        Tcl_Interp*          interp,
                        int                  argc,
                        char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleDeleteColumn( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int col ;
  int ncols ;
  int error ;
  int defval ;
  int newcols ;

  VWTableImageElement* object_x ;

  if (argc != 5)
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ", argv[2],
		       " col ncols\"",
		       NULL) ;
      
      return TCL_ERROR ;
    }

  if (((error = VWT_GetBoundingPoint(interp, argv[3], &col, vwptr->columns + 1, TRUE)) != TCL_OK) ||
      ((error = Tcl_GetInt(interp, argv[4], &ncols)) != TCL_OK))
    return error ;

  /**
   ** We add this because this will operate faster than primitives,
   ** but we may well do the same operation.  Copy, expand and
   ** replace
   **/

  newcols = vwptr->columns - ncols ;
  if (newcols < 0)
    {
      /**
       ** Set appropriate behavior
       **/

      ncols = vwptr->columns ;
      newcols = 0 ;
    }

  /**
   ** Reallocate and shift
   **/

  defval = DEF_VW_TABLE_COLUMN_WIDTH ;

  VWUtil_Shift((char *) vwptr->columnWidth, newcols, sizeof(int), col, -ncols, (char *) &defval) ;
  vwptr->columnWidth = (int *) VWUtil_Allocate((char *) vwptr->columnWidth, newcols, sizeof(int)) ;

  /**
   ** Resize all objects so that we can do an inplace shift
   **/

#ifdef STRICT_DEBUG
  VWUtil_DumpMatrix("Pre", vwptr->matrix) ;
#endif

  vwptr->columns = newcols ;

  VWBitset_Alloc(&vwptr->image.posts[VWT_Horizontal], newcols) ;
  VWBitset_Alloc(&vwptr->flux[VWT_Horizontal], newcols) ;
  VWBitset_Alloc(&vwptr->hide[VWT_Horizontal], newcols) ;

  VWBitset_Shift(&vwptr->image.posts[VWT_Horizontal], col, -ncols) ;
  VWBitset_Shift(&vwptr->flux[VWT_Horizontal], col, -ncols) ;
  VWBitset_Shift(&vwptr->hide[VWT_Horizontal], col, -ncols) ;

  VWMatrix_Alloc (&vwptr->matrix, vwptr->columns, vwptr->rows, 1) ;
  VWMatrix_ShiftX(&vwptr->matrix, col, -ncols) ;

#ifdef STRICT_DEBUG
  VWUtil_DumpMatrix("Post", vwptr->matrix) ;
#endif

  /**
   ** The image is now wrong.  To incur minimal penalty
   ** just push the columns that are to the right more
   ** right
   **/

  for ( object_x  = vwptr->image.elements[VWT_Horizontal] ;
        object_x != NULL ;
	object_x  = object_x->next )
      {
	  if (object_x->position >= col)
	      object_x->position += ncols ;
      }

  VWT_UpdateXScroll(interp, vwptr) ;
  return TCL_OK ;
}

/************************************************************************
 ** int VWT_HandleDeleteRow( VWTable*       vwptr,
 **                          Tcl_Interp*    interp,
 **                          int            argc,
 **                          char*[]        argv )
 **
 ** Deletes a row.  Deletion occurs BEFORE the named row.  To delete
 ** rows at the end use "end"
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleDeleteRow( VWTable*             vwptr,
                     Tcl_Interp*          interp,
                     int                  argc,
                     char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleDeleteRow( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int row ;
  int nrows ;
  int error ;
  int defval ;
  int newrows ;

  VWTableImageElement* object_y ;

  if (argc != 5)
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ", argv[2],
		       " row nrows\"",
		       NULL) ;
      
      return TCL_ERROR ;
    }

  if (((error = VWT_GetBoundingPoint(interp, argv[3], &row, vwptr->rows + 1, TRUE)) != TCL_OK) ||
      ((error = Tcl_GetInt(interp, argv[4], &nrows)) != TCL_OK))
    return error ;

  /**
   ** We add this because this will operate faster than primitives,
   ** but we may well do the same operation.  Copy, expand and
   ** replace
   **/

  newrows = vwptr->rows - nrows ;
  if (newrows < 0)
    {
      /**
       ** Set appropriate behavior
       **/

      nrows = vwptr->rows ;
      newrows = 0 ;
    }

  /**
   ** Reallocate and shift
   **/

  defval = DEF_VW_TABLE_ROW_HEIGHT ;

  VWUtil_Shift((char *) vwptr->rowHeight, newrows, sizeof(int), row, -nrows, (char *) &defval) ;
  vwptr->rowHeight = (int *) VWUtil_Allocate((char *) vwptr->rowHeight, newrows, sizeof(int)) ;

  /**
   ** Resize all objects so that we can do an inplace shift
   **/

#ifdef STRICT_DEBUG
  VWUtil_DumpMatrix("Pre", vwptr->matrix) ;
#endif

  vwptr->rows = newrows ;

  VWBitset_Alloc(&vwptr->image.posts[VWT_Vertical], newrows) ;
  VWBitset_Alloc(&vwptr->flux[VWT_Vertical], newrows) ;
  VWBitset_Alloc(&vwptr->hide[VWT_Vertical], newrows) ;

  VWBitset_Shift(&vwptr->image.posts[VWT_Vertical], row, -nrows) ;
  VWBitset_Shift(&vwptr->flux[VWT_Vertical], row, -nrows) ;
  VWBitset_Shift(&vwptr->hide[VWT_Vertical], row, -nrows) ;

  VWMatrix_Alloc (&vwptr->matrix, vwptr->columns, vwptr->rows, 1) ;
  VWMatrix_ShiftY(&vwptr->matrix, row, -nrows) ;

#ifdef STRICT_DEBUG
  VWUtil_DumpMatrix("Post", vwptr->matrix) ;
#endif

  /**
   ** The image is now wrong.  To incur minimal penalty
   ** just push the columns that are to the right more
   ** right
   **/

  for ( object_y  = vwptr->image.elements[VWT_Vertical] ;
        object_y != NULL ;
	object_y  = object_y->next )
      {
	  if (object_y->position >= row)
	      object_y->position += nrows ;
      }

  VWT_UpdateYScroll(interp, vwptr) ;
  return TCL_OK ;
}
