/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableConfig.c,v 1.3 1994/11/11 21:36:50 aajackso Exp $" ;

/**
 ** $Log: vwTableConfig.c,v $
 * Revision 1.3  1994/11/11  21:36:50  aajackso
 * *** empty log message ***
 *
 * Revision 1.2  1994/11/01  14:44:10  aajackso
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1994/10/21  13:35:23  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 **/

#include <tk.h>
#include <tcl.h>

#include <vwTable.h>
#include <vwTableCell.h>
#include <vwTableDefs.h>

#define Cast(xx, yy) ((yy) (xx))

/************************************************************************
 ** Configuration Specifics
 ************************************************************************/

Tk_ConfigSpec configSpecs[] =
{
  {
    TK_CONFIG_BORDER, "-background", "background", "Background", 
    DEF_VW_TABLE_COLOR_BG, Tk_Offset(VWTable, bgBorder),
    TK_CONFIG_COLOR_ONLY, (Tk_CustomOption *) NULL
  },
  {
    TK_CONFIG_BORDER, "-background", "background", "Background", 
    DEF_VW_TABLE_MONO_BG, Tk_Offset(VWTable, bgBorder),
    TK_CONFIG_MONO_ONLY, (Tk_CustomOption *) NULL
  },
  {
    TK_CONFIG_SYNONYM, "-bd", "borderWidth", (char *) NULL,
    (char *) NULL, 0, 0, (Tk_CustomOption *) NULL
  },
  {
    TK_CONFIG_SYNONYM, "-bg", "background", (char *) NULL,
    (char *) NULL, 0, 0, (Tk_CustomOption *) NULL
  },
  {
    TK_CONFIG_PIXELS, "-borderwidth", "borderWidth", "BorderWidth",
    DEF_VW_TABLE_BORDERWIDTH, Tk_Offset(VWTable, borderWidth),
    0, (Tk_CustomOption *) NULL
  },
  {
    TK_CONFIG_PIXELS, "-cellborderwidth", "cellborderWidth", "CellBorderWidth",
    DEF_VW_TABLE_CELLBORDERWIDTH, Tk_Offset(VWTable, cellBorderWidth),
    0, (Tk_CustomOption *) NULL
  },
  {
    TK_CONFIG_RELIEF, "-cellrelief", "cellrelief", "CellRelief",
    DEF_VW_TABLE_CELL_RELIEF, Tk_Offset(VWTable, cellRelief),
    0, (Tk_CustomOption *) NULL
  },
  {
    TK_CONFIG_INT, "-cols", "columns", "Columns",
    DEF_VW_TABLE_COLUMNS, Tk_Offset(VWTable, columns),
    0, (Tk_CustomOption *) NULL
  },
  {
    TK_CONFIG_ACTIVE_CURSOR, "-cursor", "cursor", "Cursor",
    DEF_VW_TABLE_CURSOR, Tk_Offset(VWTable, cursor),
    TK_CONFIG_NULL_OK, (Tk_CustomOption *) NULL
  },
  {
    TK_CONFIG_BOOLEAN, "-exportselection", "exportSelection", "ExportSelection",
    DEF_VW_TABLE_EXPORT_SELECTION, Tk_Offset(VWTable, focus.export),
    0, (Tk_CustomOption *) NULL
  },
  {
    TK_CONFIG_SYNONYM, "-fg", "foreground", (char *) NULL,
    (char *) NULL, 0, 0, (Tk_CustomOption *) NULL
  },
  {
    TK_CONFIG_BORDER, "-foreground", "foreground", "Foreground",
    DEF_VW_TABLE_COLOR_FG, Tk_Offset(VWTable, fgBorder),
    TK_CONFIG_COLOR_ONLY, (Tk_CustomOption *) NULL
  },
  {
    TK_CONFIG_BORDER, "-foreground", "foreground", "Foreground",
    DEF_VW_TABLE_MONO_FG, Tk_Offset(VWTable, fgBorder),
    TK_CONFIG_MONO_ONLY, (Tk_CustomOption *) 0
  },
  {
    TK_CONFIG_FONT, "-font", "font", "Font",
    DEF_VW_TABLE_FONT, Tk_Offset(VWTable, fontPtr),
    0, (Tk_CustomOption *) 0
  },
  {
    TK_CONFIG_INT, "-height", "height", "Height",
    "50", Tk_Offset(VWTable, image.height),
    0, (Tk_CustomOption *) 0    
  },
  {
    TK_CONFIG_BORDER, "-insertbackground", "insertBackground", "Foreground",
    DEF_VW_TABLE_INSERT_BG, Tk_Offset(VWTable, focus.background),
    0, (Tk_CustomOption *) 0
  },
  {
    TK_CONFIG_PIXELS, "-insertborderwidth", "insertBorderWidth", "BorderWidth",
    DEF_VW_TABLE_INSERT_BD_COLOR, Tk_Offset(VWTable, focus.borderWidth),
    TK_CONFIG_COLOR_ONLY, (Tk_CustomOption *) 0
  },
  {
    TK_CONFIG_PIXELS, "-insertborderwidth", "insertBorderWidth", "BorderWidth",
    DEF_VW_TABLE_INSERT_BD_MONO, Tk_Offset(VWTable, focus.borderWidth),
    TK_CONFIG_MONO_ONLY, (Tk_CustomOption *) 0
  },
  {
    TK_CONFIG_INT, "-insertofftime", "insertOffTime", "OffTime",
    DEF_VW_TABLE_INSERT_OFF_TIME, Tk_Offset(VWTable, focus.offTime),
    0, (Tk_CustomOption *) 0
  },
  {
    TK_CONFIG_INT, "-insertontime", "insertOnTime", "OnTime",
    DEF_VW_TABLE_INSERT_ON_TIME, Tk_Offset(VWTable, focus.onTime),
    0, (Tk_CustomOption *) 0
  },
  {
    TK_CONFIG_PIXELS, "-insertwidth", "insertWidth", "InsertWidth",
    DEF_VW_TABLE_INSERT_WIDTH, Tk_Offset(VWTable, focus.width),
    0, (Tk_CustomOption *) 0
  },
  {
    TK_CONFIG_RELIEF, "-relief", "relief", "Relief",
    DEF_VW_TABLE_RELIEF, Tk_Offset(VWTable, relief),
    0, (Tk_CustomOption *) 0
  },
  {
    TK_CONFIG_INT, "-rows", "rows", "Rows",
    DEF_VW_TABLE_ROWS, Tk_Offset(VWTable, rows),
    0, (Tk_CustomOption *) 0
  },
  {
    TK_CONFIG_BORDER, "-selectbackground", "selectBackground", "Foreground",
    DEF_VW_TABLE_SELECT_COLOR, Tk_Offset(VWTable, focus.selBorder),
    TK_CONFIG_COLOR_ONLY
  },
  {
    TK_CONFIG_BORDER, "-selectbackground", "selectBackground", "Foreground",
    DEF_VW_TABLE_SELECT_MONO, Tk_Offset(VWTable, focus.selBorder),
    TK_CONFIG_MONO_ONLY
  },
  {
    TK_CONFIG_PIXELS, "-selectborderwidth", "selectBorderWidth", "BorderWidth",
    DEF_VW_TABLE_SELECT_BD_COLOR, Tk_Offset(VWTable, focus.selBorderWidth),
    TK_CONFIG_COLOR_ONLY
  },
  {
    TK_CONFIG_PIXELS, "-selectborderwidth", "selectBorderWidth", "BorderWidth",
    DEF_VW_TABLE_SELECT_BD_MONO, Tk_Offset(VWTable, focus.selBorderWidth),
    TK_CONFIG_MONO_ONLY
  },
  {
    TK_CONFIG_COLOR, "-selectforeground", "selectForeground", "Background",
    DEF_VW_TABLE_SELECT_FG_COLOR, Tk_Offset(VWTable, focus.selFg),
    TK_CONFIG_COLOR_ONLY
  },
  {
    TK_CONFIG_COLOR, "-selectforeground", "selectForeground", "Background",
    DEF_VW_TABLE_SELECT_FG_MONO, Tk_Offset(VWTable, focus.selFg),
    TK_CONFIG_MONO_ONLY
  },
  {
    TK_CONFIG_INT, "-width", "width", "Width",
    "20", Tk_Offset(VWTable, image.width),
    0, (Tk_CustomOption *) 0    
  },
  {
    TK_CONFIG_STRING, "-xscrollcommand", "xScrollCommand", "ScrollCommand",
    DEF_VW_TABLE_SCROLL_COMMAND, Tk_Offset(VWTable, xScrollCmd),
    0, (Tk_CustomOption *) 0
  },    
  {
    TK_CONFIG_STRING, "-yscrollcommand", "yScrollCommand", "ScrollCommand",
    DEF_VW_TABLE_SCROLL_COMMAND, Tk_Offset(VWTable, yScrollCmd),
    0, (Tk_CustomOption *) 0
  },    
  {
    TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
    (char *) NULL, 0, 0, (Tk_CustomOption *) NULL
  }
} ;

/************************************************************************
 ** int VWT_Configure( Tcl_Interp    *interp,
 **                        VWTable       *vwptr,
 **                        int            argc,
 **                        char          *argv[],
 **                        int            flags )
 **
 ** Configure a VWTable
 ************************************************************************/

#ifdef __STDC__
int
VWT_Configure( Tcl_Interp*                interp,
               VWTable*                   vwptr,
               int                        argc,
               char*                      argv[],
               int                        flags )
#else /** __STDC__ **/
int
VWT_Configure( interp, vwptr, argc, argv, flags )
    Tcl_Interp*                interp ;
    VWTable*                   vwptr ;
    int                        argc ;
    char*                      argv[] ;
    int                        flags ;
#endif /** __STDC__ **/
{
  XFontStruct*  fontPtr = vwptr->fontPtr ;

  int           oldRows    = vwptr->rows ;
  int           oldColumns = vwptr->columns ;

  int           i ;
  int           width ;
  int           height ;

  int           oldWidth = vwptr->image.width ;
  int           oldHeight = vwptr->image.height ;
  
  unsigned long pixel ;

  if (Tk_ConfigureWidget( interp,
			  vwptr->tkWin,
			  configSpecs,
			  argc,
			  argv,
			  Cast( vwptr, char* ),
			  flags ) != TCL_OK )
    {
      return TCL_ERROR ;
    }

  /**
   ** See if the font has changed
   **/

  if ( vwptr->fontPtr != fontPtr )
    {
      vwptr->fontName = Tk_NameOfFontStruct(vwptr->fontPtr) ;
      vwptr->fontNameLen = strlen(vwptr->fontName) ;
      vwptr->fontHeight = (vwptr->fontPtr->ascent + vwptr->fontPtr->descent) / 2 ;
    }

  /**
   ** Adjust for changes in the row/column size
   **/

  if ( vwptr->columns != oldColumns )
    {
      VWT_ResetColumns(vwptr, oldColumns, vwptr->columns);
      VWBitset_Alloc(&vwptr->image.posts[VWT_Horizontal], vwptr->columns) ;
      VWBitset_Alloc(&vwptr->flux[VWT_Horizontal], vwptr->columns) ;
      VWBitset_Alloc(&vwptr->hide[VWT_Horizontal], vwptr->columns) ;
      VWBitset_Zero (&vwptr->flux[VWT_Horizontal]) ;
      VWBitset_Zero (&vwptr->hide[VWT_Horizontal]) ;
      VWT_UpdateXScroll(interp, vwptr) ;
    }

  if ( vwptr->rows != oldRows )
    {
      VWT_ResetRows(vwptr, oldRows, vwptr->rows );
      VWBitset_Alloc(&vwptr->image.posts[VWT_Vertical], vwptr->rows) ;
      VWBitset_Alloc(&vwptr->flux[VWT_Vertical], vwptr->rows) ;
      VWBitset_Alloc(&vwptr->hide[VWT_Vertical], vwptr->rows) ;
      VWBitset_Zero (&vwptr->flux[VWT_Vertical]) ;
      VWBitset_Zero (&vwptr->hide[VWT_Vertical]) ;
      VWT_UpdateYScroll(interp, vwptr) ;
    }

  if (( vwptr->columns != oldColumns ) ||
      ( vwptr->rows != oldRows ))
    {
      VWMatrix_Alloc(&vwptr->matrix, vwptr->columns, vwptr->rows, 1);
    }

  /**
   ** Do a bit of parsing based on the geometry, reducing
   ** the window size if necessary
   **/

  height = vwptr->image.height ;
  if (vwptr->image.height == -1)
    {
      height = 0 ;
      for ( i = 0 ;
	    i < vwptr->rows ;
	    i++ )
	{
	  height += vwptr->rowHeight[i] ;
	}
      
      if ( height > 50 ) height = 50 ;
      height += 2 * vwptr->borderWidth ;
    }

  width = vwptr->image.width ;
  if (vwptr->image.width == -1)
    {
      width = 0 ;
      for ( i = 0 ;
	    i < vwptr->columns ;
	    i++ )
	{
	  width += vwptr->columnWidth[i] ;
	}
      
      if ( width > 200 ) width = 200 ;
      width += 2 * vwptr->borderWidth ;
    }

  if (( height != oldHeight ) ||
      ( width != oldWidth ))
    Tk_GeometryRequest(vwptr->tkWin, width, height);

  /**
   ** Adjust for geometry and/or color changes
   **/

  pixel = Tk_3DBorderColor( vwptr->bgBorder )->pixel ;
  Tk_SetWindowBackground( vwptr->tkWin, pixel );

  if ( vwptr->gc == None )
    {
      XGCValues gcValues ;
      
      gcValues.function = GXcopy ;
      gcValues.graphics_exposures = False ;

      vwptr->gc = Tk_GetGC( vwptr->tkWin,
			    GCFunction | GCGraphicsExposures,
			    &gcValues );
    }

  Tk_SetInternalBorder( vwptr->tkWin, vwptr->borderWidth );
  
  if (! vwptr->updatePending)
    {
      Tk_DoWhenIdle( VWT_Display, (ClientData) vwptr );
      vwptr->updatePending = 1 ;
    }

  return TCL_OK ;
}

/************************************************************************
 ** int
 ** VWT_HandleConfig( VWTable     *vwptr,
 **                       Tcl_Interp  *interp,
 **                       int          argc,
 **                       char        *argv[] )
 **
 ** Handle all those stupid configuration options
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleConfig( VWTable*             vwptr,
                  Tcl_Interp*          interp,
                  int                  argc,
                  char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleConfig( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int result = TCL_OK ;

  if (argc == 2)
    {
      result = Tk_ConfigureInfo( interp,
				 vwptr->tkWin,
				 configSpecs,
				 (char *) vwptr,
				 (char *) NULL,
				 0 );
    }
  else if (argc == 3)
    {
      result = Tk_ConfigureInfo( interp,
				vwptr->tkWin,
				configSpecs,
				(char *) vwptr,
				argv[2],
				0 );
    }
  else
    {
      result = VWT_Configure( interp,
				  vwptr,
				  argc - 2,
				  argv + 2,
				  TK_CONFIG_ARGV_ONLY );

      vwptr->redrawBackground = TRUE ;
    }

  return result ;
}
