/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableColor.c,v 1.3 1994/11/11 22:35:47 aajackso Exp $" ;

/**
 ** $Log: vwTableColor.c,v $
 * Revision 1.3  1994/11/11  22:35:47  aajackso
 * *** empty log message ***
 *
 * Revision 1.2  1994/11/11  21:36:46  aajackso
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1994/10/21  13:35:28  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * Added push/pop stacks for color schema.
 *
 * Revision 1.0.0.1  1994/08/18  00:05:48  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 **/

#include <stdlib.h>
#include <memory.h>

#include <tk.h>
#include <tcl.h>
#include <vwTable.h>
#include <vwTableCell.h>
#include <vwTableColor.h>
#include <vwTableMap.h>

#include <vwHash.h>
#include <vwStack.h>

#define VWT_PushColor(vwptr, vwcell, vwcolor)   VWStack_Push(&((vwcell)->colors), vwcolor)
#define Allocate_Cell(xx) \
   if ((xx)[0] == NULL) (xx)[0] = (VWTableCell *) calloc(1, sizeof(VWTableCell))

static unsigned long mapping_size = sizeof(Display*) + 2 * sizeof(Tk_3DBorder) ;

/************************************************************************
 ** VWTableColorPair*
 ** VWT_GetColorPair( VWTable      *vwptr,
 **                   Tcl_Interp   *interp,
 **                   char         *forename,
 **                   char         *backname )
 **
 ** Doesn't make sense to have these opaque things floating around
 ************************************************************************/

#define GetColor(interp, vwptr, name) \
  (((name)[0] == 0x0) ? (NULL) : (Tk_Get3DBorder(interp, (vwptr)->tkWin, None, Tk_GetUid(name))))

#ifdef __STDC__
VWTableColorPair*
VWT_GetColorPair( VWTable*             vwptr,
                  Tcl_Interp*          interp,
                  char*                forename,
                  char*                backname )
#else /** __STDC__ **/
VWTableColorPair*
VWT_GetColorPair( vwptr, interp, forename, backname )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    char*                forename ;
    char*                backname ;
#endif /** __STDC__ **/
{
  VWTableColorPair  look ;
  VWTableColorPair* color ;
  Tk_3DBorder       foreground ;
  Tk_3DBorder       background ;

  if (((foreground = GetColor(interp, vwptr, forename)) == NULL) ||
      ((background = GetColor(interp, vwptr, backname)) == NULL))
    {
      Tk_Free3DBorder(foreground) ;
      return NULL ;
    }

  look.dpy = vwptr->display ;
  look.fg  = Tk_3DBorderColor(foreground)->pixel ;
  look.bg  = Tk_3DBorderColor(background)->pixel ;

  if (! VWT_FindMapping(&look, mapping_size, (void **) &color))
    {
      color = (VWTableColorPair *) malloc(sizeof(VWTableColorPair)) ;
      color->dpy = vwptr->display ;
      color->foreground = foreground ;
      color->background = background ;
      color->fg = look.fg ;
      color->bg = look.bg ;
      color->references = 0 ;

      VWT_InsertMapping(color, mapping_size, color) ;
    }
  else
    {
      Tk_Free3DBorder(foreground) ;
      Tk_Free3DBorder(background) ;
    }

  return color ;
}

/************************************************************************
 ** int
 ** VWT_PopColor( VWTableCell* vwcell )
 **
 ** Pops a color off the stack.  If the color has no more references
 ** it is freed.  This function returns 1 if a color was popped or
 ** 0 when there is nothing left on the stack
 ************************************************************************/

#ifdef __STDC__
int
VWT_PopColor( VWTableCell*    vwcell )
#else /** __STDC__ **/
int
VWT_PopColor( vwcell )
    VWTableCell*    vwcell ;
#endif /** __STDC__ **/
{
  VWTableColorPair *vwcolor ;

  if (vwcell == NULL)
    return 0 ;

  vwcolor = (VWTableColorPair *) VWStack_Pop(&(vwcell->colors)) ;
  if (vwcolor == NULL)
    return 0 ;
      
  vwcolor->references-- ;
  if (! vwcolor->references)
    {
      VWT_RemoveMapping(vwcolor, mapping_size, NULL) ;
      free((char *) vwcolor) ;
    }

  vwcell->changed = TRUE ;
  return 1 ;
}

/************************************************************************
 ** int
 ** VWT_HandlePushColor( VWTable     *vwptr,
 **                      Tcl_Interp  *interp,
 **                      int          argc,
 **                      char        *argv[] )
 **
 ** Pushes a color onto the color stack of cell(s)
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandlePushColor( VWTable*             vwptr,
                     Tcl_Interp*          interp,
                     int                  argc,
                     char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandlePushColor( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int  x, x1, x2 ;
  int  y, y1, y2 ;

  VWTableCell      **vwcell ;
  VWTableColorPair  *vwcolor ;

  if (( argc < 7 ) || ( argc == 8 ))
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ", argv[2],
		       " x1 y1 ? x2 y2 ? foreground background\"",
		       NULL);
      return TCL_ERROR ;
    }

  if (argc == 7)
    {
      if ((VWT_GetBoundingPoint(interp, argv[3], &x, vwptr->columns, TRUE) != TCL_OK) ||
	  (VWT_GetBoundingPoint(interp, argv[4], &y, vwptr->rows, TRUE) != TCL_OK))
	return TCL_ERROR ;

      /** If no cell exists... make one **/

      vwcell = VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0) ;
      Allocate_Cell(vwcell) ;

      vwcolor = VWT_GetColorPair(vwptr, interp, argv[5], argv[6]) ;
      if (vwcolor == NULL)
	return TCL_ERROR ;

      vwcolor->references++ ;
      VWT_PushColor(vwptr, vwcell[0], vwcolor) ;
      vwcell[0]->changed = TRUE ;

      return TCL_OK ;
    }

  /**
   ** Get the bounding region (x1, y1, x2, y2) to
   ** apply the highlight to
   **/

  if (VWT_GetBoundingBox( interp,
			  vwptr,
			  &x1, &y1,
			  &x2, &y2,
			  &argv[3],
			  TRUE ) != TCL_OK )
    {
      return TCL_ERROR ;
    }

  if (x1 > x2) { int swap ; swap = x1 ; x1 = x2 ; x2 = swap ; }
  if (y1 > y2) { int swap ; swap = y1 ; y1 = y2 ; y2 = swap ; }

  vwcolor = VWT_GetColorPair(vwptr, interp, argv[7], argv[8]) ;
  if (vwcolor == NULL)
    return TCL_ERROR ;

  vwcolor->references += (x2 - x1 + 1) * (y2 - y1 + 1) ;

  for ( y = y1 ; y <= y2 ; y++ )
    for ( x = x1 ; x <= x2 ; x++ )
      {
	vwcell = VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0) ;
	Allocate_Cell(vwcell) ;

	VWT_PushColor(vwptr, vwcell[0], vwcolor) ;
	vwcell[0]->changed = TRUE ;
      }

  return TCL_OK ;
}

/************************************************************************
 ** int
 ** VWT_HandlePopColor( VWTable     *vwptr,
 **                     Tcl_Interp  *interp,
 **                     int          argc,
 **                     char        *argv[] )
 **
 ** Pops a color off of the color stack of cell(s)
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandlePopColor( VWTable*             vwptr,
                    Tcl_Interp*          interp,
                    int                  argc,
                    char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandlePopColor( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int  x, x1, x2 ;
  int  y, y1, y2 ;

  if (( argc < 5 ) || ( argc == 6 ))
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ", argv[2],
		       " x1 y1 ? x2 y2 ?\"",
		       NULL);
      return TCL_ERROR ;
    }

  if (argc == 5)
    {
      if ((VWT_GetBoundingPoint(interp, argv[3], &x, vwptr->columns, TRUE) != TCL_OK) ||
	  (VWT_GetBoundingPoint(interp, argv[4], &y, vwptr->rows, TRUE) != TCL_OK))
	return TCL_ERROR ;

      VWT_PopColor(*VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0)) ;
      return TCL_OK ;
    }

  /**
   ** Get the bounding region (x1, y1, x2, y2) to
   ** apply the highlight to
   **/

  if (VWT_GetBoundingBox( interp,
			  vwptr,
			  &x1, &y1,
			  &x2, &y2,
			  &argv[3],
			  TRUE ) != TCL_OK )
    {
      return TCL_ERROR ;
    }

  if (x1 > x2) { int swap ; swap = x1 ; x1 = x2 ; x2 = swap ; }
  if (y1 > y2) { int swap ; swap = y1 ; y1 = y2 ; y2 = swap ; }

  for ( y = y1 ; y <= y2 ; y++ )
    for ( x = x1 ; x <= x2 ; x++ )
      {
	VWT_PopColor(*VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0)) ;
      }

  return TCL_OK ;
}

/************************************************************************
 ** int
 ** VWT_HandleClearColor( VWTable     *vwptr,
 **                       Tcl_Interp  *interp,
 **                       int          argc,
 **                       char        *argv[] )
 **
 ** The color is GONE!
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleClearColor( VWTable*             vwptr,
                      Tcl_Interp*          interp,
                      int                  argc,
                      char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleClearColor( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  int  x, x1, x2 ;
  int  y, y1, y2 ;

  VWTableCell      *vwcell ;
  VWTableColorPair *vwcolor ;

  if (( argc < 5 ) || ( argc == 6 ))
    {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
		       argv[0], " ", argv[1], " ", argv[2],
		       " x1 y1 ? x2 y2 ?\"",
		       NULL);
      return TCL_ERROR ;
    }

  if ( argc == 5 )
    {
      if ((VWT_GetBoundingPoint(interp, argv[3], &x, vwptr->columns, TRUE) != TCL_OK) ||
	  (VWT_GetBoundingPoint(interp, argv[4], &y, vwptr->rows, TRUE) != TCL_OK))
	return TCL_ERROR ;
      
      vwcell = *VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0) ;
      vwcell->changed = TRUE ;

      while ((vwcolor = (VWTableColorPair *) VWStack_Pop(&vwcell->colors)))
	{
	  vwcolor->references-- ;
	  if (! vwcolor->references)
	    {
	      VWT_RemoveMapping(vwcolor, mapping_size, NULL) ;
	      free((char *) vwcolor) ;
	    }
	}

      return TCL_OK ;
    }

  /**
   ** Get the bounding region (x1, y1, x2, y2) to
   ** apply the highlight to
   **/

  if (VWT_GetBoundingBox( interp,
			  vwptr,
			  &x1, &y1,
			  &x2, &y2,
			  &argv[3],
			  TRUE ) != TCL_OK )
    {
      return TCL_ERROR ;
    }

  if (x1 > x2) { int swap ; swap = x1 ; x1 = x2 ; x2 = swap ; }
  if (y1 > y2) { int swap ; swap = y1 ; y1 = y2 ; y2 = swap ; }

  for ( y = y1 ; y <= y2 ; y++ )
    for ( x = x1 ; x <= x2 ; x++ )
      {
	vwcell = *VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0) ;
	vwcell->changed = TRUE ;

	while ((vwcolor = (VWTableColorPair *) VWStack_Pop(&vwcell->colors)))
	  {
	    vwcolor->references-- ;
	    if (! vwcolor->references)
	      {
		VWT_RemoveMapping(vwcolor, mapping_size, NULL) ;
		free((char *) vwcolor) ;
	      }
	  }
      }

  return TCL_OK ;
}



