/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableBound.c,v 1.1.1.1 1994/10/21 13:35:22 aajackso Exp $" ;

/**
 ** $Log: vwTableBound.c,v $
 * Revision 1.1.1.1  1994/10/21  13:35:22  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * *** empty log message ***
 *
 * Revision 1.0.0.1  1994/08/18  00:05:48  aaron
 * *** empty log message ***
 *
 * Revision 1.0  1994/08/17  23:54:06  aaron
 * Initial revision
 *
 **/

#include <stdlib.h>
#include <memory.h>

#include <tk.h>
#include <tcl.h>
#include <vwTable.h>

/************************************************************************
 ** int
 ** VWT_GetBoundingDimension( Tcl_Interp   *interp,
 **                               char         *arg,
 **                               int          *size,
 **                               int           curSize )
 **
 ** Get bounding dimensions (as opposed to points)
 ************************************************************************/

#ifdef __STDC__
int
VWT_GetBoundingDimension( Tcl_Interp*             interp,
                          char*                   arg,
                          int*                    size,
                          int                     curSize )
#else /** __STDC__ **/
int
VWT_GetBoundingDimension( interp, arg, size, curSize )
    Tcl_Interp*             interp ;
    char*                   arg ;
    int*                    size ;
    int                     curSize ;
#endif /** __STDC__ **/
{
  if (! strcmp(arg, "@current"))
    *size = curSize ;
  else if (Tcl_GetInt(interp, arg, size) != TCL_OK)
    return TCL_ERROR ;

  return TCL_OK ;
}

/************************************************************************
 ** int
 ** VWT_GetBoundingPoint( Tcl_Interp   *interp,
 **                           char         *arg,
 **                           int          *pt,
 **                           int           maximum )
 **
 ** Just some clean up code
 ************************************************************************/

#ifdef __STDC__
int
VWT_GetBoundingPoint( Tcl_Interp*                interp,
                      char*                      arg,
                      int*                       pt,
                      int                        max,
                      int                        leaveErr )
#else /** __STDC__ **/
int
VWT_GetBoundingPoint( interp, arg, pt, max, leaveErr )
    Tcl_Interp*                interp ;
    char*                      arg ;
    int*                       pt ;
    int                        max ;
    int                        leaveErr ;
#endif /** __STDC__ **/
{
  --max ;

  if (! strcmp(arg, "end"))
    pt[0] = max ;
  else if (Tcl_GetInt(interp, arg, pt) != TCL_OK)
    return TCL_ERROR ;
  else if ((pt[0] < 0) || (pt[0] > max))
    {
      if (leaveErr)
	{
	  Tcl_AppendResult(interp,
			   "point outside of bounds: \"", arg, "\"",
			   NULL);
	}
      return TCL_ERROR ;
    }

  return TCL_OK ;
}

/************************************************************************
 ** int
 ** VWT_GetBoundingBox( Tcl_Interp   *interp,
 **                         VWTable      *vwptr,
 **                         int          *x1,
 **                         int          *y1,
 **                         int          *x2,
 **                         int          *y2,
 **                         char        **args )
 **
 ** Gets the bounding box given 4 args.  The caller is expected to
 ** ensure that all 4 args are available
 ************************************************************************/

#ifdef __STDC__
int
VWT_GetBoundingBox( Tcl_Interp*                         interp,
                    VWTable*                            vwptr,
                    int*                                x1,
                    int*                                y1,
                    int*                                x2,
                    int*                                y2,
                    char**                              args,
                    int                                 leaveErr )
#else /** __STDC__ **/
int
VWT_GetBoundingBox( interp, vwptr, x1, y1, x2, y2, args, leaveErr )
    Tcl_Interp*                         interp ;
    VWTable*                            vwptr ;
    int*                                x1 ;
    int*                                y1 ;
    int*                                x2 ;
    int*                                y2 ;
    char**                              args ;
    int                                 leaveErr ;
#endif /** __STDC__ **/
{
  if ((VWT_GetBoundingPoint(interp, args[0], x1, vwptr->columns, leaveErr) != TCL_OK) ||
      (VWT_GetBoundingPoint(interp, args[2], x2, vwptr->columns, leaveErr) != TCL_OK) ||
      (VWT_GetBoundingPoint(interp, args[1], y1, vwptr->rows, leaveErr) != TCL_OK) ||
      (VWT_GetBoundingPoint(interp, args[3], y2, vwptr->rows, leaveErr) != TCL_OK))
    return TCL_ERROR ;

  return TCL_OK ;
}

 




