/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/

static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwTableBind.c,v 1.3 1994/11/11 21:36:44 aajackso Exp $" ;

/**
 ** $Log: vwTableBind.c,v $
 * Revision 1.3  1994/11/11  21:36:44  aajackso
 * *** empty log message ***
 *
 * Revision 1.2  1994/10/25  21:10:02  aajackso
 * Oops, added __STDC__ code for most source code and changed the Makefile
 * so that it was consistent w/ the new files
 *
 * Revision 1.1.1.1  1994/10/21  13:35:24  aajackso
 * Table Widget
 *
 **/

#include <stdlib.h>
#include <string.h>

#include <tcl.h>
#include <tk.h>
#include <vwTable.h>

#define Trace_VarFlags (TCL_GLOBAL_ONLY|TCL_TRACE_WRITES|TCL_TRACE_UNSETS)

/************************************************************************
 ** static int
 ** TokenizeArgs( char        *string,
 **               char        *argv[],
 **               int          maxargc )
 **
 ** Tokenizes the arguments and returns argc
 ************************************************************************/

#ifdef __STDC__
static int
TokenizeArgs( char*         string,
              char*         argv[],
              int           maxargc )
#else /** __STDC__ **/
static int
TokenizeArgs( string, argv, maxargc )
    char*         string ;
    char*         argv[] ;
    int           maxargc ;
#endif /** __STDC__ **/
{
  int argc ;

  argv[0] = string ;
  for (argc = 1 ; argc < maxargc ; argc++)
    {
      argv[argc] = strchr(argv[argc - 1], ',') ;
      if (argv[argc] == NULL)
	break ;
      
      argv[argc][0] = 0x0 ;
      argv[argc]++ ;
    }

  return argc ;
}

/************************************************************************
 ** static char*
 ** Handle_VarTrace( ClientData      clientdata,
 **                  Tcl_Interp     *interp,
 **                  char           *name1,
 **                  char           *name2,
 **                  int             flags )
 **
 ************************************************************************/

#ifdef __STDC__
static char*
Handle_VarTrace( ClientData                clientdata,
                 Tcl_Interp*               interp,
                 char*                     name1,
                 char*                     name2,
                 int                       flags )
#else /** __STDC__ **/
static char*
Handle_VarTrace( clientdata, interp, name1, name2, flags )
    ClientData                clientdata ;
    Tcl_Interp*               interp ;
    char*                     name1 ;
    char*                     name2 ;
    int                       flags ;
#endif /** __STDC__ **/
{
  VWTable *vwptr = (VWTable *) clientdata ;

  if (flags & TCL_TRACE_WRITES)
    {
      int             argc ;
      char           *argv[5] ;
      char           *copy ;
      char           *data ;

      int             x ;
      int             y ;
      VWTableCell**   vwcell ;

      data = Tcl_GetVar2(interp, name1, name2, TCL_GLOBAL_ONLY | TCL_LEAVE_ERR_MSG) ;
      if (data == NULL)
	return NULL ;

      copy = (char *) strdup(name2) ;

      argc = TokenizeArgs(copy, argv, 5) ;
      if (argc < 2)
	{
	  free(copy) ;
	  return NULL ;
	}

      if ((VWT_GetBoundingPoint(interp, argv[0], &x, vwptr->columns, TRUE) != TCL_OK) ||
	  (VWT_GetBoundingPoint(interp, argv[1], &y, vwptr->rows, TRUE) != TCL_OK))
	{
	  free(copy) ;
	  return NULL ;
	}

      free(copy) ;

      vwcell = VWMatrixIndex(vwptr->matrix, VWTableCell*, x, y, 0) ;
      VWT_SetElement(vwptr, vwcell, interp, data) ;
      if (( x == vwptr->focus.col ) &&
	  ( y == vwptr->focus.row ))
	{
	  VWT_InstantiateFocus(vwptr, x, y) ;
	}

      return NULL ;
    }

  if (flags & TCL_TRACE_UNSETS)
    {
      Tcl_UntraceVar(interp, vwptr->varName, Trace_VarFlags, 
		     Handle_VarTrace, (ClientData) vwptr) ;

      return NULL ;
    }

  return NULL ;
}

/************************************************************************
 ** void
 ** VWT_ResetBinding( VWTable     *vwptr,
 **                   Tcl_Interp  *interp,
 **                   char         state )
 **
 ** Turns variable tracing ON
 ************************************************************************/

#ifdef __STDC__
void
VWT_ResetBinding( VWTable*         vwptr,
                  Tcl_Interp*      interp,
                  char             state )
#else /** __STDC__ **/
void
VWT_ResetBinding( vwptr, interp, state )
    VWTable*         vwptr ;
    Tcl_Interp*      interp ;
    char             state ;
#endif /** __STDC__ **/
{
  if (! vwptr->varName)
    return ;

  if (state)
    Tcl_TraceVar(interp, vwptr->varName, Trace_VarFlags, 
		 Handle_VarTrace, (ClientData) vwptr) ;
  else
    Tcl_UntraceVar(interp, vwptr->varName, Trace_VarFlags, 
		   Handle_VarTrace, (ClientData) vwptr) ;
}

/************************************************************************
 ** int
 ** VWT_HandleBind( VWTable     *vwptr,
 **                 Tcl_Interp  *interp,
 **                 int          argc,
 **                 char        *argv[] )
 **
 ************************************************************************/

#ifdef __STDC__
int
VWT_HandleBind( VWTable*             vwptr,
                Tcl_Interp*          interp,
                int                  argc,
                char*                argv[] )
#else /** __STDC__ **/
int
VWT_HandleBind( vwptr, interp, argc, argv )
    VWTable*             vwptr ;
    Tcl_Interp*          interp ;
    int                  argc ;
    char*                argv[] ;
#endif /** __STDC__ **/
{
  unsigned long alloc = 0 ;
  char*         data = NULL ;
  char          indx[21] ;  /** 10x10 **/

  register VWTableCell** vwcell ;
  register int           x ;
  register int           y ;

  if (argc == 2)
    {
      if (vwptr->varName)
	Tcl_AppendResult(interp, vwptr->varName, NULL) ;

      return TCL_OK ;
    }

  /**
   ** Remove any old trace which existed
   **/

  VWT_ResetBinding(vwptr, interp, FALSE) ;

  /**
   ** Bind the widget to a variable.  If that variable is
   ** blank, then remove the binding
   **/

  if (! strncmp("", argv[2], strlen(argv[2])))
    return TCL_OK ;

  vwptr->varName = (char *) strdup(argv[2]) ;

  /**
   ** Copy the contents of the current widget to the new
   ** varName
   **/
  
  vwcell = VWMatrixIndex(vwptr->matrix, VWTableCell*, 0, 0, 0) ;
  for ( y = 0 ; y < vwptr->rows ; y++ )
    for ( x = 0 ; x < vwptr->columns ; x++ )
      {
	if (( vwcell[0] == NULL ) || ( !vwcell[0]->dataType ))
	  {
	    vwcell++ ;
	    continue ;
	  }

	sprintf(indx, "%d,%d", x, y);
	VWT_GetData(vwptr, *vwcell, &data, &alloc) ;
	Tcl_SetVar2(interp, vwptr->varName, indx, data, TCL_GLOBAL_ONLY) ;
	vwcell++ ;
      }

  if (data)
    free(data) ;

  /**
   ** Reset the "write" trace
   **/

  VWT_ResetBinding(vwptr, interp, TRUE) ;
  return TCL_OK ;
}
