#ifndef VWTable_H
#define VWTable_H

typedef struct VWTable VWTable ;

#include <vwBits.h>
#include <vwRefer.h>
#include <vwMatrix.h>
#include <vwTableCell.h>
#include <vwTableFocus.h>
#include <vwTableImage.h>
#include <ansi_args.h>

struct         VWTable
{
  Display       *display ;
  Tcl_Interp    *interp ;
  Tk_Window      tkWin ;
  GC             gc ;
  Cursor         cursor ;

  VWTableImage   image ;          /* All data pertaining to the image */
  VWBitset       hide[2] ;
  VWBitset       flux[2] ;        /* Shifts in the pixmap (by atomic) are kept here */
  VWMatrix       matrix ;         /* All data cells (VWTableCell) */
  VWTableFocus   focus ;          /* Data needed to maintain cell focus */

  int            redrawOutline ;
  int            redrawBackground ;
  int            scrollOccurred ;

  char          *geometry ;

  int            cellRelief ;
  int            cellBorderWidth ;

  int            relief ;
  int            borderWidth ;

  Tk_3DBorder    bgBorder ;
  Tk_3DBorder    fgBorder ;

  int            updatePending ;

  int            rows ;
  int            columns ;

  int            vrow ;      /* Visible row    -- i.e. row to far top **/
  int            vcolumn ;   /* Visible column -- i.e. col to far left **/

  int           *columnWidth ;
  int           *rowHeight ;

  char          *xScrollCmd ;
  char          *yScrollCmd ;

  /** This sucks **/

  XFontStruct   *fontPtr ;
  int            fontHeight ;
  int            fontNameLen ;
  char          *fontName ;
  
  /** Bindings **/

  char          *varName ;

  /** Flags **/

  unsigned short flags ;
};

#define VWT_Vertical   (0)
#define VWT_Horizontal (1)

#define VWT_CursorOn   (0x0001)
#define VWT_FocusOn    (0x0002)

EXTERN Tk_ConfigSpec configSpecs[] ;

EXTERN int VWT_HandleGet            _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleSet            _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleSize           _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleXView          _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleYView          _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleWhere          _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleConfig         _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandlePopColor       _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandlePushColor      _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleClearColor     _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandlePopFont        _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandlePushFont       _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleClearFont      _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandlePostRow        _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandlePostColumn     _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleHideRow        _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleHideColumn     _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleBind           _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleInsertRow      _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleDeleteRow      _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleInsertColumn   _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleDeleteColumn   _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleFocusSet       _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleFocusView      _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleFocusIcursor   _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleFocusInsert    _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleFocusIndex     _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleFocusDelete    _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleFocusScanMark  _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleFocusScanDrag  _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleFocusSelClear  _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleFocusSelFrom   _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleFocusSelTo     _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleFocusWhere     _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;
EXTERN int VWT_HandleInfo           _ANSI_ARGS_((VWTable*, Tcl_Interp*, int, char*[])) ;

EXTERN void VWT_Display      _ANSI_ARGS_((ClientData)) ;
EXTERN void VWT_HandleEvent  _ANSI_ARGS_((ClientData, XEvent*));

EXTERN void VWT_ResetScroll  _ANSI_ARGS_((VWTable*));
EXTERN void VWT_ResetColumns _ANSI_ARGS_((VWTable*, int, int));
EXTERN void VWT_ResetRows    _ANSI_ARGS_((VWTable*, int, int));
EXTERN void VWT_SetEntry     _ANSI_ARGS_((VWTable*, int, int, char*));

EXTERN int VWT_InitBitmaps      _ANSI_ARGS_((void));
EXTERN int VWT_FreeBitmap       _ANSI_ARGS_((Display*, Pixmap));
EXTERN Pixmap VWT_GetBitmap     _ANSI_ARGS_((Tcl_Interp*, Tk_Window, char*, VWAddr **,unsigned int*, unsigned int*));

EXTERN int VWT_GetBoundingPoint     _ANSI_ARGS_((Tcl_Interp*, char*, int*, int, int));
EXTERN int VWT_GetBoundingBox       _ANSI_ARGS_((Tcl_Interp*, VWTable*, int*, int*, int*, int*, char**, int));
EXTERN int VWT_GetBoundingDimension _ANSI_ARGS_((Tcl_Interp*, char*, int*, int)) ;


EXTERN int VWT_Create        _ANSI_ARGS_((ClientData, Tcl_Interp*, int, char*[]));
EXTERN int VWT_HandleCommand _ANSI_ARGS_((ClientData, Tcl_Interp*, int, char*[]));
EXTERN int VWT_Configure     _ANSI_ARGS_((Tcl_Interp*, VWTable*, int, char*[], int flags));

EXTERN void VWT_FreeData  _ANSI_ARGS_((VWTable*, VWTableCell*)) ;
EXTERN int  VWT_SetText   _ANSI_ARGS_((VWTable*, VWTableCell**, Tcl_Interp*, char*, Tk_Anchor)) ;
EXTERN int  VWT_SetBitmap _ANSI_ARGS_((VWTable*, VWTableCell**, Tcl_Interp*, char*, Tk_Anchor)) ;
EXTERN void VWT_GetData   _ANSI_ARGS_((VWTable*, VWTableCell*, char**, unsigned long*)) ;

EXTERN int  VWT_VisibleRows    _ANSI_ARGS_((VWTable*)) ;
EXTERN int  VWT_VisibleColumns _ANSI_ARGS_((VWTable*)) ;

EXTERN int VWT_PopFont  _ANSI_ARGS_((VWTableCell*)) ;
EXTERN int VWT_PopColor _ANSI_ARGS_((VWTableCell*)) ;

EXTERN int VWT_UpdateXScroll _ANSI_ARGS_((Tcl_Interp*, VWTable*)) ;
EXTERN int VWT_UpdateYScroll _ANSI_ARGS_((Tcl_Interp*, VWTable*)) ;

EXTERN int VWT_SetElement _ANSI_ARGS_((VWTable*, VWTableCell**, Tcl_Interp*, char*)) ;

EXTERN int  VWT_UnsetFocus _ANSI_ARGS_((VWTable*, Tcl_Interp*)) ;
EXTERN int  VWT_SetFocus   _ANSI_ARGS_((VWTable*, Tcl_Interp*)) ;
EXTERN void VWT_MarkFocus  _ANSI_ARGS_((VWTable*, int, int)) ;

EXTERN int VWT_GetDisplayIndex _ANSI_ARGS_((VWTable*, VWTableCell*, int, const char*, const int)) ;

#ifndef TRUE
#define TRUE     1
#endif

#ifndef FALSE
#define FALSE    0
#endif

#define VWT_NullPixmap ((Pixmap) 0)
#define VWT_BadPixmap ((Pixmap) -1)

#endif /** VWTable_H **/
