/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/


static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwStack.c,v 1.1.1.1 1994/10/21 13:35:21 aajackso Exp $" ;

/**
 ** $Log: vwStack.c,v $
 * Revision 1.1.1.1  1994/10/21  13:35:21  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * Initial revision
 *
 **/

#include <stddef.h>
#include <malloc.h>
#include <vwStack.h>


static VWStackObject*      pool = NULL ;
static int                 pool_depth = 0 ;
static int                 max_depth = 100 ;

/************************************************************************
 ** void
 ** VWStack_Push(VWStack* stack, void* data)
 **
 ** Pushes an object on the stack.  Attempts to reuse memory
 ************************************************************************/

#ifdef __STDC__
void
VWStack_Push( VWStack*       stack,
              void*          data )
#else /** __STDC__ **/
void
VWStack_Push( stack, data )
    VWStack*       stack ;
    void*          data ;
#endif /** __STDC__ **/
{
  VWStackObject* object ;

  if (pool != NULL)
    {
      object = pool ;
      pool = pool->next ;
      pool_depth-- ;
    }
  else
    {
      object = (VWStackObject *) malloc(sizeof(VWStackObject)) ;
    }

  object->data = data ;
  object->next = stack->top ;
  stack->top = object ;
}

/************************************************************************
 ** void*
 ** VWStack_Pop(VWStack* stack)
 **
 ** Pops an object off the stack.  If the memory can be reused via the
 ** pool it is.
 ************************************************************************/

#ifdef __STDC__
void*
VWStack_Pop( VWStack*    stack )
#else /** __STDC__ **/
void*
VWStack_Pop( stack )
    VWStack*    stack ;
#endif /** __STDC__ **/
{
  void* data ;
  VWStackObject* object ;

  if ((stack == NULL) || (stack->top == NULL))
    return NULL ;

  object = stack->top ;
  stack->top = stack->top->next ;

  data = object->data ;
  if (pool_depth < max_depth)
    {
      object->next = pool ;
      pool = object ;
      pool_depth++ ;
    }
  else
    {
      free((char *) object) ;
    }

  return data ;
}
