/************************************************************************
 ** Copyright (c) 1994, Aaron Jackson
 ** All rights reserved
 **
 ** Permission to use, copy, modify, and distribute this software and
 ** its documentation for any purpose and without fee is hereby granted,
 ** provided that the above copyright notice appear in all copies and
 ** that both that copyright notice and this permission notice appear in
 ** supporting documentation.
 **
 ** In no event shall the author(s) be liable to any party for direct,
 ** indirect, special, incidental, or consequential damages arising out
 ** of the use of this software and its documentation, even if the
 ** authors(s) have been advised of the possibility of such damage.
 **
 ** The authors(s) specifically disclaim any warranties, including but
 ** not limited to, the implied warranties of merchantability and
 ** fitness for a particular purpose.  The software provided hereunder
 ** is on an "as is" basis, and the author(s) have no obligation to
 ** provide maintenance, support, updates, enhancements, or modifications
 ************************************************************************/


static char rcsid[] = "$Header: /home/edsdev/cvstree/tcldev/vwtable/vwRefer.c,v 1.1.1.1 1994/10/21 13:35:21 aajackso Exp $" ;

/**
 ** $Log: vwRefer.c,v $
 * Revision 1.1.1.1  1994/10/21  13:35:21  aajackso
 * Table Widget
 *
 * Revision 1.1  1994/08/24  00:55:59  aaron
 * Initial revision
 *
 **/

#include <stdlib.h>
#include <stddef.h>
#include <malloc.h>
#include <memory.h>
#include <vwRefer.h>

#ifndef TRUE
#define TRUE     1
#endif

#ifndef FALSE
#define FALSE    0
#endif

/************************************************************************
 ** int
 ** VWRefer_Initialize( VWAddrTable *table, long blocks )
 **
 ** Initializes a reference table
 ************************************************************************/

#ifdef __STDC__
int
VWRefer_Initialize( VWAddrTable*       table,
                    long               blocks )
#else /** __STDC__ **/
int
VWRefer_Initialize( table, blocks )
    VWAddrTable*       table ;
    long               blocks ;
#endif /** __STDC__ **/
{
  int size = blocks * sizeof(VWAddr*) ;

  table->blocks = blocks ;
  table->references = (VWAddr **) malloc(size) ;

  memset((char *) table->references, 0x0, size) ;
  return TRUE ;
}

/************************************************************************
 ** VWAddr*
 ** VWRefer_GetAddr( VWAddrTable *table, void *ptr )
 **
 ** Creates an address reference.  If the address is already cached
 ** it will return the reference for you
 ************************************************************************/

#ifdef __STDC__
VWAddr*
VWRefer_GetAddr( VWAddrTable*       table,
                 void*              ptr )
#else /** __STDC__ **/
VWAddr*
VWRefer_GetAddr( table, ptr )
    VWAddrTable*       table ;
    void*              ptr ;
#endif /** __STDC__ **/
{
  VWAddr *entry ;
  unsigned long  hash = ((unsigned long) ptr) % table->blocks ;

  for ( entry  = table->references[ hash ] ;
        entry != NULL ;
        entry  = entry->next )
    {
      if ( entry->addr == ptr )
	return entry ;
    }

  entry = (VWAddr *) malloc(sizeof(VWAddr));
  entry->next = table->references[ hash ] ;
  table->references[ hash ] = entry ;
  
  entry->addr = ptr ;
  entry->refs = 0 ;

  return entry ;
}

/************************************************************************
 ** void
 ** VWRefer_RemoveAddr( VWAddrTable *table, void *ptr )
 **
 ** Will remove a reference.  Removal is irrelevant of the indicated
 ** number of references.  This is inherently dangerous but it assumes
 ** that  you will clean up behind yourself
 ************************************************************************/

#ifdef __STDC__
int
VWRefer_RemoveAddr( VWAddrTable*       table,
                    void*              ptr )
#else /** __STDC__ **/
int
VWRefer_RemoveAddr( table, ptr )
    VWAddrTable*       table ;
    void*              ptr ;
#endif /** __STDC__ **/
{
  VWAddr *entry ;
  VWAddr *previous = NULL ;
  unsigned long  hash = ((unsigned long) ptr) % table->blocks ;

  for ( entry  = table->references[ hash ] ;
        entry != NULL ;
        entry  = entry->next )
    {
      if ( entry->addr == ptr )
	{
	  if ( previous == NULL )
	    table->references[ hash ] = table->references[ hash ]->next ;
	  else
	    previous->next = entry->next ;

	  free((char *) entry);
	  return TRUE ;
	}

      previous = entry ;
    }

  return FALSE ;
}
