#ifndef VWHash_H
#define VWHash_H

#include <ansi_args.h>

/**
 ** The functions, methods, etc, documented below are used for
 ** arbitrary hashing keys and arbitrary data
 **/

/**
 ** VWHashNode is a single node is a hash bucket.  Conflict
 ** is resolved via chaining
 **/

typedef struct VWHashNode VWHashNode ;
struct         VWHashNode
{
  void*           key ;
  unsigned long   keysize ;
  void*           addr ;
  unsigned long   addrsize ;
  VWHashNode*     next ;
};

/**
 ** VWHashTable is a chained hash table.  Conflict resolution
 ** is dealt with by chaining the data into a bucket
 **/

typedef struct VWHashTable VWHashTable ;
struct         VWHashTable
{
  unsigned long       size ;
  VWHashNode**        nodes ;

  int               (*comp) _ANSI_ARGS_((void*, void*, unsigned long)) ;
  void              (*free) _ANSI_ARGS_((void*, unsigned long, void*, unsigned long)) ;
  unsigned long     (*hash) _ANSI_ARGS_((void*, unsigned long)) ;
};

EXTERN void VWHashTable_Free   _ANSI_ARGS_((VWHashTable*)) ;
EXTERN void VWHashTable_Alloc  _ANSI_ARGS_((VWHashTable*, unsigned long)) ;
EXTERN int  VWHashTable_Find   _ANSI_ARGS_((VWHashTable*, void*, unsigned long, void**, void**, unsigned long*)) ;
EXTERN int  VWHashTable_Insert _ANSI_ARGS_((VWHashTable*, void*, unsigned long, void*, unsigned long)) ;
EXTERN int  VWHashTable_Remove _ANSI_ARGS_((VWHashTable*, void*, unsigned long, void**, void**, unsigned long*)) ;

typedef int            (*VWHashProc_Comp) _ANSI_ARGS_((void*, void*, unsigned long)) ;
typedef void           (*VWHashProc_Free) _ANSI_ARGS_((void*, unsigned long, void*, unsigned long)) ;
typedef unsigned long  (*VWHashProc_Hash) _ANSI_ARGS_((void*, unsigned long)) ;

#endif /** VWHash_H **/
